/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.Traceable;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.concurrent.AtomicExchange;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;
import org.apache.camel.util.concurrent.SubmitOrderedCompletionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastProcessor
extends ServiceSupport
implements Processor,
Navigate<Processor>,
Traceable {
    private static final int DEFAULT_THREADPOOL_SIZE = 10;
    private static final transient Log LOG = LogFactory.getLog(MulticastProcessor.class);
    private Collection<Processor> processors;
    private final AggregationStrategy aggregationStrategy;
    private final boolean isParallelProcessing;
    private final boolean streaming;
    private final boolean stopOnException;
    private ExecutorService executorService;

    public MulticastProcessor(Collection<Processor> processors) {
        this(processors, null);
    }

    public MulticastProcessor(Collection<Processor> processors, AggregationStrategy aggregationStrategy) {
        this(processors, aggregationStrategy, false, null, false, false);
    }

    public MulticastProcessor(Collection<Processor> processors, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean streaming, boolean stopOnException) {
        ObjectHelper.notNull(processors, "processors");
        this.processors = processors;
        this.aggregationStrategy = aggregationStrategy;
        this.isParallelProcessing = parallelProcessing;
        this.executorService = executorService;
        this.streaming = streaming;
        this.stopOnException = stopOnException;
        if (this.isParallelProcessing() && this.executorService == null) {
            this.executorService = ExecutorServiceHelper.newScheduledThreadPool(10, "Multicast", true);
        }
    }

    public String toString() {
        return "Multicast[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "multicast";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AtomicExchange result = new AtomicExchange();
        Iterable<ProcessorExchangePair> pairs = this.createProcessorExchangePairs(exchange);
        try {
            if (this.isParallelProcessing()) {
                this.doProcessParallel(result, pairs, this.isStreaming());
            } else {
                this.doProcessSequential(result, pairs);
            }
            if (result.get() != null) {
                ExchangeHelper.copyResults(exchange, (Exchange)result.get());
            }
        }
        catch (Exception e) {
            exchange.setProperty("CamelRedeliveryExhausted", Boolean.TRUE);
            exchange.setException(e);
        }
    }

    protected void doProcessParallel(AtomicExchange result, Iterable<ProcessorExchangePair> pairs, boolean streaming) throws InterruptedException, ExecutionException {
        final AtomicBoolean running = new AtomicBoolean(true);
        CompletionService completion = streaming ? new ExecutorCompletionService(this.executorService) : new SubmitOrderedCompletionService(this.executorService);
        final AtomicInteger total = new AtomicInteger(0);
        for (ProcessorExchangePair pair : pairs) {
            final Processor producer = pair.getProcessor();
            final Exchange subExchange = pair.getExchange();
            this.updateNewExchange(subExchange, total.intValue(), pairs);
            completion.submit(new Callable<Exchange>(){

                @Override
                public Exchange call() throws Exception {
                    if (!running.get()) {
                        return subExchange;
                    }
                    MulticastProcessor.this.doProcess(producer, subExchange);
                    if (MulticastProcessor.this.stopOnException && subExchange.getException() != null) {
                        running.set(false);
                        throw new CamelExchangeException("Parallel processing failed for number " + total.intValue(), subExchange, subExchange.getException());
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Parallel processing complete for exchange: " + subExchange));
                    }
                    return subExchange;
                }
            });
            total.incrementAndGet();
        }
        for (int i = 0; i < total.intValue(); ++i) {
            Future future = completion.take();
            Exchange subExchange = (Exchange)future.get();
            if (this.aggregationStrategy == null) continue;
            this.doAggregate(result, subExchange);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done parallel processing " + total + " exchanges"));
        }
    }

    protected void doProcessSequential(AtomicExchange result, Iterable<ProcessorExchangePair> pairs) throws Exception {
        int total = 0;
        for (ProcessorExchangePair pair : pairs) {
            Processor producer = pair.getProcessor();
            Exchange subExchange = pair.getExchange();
            this.updateNewExchange(subExchange, total, pairs);
            this.doProcess(producer, subExchange);
            if (this.stopOnException && subExchange.getException() != null) {
                throw new CamelExchangeException("Sequential processing failed for number " + total, subExchange, subExchange.getException());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Sequential processing complete for number " + total + " exchange: " + subExchange));
            }
            if (this.aggregationStrategy != null) {
                this.doAggregate(result, subExchange);
            }
            ++total;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done sequential processing " + total + " exchanges"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(Processor producer, Exchange exchange) {
        TracedRouteNodes traced = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getTracedRouteNodes() : null;
        try {
            if (traced != null) {
                traced.pushBlock();
            }
            MulticastProcessor.setToEndpoint(exchange, producer);
            if (exchange.getUnitOfWork() != null && exchange.getUnitOfWork().getRouteContext() != null) {
                RouteContext routeContext = exchange.getUnitOfWork().getRouteContext();
                ErrorHandlerBuilder builder = routeContext.getRoute().getErrorHandlerBuilder();
                producer = builder.createErrorHandler(routeContext, producer);
            }
            producer.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        finally {
            if (traced != null) {
                traced.popBlock();
            }
        }
    }

    protected synchronized void doAggregate(AtomicExchange result, Exchange exchange) {
        if (this.aggregationStrategy != null) {
            Exchange oldExchange = (Exchange)result.get();
            ExchangeHelper.prepareAggregation(oldExchange, exchange);
            result.set(this.aggregationStrategy.aggregate(oldExchange, exchange));
        }
    }

    protected void updateNewExchange(Exchange exchange, int index, Iterable<ProcessorExchangePair> allPairs) {
        exchange.setProperty("CamelMulticastIndex", index);
    }

    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>(this.processors.size());
        for (Processor processor : this.processors) {
            Exchange copy = exchange.copy();
            result.add(new ProcessorExchangePair(processor, copy));
        }
        return result;
    }

    @Override
    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService.awaitTermination(0L, TimeUnit.SECONDS);
            this.executorService = null;
        }
        ServiceHelper.stopServices(this.processors);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processors);
    }

    private static void setToEndpoint(Exchange exchange, Processor processor) {
        if (processor instanceof Producer) {
            Producer producer = (Producer)processor;
            exchange.setProperty("CamelToEndpoint", producer.getEndpoint().getEndpointUri());
        }
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isStopOnException() {
        return this.stopOnException;
    }

    public Collection<Processor> getProcessors() {
        return this.processors;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public boolean isParallelProcessing() {
        return this.isParallelProcessing;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        return new ArrayList<Processor>(this.processors);
    }

    @Override
    public boolean hasNext() {
        return this.processors != null && !this.processors.isEmpty();
    }

    static class ProcessorExchangePair {
        private final Processor processor;
        private final Exchange exchange;

        public ProcessorExchangePair(Processor processor, Exchange exchange) {
            this.processor = processor;
            this.exchange = exchange;
        }

        public Processor getProcessor() {
            return this.processor;
        }

        public Exchange getExchange() {
            return this.exchange;
        }
    }
}

