/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveMap
extends HashMap<String, Object> {
    private static final long serialVersionUID = -8538318195477618308L;
    private Map<String, String> originalKeys;
    private transient Set<Map.Entry<String, Object>> entrySetView;

    public CaseInsensitiveMap() {
        this.originalKeys = new HashMap<String, String>();
    }

    public CaseInsensitiveMap(Map<? extends String, ?> map) {
        this();
        this.putAll(map);
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.originalKeys = new HashMap<String, String>(initialCapacity);
    }

    public CaseInsensitiveMap(int initialCapacity) {
        super(initialCapacity);
        this.originalKeys = new HashMap<String, String>();
    }

    @Override
    public Object get(Object key) {
        String s = key.toString().toLowerCase();
        Object answer = super.get(s);
        if (answer == null) {
            String originalKey = this.originalKeys.get(s);
            answer = super.get(originalKey);
        }
        return answer;
    }

    @Override
    public Object put(String key, Object value) {
        this.entrySetView = null;
        String s = key.toLowerCase();
        this.originalKeys.put(s, key);
        return super.put(s, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        this.entrySetView = null;
        String s = key.toString().toLowerCase();
        this.originalKeys.remove(s);
        return super.remove(s);
    }

    @Override
    public void clear() {
        this.entrySetView = null;
        this.originalKeys.clear();
        super.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        String s = key.toString().toLowerCase();
        return super.containsKey(s);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySetView == null) {
            this.entrySetView = new HashSet<Map.Entry<String, Object>>(this.size());
            for (final Map.Entry entry : super.entrySet()) {
                Map.Entry<String, Object> view = new Map.Entry<String, Object>(){

                    @Override
                    public String getKey() {
                        String s = (String)entry.getKey();
                        return (String)CaseInsensitiveMap.this.originalKeys.get(s);
                    }

                    @Override
                    public Object getValue() {
                        return entry.getValue();
                    }

                    @Override
                    public Object setValue(Object o) {
                        return entry.setValue(o);
                    }
                };
                this.entrySetView.add(view);
            }
        }
        return this.entrySetView;
    }
}

