/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.apache.cxf.jaxrs.provider.JSONUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Provider
public class JSONProvider
extends AbstractJAXBProvider {
    private static final String MAPPED_CONVENTION = "mapped";
    private static final String BADGER_FISH_CONVENTION = "badgerfish";
    private ConcurrentHashMap<String, String> namespaceMap = new ConcurrentHashMap();
    private boolean serializeAsArray;
    private List<String> arrayKeys;
    private boolean unwrapped;
    private String wrapperName;
    private Map<String, String> wrapperMap;
    private boolean dropRootElement;
    private boolean dropCollectionWrapperElement;
    private boolean ignoreMixedContent;
    private boolean writeXsiType = true;
    private boolean readXsiType = true;
    private boolean ignoreNamespaces;
    private String convention = "mapped";

    public void setConvention(String value) {
        if (!MAPPED_CONVENTION.equals(value) && !BADGER_FISH_CONVENTION.equals(value)) {
            throw new IllegalArgumentException("Unsupported convention \"" + value);
        }
        this.convention = value;
    }

    public void setIgnoreNamespaces(boolean ignoreNamespaces) {
        this.ignoreNamespaces = ignoreNamespaces;
    }

    @Context
    public void setMessageContext(MessageContext mc) {
        super.setContext(mc);
    }

    public void setDropRootElement(boolean drop) {
        this.dropRootElement = drop;
    }

    public void setDropCollectionWrapperElement(boolean drop) {
        this.dropCollectionWrapperElement = drop;
    }

    public void setIgnoreMixedContent(boolean ignore) {
        this.ignoreMixedContent = ignore;
    }

    public void setSupportUnwrapped(boolean unwrap) {
        this.unwrapped = unwrap;
    }

    public void setWrapperName(String wName) {
        this.wrapperName = wName;
    }

    public void setWrapperMap(Map<String, String> map) {
        this.wrapperMap = map;
    }

    @Override
    public void setEnableBuffering(boolean enableBuf) {
        super.setEnableBuffering(enableBuf);
    }

    @Override
    public void setConsumeMediaTypes(List<String> types) {
        super.setConsumeMediaTypes(types);
    }

    @Override
    public void setProduceMediaTypes(List<String> types) {
        super.setProduceMediaTypes(types);
    }

    public void setSchemas(List<String> locations) {
        super.setSchemaLocations(locations);
    }

    public void setSchemaHandler(SchemaHandler handler) {
        super.setSchema(handler.getSchema());
    }

    public void setSerializeAsArray(boolean asArray) {
        this.serializeAsArray = asArray;
    }

    public void setArrayKeys(List<String> keys) {
        this.arrayKeys = keys;
    }

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        this.namespaceMap.putAll(namespaceMap);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            Class<?> theType = this.getActualType(type, genericType, anns);
            Unmarshaller unmarshaller = this.createUnmarshaller(theType, genericType);
            InputStream realStream = this.getInputStream(type, genericType, is);
            XMLStreamReader xsw = this.createReader(type, realStream);
            Object response = null;
            response = JAXBElement.class.isAssignableFrom(type) || this.unmarshalAsJaxbElement || this.jaxbElementClassMap != null && this.jaxbElementClassMap.containsKey(theType.getName()) ? unmarshaller.unmarshal(xsw, theType) : unmarshaller.unmarshal(xsw);
            if (response instanceof JAXBElement && !JAXBElement.class.isAssignableFrom(type)) {
                response = response.getValue();
            }
            response = this.checkAdapter(response, anns, false);
            return response;
        }
        catch (JAXBException e) {
            JSONProvider.handleJAXBException(e);
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        return null;
    }

    protected XMLStreamReader createReader(Class<?> type, InputStream is) throws Exception {
        if (BADGER_FISH_CONVENTION.equals(this.convention)) {
            return JSONUtils.createBadgerFishReader(is);
        }
        XMLStreamReader reader = JSONUtils.createStreamReader(is, this.readXsiType, this.namespaceMap);
        return this.createTransformReaderIfNeeded(reader, is);
    }

    protected InputStream getInputStream(Class<Object> cls, Type type, InputStream is) throws Exception {
        if (this.unwrapped) {
            String rootName = this.getRootName(cls, type);
            ByteArrayInputStream isBefore = new ByteArrayInputStream(rootName.getBytes());
            String after = "}";
            ByteArrayInputStream isAfter = new ByteArrayInputStream(after.getBytes());
            final InputStream[] streams = new InputStream[]{isBefore, is, isAfter};
            Enumeration<InputStream> list = new Enumeration<InputStream>(){
                private int index;

                @Override
                public boolean hasMoreElements() {
                    return this.index < streams.length;
                }

                @Override
                public InputStream nextElement() {
                    return streams[this.index++];
                }
            };
            return new SequenceInputStream((Enumeration<? extends InputStream>)list);
        }
        return is;
    }

    protected String getRootName(Class<Object> cls, Type type) throws Exception {
        QName qname;
        String name = null;
        if (this.wrapperName != null) {
            name = this.wrapperName;
        } else if (this.wrapperMap != null) {
            name = this.wrapperMap.get(cls.getName());
        }
        if (name == null && (qname = this.getQName(cls, type, null, false)) != null) {
            name = qname.getLocalPart();
            String prefix = qname.getPrefix();
            if (prefix.length() > 0) {
                name = prefix + "." + name;
            }
        }
        if (name == null) {
            throw new WebApplicationException(500);
        }
        return "{\"" + name + "\":";
    }

    public void writeTo(Object obj, Class<?> cls, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        try {
            String encoding;
            Class<?> actualClass;
            Object actualObject = this.checkAdapter(obj, anns, true);
            Class<?> clazz = actualClass = obj != actualObject ? actualObject.getClass() : cls;
            if (cls == genericType) {
                genericType = actualClass;
            }
            if ((encoding = this.getEncoding(m, headers)) == null) {
                encoding = "UTF-8";
            }
            if (InjectionUtils.isSupportedCollectionOrArray(actualClass)) {
                actualClass = InjectionUtils.getActualType(genericType);
                this.marshalCollection(cls, actualObject, actualClass, genericType, encoding, os, m);
            } else {
                this.marshal(actualObject, actualClass, genericType, encoding, os);
            }
        }
        catch (JAXBException e) {
            JSONProvider.handleJAXBException(e);
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected void marshalCollection(Class<?> originalCls, Object actualObject, Class<?> actualClass, Type genericType, String encoding, OutputStream os, MediaType m) throws Exception {
        String startTag = null;
        String endTag = null;
        if (!this.dropCollectionWrapperElement) {
            QName qname = this.getCollectionWrapperQName(actualClass, genericType, actualObject, false);
            if (qname == null) {
                String message = new Message("NO_COLLECTION_ROOT", BUNDLE, new Object[0]).toString();
                throw new WebApplicationException(Response.serverError().entity((Object)message).build());
            }
            startTag = qname.getNamespaceURI().length() > 0 ? "{\"ns1." + qname.getLocalPart() + "\":[" : "{\"" + qname.getLocalPart() + "\":[";
            endTag = "]}";
        } else if (this.serializeAsArray) {
            startTag = "[";
            endTag = "]";
        } else {
            startTag = "{";
            endTag = "}";
        }
        os.write(startTag.getBytes());
        Object[] arr = originalCls.isArray() ? (Object[])actualObject : ((Collection)actualObject).toArray();
        for (int i = 0; i < arr.length; ++i) {
            Object obj = this.convertToJaxbElementIfNeeded(arr[i], actualClass, genericType);
            Class<Object> cls = actualClass;
            if (obj instanceof JAXBElement && actualClass != JAXBElement.class) {
                cls = JAXBElement.class;
            }
            Marshaller ms = this.createMarshaller(obj, cls, genericType, encoding);
            this.marshal(ms, obj, cls, genericType, encoding, os, true);
            if (i + 1 >= arr.length) continue;
            os.write(",".getBytes());
        }
        os.write(endTag.getBytes());
    }

    protected void marshal(Marshaller ms, Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os, boolean isCollection) throws Exception {
        XMLStreamWriter writer = this.createWriter(actualObject, actualClass, genericType, enc, os, isCollection);
        ms.marshal(actualObject, writer);
        writer.close();
    }

    protected XMLStreamWriter createWriter(Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os, boolean isCollection) throws Exception {
        if (BADGER_FISH_CONVENTION.equals(this.convention)) {
            return JSONUtils.createBadgerFishWriter(os);
        }
        QName qname = this.getQName(actualClass, genericType, actualObject, true);
        XMLStreamWriter writer = JSONUtils.createStreamWriter(os, qname, this.writeXsiType && !this.ignoreNamespaces, this.namespaceMap, this.serializeAsArray, this.arrayKeys, isCollection || this.dropRootElement);
        writer = JSONUtils.createIgnoreMixedContentWriterIfNeeded(writer, this.ignoreMixedContent);
        writer = JSONUtils.createIgnoreNsWriterIfNeeded(writer, this.ignoreNamespaces);
        return this.createTransformWriterIfNeeded(writer, os);
    }

    protected void marshal(Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os) throws Exception {
        if ((actualObject = this.convertToJaxbElementIfNeeded(actualObject, actualClass, genericType)) instanceof JAXBElement && actualClass != JAXBElement.class) {
            actualClass = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(actualObject, actualClass, genericType, enc);
        this.marshal(ms, actualObject, actualClass, genericType, enc, os, false);
    }

    private QName getQName(Class<?> cls, Type type, Object object, boolean allocatePrefix) throws Exception {
        QName qname = this.getJaxbQName(cls, type, object, false);
        if (qname != null) {
            String prefix = this.getPrefix(qname.getNamespaceURI(), allocatePrefix);
            return new QName(qname.getNamespaceURI(), qname.getLocalPart(), prefix);
        }
        return null;
    }

    private String getPrefix(String namespace, boolean allocatePrefix) {
        String prefix = this.namespaceMap.get(namespace);
        if (prefix == null) {
            if (allocatePrefix && namespace.length() > 0) {
                prefix = "ns" + (this.namespaceMap.size() + 1);
                this.namespaceMap.put(namespace, prefix);
            } else {
                prefix = "";
            }
        }
        return prefix;
    }

    public void setWriteXsiType(boolean writeXsiType) {
        this.writeXsiType = writeXsiType;
    }

    public void setReadXsiType(boolean readXsiType) {
        this.readXsiType = readXsiType;
    }
}

