/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.modifier;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.Version;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.deployment.ws.ServiceRefDesc;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Application;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.DummyApplication;
import org.ow2.jonas.generators.genbase.archive.DummyWebApp;
import org.ow2.jonas.generators.genbase.archive.Ejb;
import org.ow2.jonas.generators.genbase.archive.EjbJar;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.genbase.modifier.ArchiveModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.ContextDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.DeploymentDescModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WebJettyDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WsClientDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WsEndpointDDModifier;
import org.ow2.jonas.generators.wsgen.generator.Generator;
import org.ow2.jonas.generators.wsgen.generator.GeneratorFactory;
import org.ow2.jonas.generators.wsgen.generator.SecurityGenerator;
import org.ow2.jonas.generators.wsgen.modifier.ApplicationModifier;
import org.w3c.dom.Document;

public class EjbJarModifier
extends ArchiveModifier {
    private EjbJar ejbjar = null;

    public EjbJarModifier(EjbJar ejbjar) {
        super((J2EEArchive)ejbjar);
        this.ejbjar = ejbjar;
    }

    public Archive modify() throws GenBaseException {
        Generator g;
        DeploymentDescModifier ddm;
        EjbJarModifier.getLogger().log(BasicLevel.INFO, (Object)("Processing EjbJar " + this.ejbjar.getName()));
        Attributes main = this.ejbjar.getManifest().getMainAttributes();
        if (this.getArchive() != null && this.getArchive().getArchive() != null) {
            main.putAll((Map<?, ?>)this.getArchive().getArchive().getManifest().getMainAttributes());
        }
        main.put(new Attributes.Name("WsGen-JOnAS-Version"), Version.getNumber());
        GeneratorFactory gf = GeneratorFactory.getInstance();
        Document jejbjar = this.ejbjar.getJonasEjbJarDoc();
        List sds = this.ejbjar.getServiceDescs();
        if (sds.size() != 0) {
            if (this.ejbjar.getApplication() == null) {
                String ejbName = this.ejbjar.getRootFile().getName();
                String earName = ejbName.substring(0, ejbName.length() - ".jar".length()) + ".ear";
                DummyApplication application = new DummyApplication(earName);
                this.ejbjar.setApplication((Application)application);
                application.addEjbJar(this.ejbjar);
                ApplicationModifier am = new ApplicationModifier((Application)application);
                return am.modify();
            }
            String warName = null;
            String war = this.ejbjar.getWarName();
            if (war != null) {
                warName = war;
            } else {
                String ejbName = this.ejbjar.getRootFile().getName();
                String contextName = ejbName.substring(0, ejbName.length() - ".jar".length());
                warName = contextName + ".war";
            }
            Application application = this.ejbjar.getApplication();
            DummyWebApp web = new DummyWebApp(application, warName);
            for (ServiceDesc sd : sds) {
                ddm = new WsEndpointDDModifier(web.getWebAppDoc());
                g = gf.newGenerator(sd, (WsEndpointDDModifier)ddm, null, (Archive)this.ejbjar);
                g.generate();
                g.compile();
                g.addFiles((Archive)web);
                Document context = web.getContextDoc();
                if (context == null) {
                    context = web.newContextDoc();
                }
                ContextDDModifier cddm = new ContextDDModifier(context);
                Document webJetty = web.getWebJettyDoc();
                if (webJetty == null) {
                    webJetty = web.newWebJettyDoc();
                }
                WebJettyDDModifier wjddm = new WebJettyDDModifier(webJetty);
                Document jonaswebservices = this.ejbjar.getJonasWebservicesDoc();
                SecurityGenerator sm = new SecurityGenerator(jonaswebservices);
                sm.generate((WsEndpointDDModifier)ddm, cddm, wjddm);
            }
            application.addWebApp(new WebApp(EjbJarModifier.save((Config)gf.getConfiguration(), (String)("webapps" + File.separator + web.getName()), (J2EEArchive)web)), this.ejbjar.getContextRoot());
        }
        List ejbs = this.ejbjar.getEjbs();
        for (Ejb ejb : ejbs) {
            List refs = ejb.getServiceRefDescs();
            for (ServiceRefDesc ref : refs) {
                ddm = new WsClientDDModifier(ref.getServiceRefName(), jejbjar, ejb.getJonasBeanElement());
                g = gf.newGenerator(ref, (WsClientDDModifier)ddm, (Archive)this.ejbjar);
                g.generate();
                g.compile();
                g.addFiles((Archive)this.ejbjar);
            }
        }
        return this.save(gf.getConfiguration(), "ejbjars" + File.separator + this.ejbjar.getRootFile().getName());
    }
}

