/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.requestor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.camel.Message;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsProducer;
import org.apache.camel.component.jms.requestor.DeferredRequestReplyMap;
import org.apache.camel.component.jms.requestor.FailedToProcessResponse;
import org.apache.camel.component.jms.requestor.FutureHandler;
import org.apache.camel.component.jms.requestor.ReplyHandler;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.DefaultTimeoutMap;
import org.apache.camel.util.TimeoutMap;
import org.apache.camel.util.UuidGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer102;
import org.springframework.jms.support.destination.DestinationResolver;

public class Requestor
extends ServiceSupport
implements MessageListener {
    private static final transient Log LOG = LogFactory.getLog(Requestor.class);
    private static UuidGenerator uuidGenerator;
    private final JmsConfiguration configuration;
    private ScheduledExecutorService executorService;
    private AbstractMessageListenerContainer listenerContainer;
    private TimeoutMap requestMap;
    private Map<JmsProducer, DeferredRequestReplyMap> producerDeferredRequestReplyMap;
    private TimeoutMap deferredRequestMap;
    private TimeoutMap deferredReplyMap;
    private Destination replyTo;
    private long maxRequestTimeout = -1L;
    private long replyToResolverTimeout = 5000L;

    public Requestor(JmsConfiguration configuration, ScheduledExecutorService executorService) {
        this.configuration = configuration;
        this.executorService = executorService;
        this.requestMap = new DefaultTimeoutMap(executorService, configuration.getRequestMapPurgePollTimeMillis());
        this.producerDeferredRequestReplyMap = new HashMap<JmsProducer, DeferredRequestReplyMap>();
        this.deferredRequestMap = new DefaultTimeoutMap(executorService, configuration.getRequestMapPurgePollTimeMillis());
        this.deferredReplyMap = new DefaultTimeoutMap(executorService, configuration.getRequestMapPurgePollTimeMillis());
    }

    public synchronized DeferredRequestReplyMap getDeferredRequestReplyMap(JmsProducer producer) {
        DeferredRequestReplyMap map = this.producerDeferredRequestReplyMap.get((Object)producer);
        if (map == null) {
            map = new DeferredRequestReplyMap(this, producer, this.deferredRequestMap, this.deferredReplyMap);
            this.producerDeferredRequestReplyMap.put(producer, map);
            if (this.maxRequestTimeout == -1L) {
                this.maxRequestTimeout = producer.getRequestTimeout();
            } else if (this.maxRequestTimeout < producer.getRequestTimeout()) {
                this.maxRequestTimeout = producer.getRequestTimeout();
            }
        }
        return map;
    }

    public synchronized void removeDeferredRequestReplyMap(JmsProducer producer) {
        DeferredRequestReplyMap map = this.producerDeferredRequestReplyMap.remove((Object)producer);
        if (map == null) {
            return;
        }
        if (this.maxRequestTimeout == producer.getRequestTimeout()) {
            long max = -1L;
            for (Map.Entry<JmsProducer, DeferredRequestReplyMap> entry : this.producerDeferredRequestReplyMap.entrySet()) {
                if (max >= entry.getKey().getRequestTimeout()) continue;
                max = entry.getKey().getRequestTimeout();
            }
            this.maxRequestTimeout = max;
        }
    }

    public synchronized long getMaxRequestTimeout() {
        return this.maxRequestTimeout;
    }

    public TimeoutMap getRequestMap() {
        return this.requestMap;
    }

    public TimeoutMap getDeferredRequestMap() {
        return this.deferredRequestMap;
    }

    public TimeoutMap getDeferredReplyMap() {
        return this.deferredReplyMap;
    }

    public FutureTask getReceiveFuture(String correlationID, long requestTimeout) {
        FutureHandler future = this.createFutureHandler(correlationID);
        this.requestMap.put((Object)correlationID, (Object)future, requestTimeout);
        return future;
    }

    public FutureTask getReceiveFuture(DeferredRequestReplyMap.DeferredMessageSentCallback callback) {
        FutureHandler future = this.createFutureHandler(callback);
        DeferredRequestReplyMap map = callback.getDeferredRequestReplyMap();
        map.put(callback, future);
        return future;
    }

    protected FutureHandler createFutureHandler(String correlationID) {
        return new FutureHandler();
    }

    protected FutureHandler createFutureHandler(DeferredRequestReplyMap.DeferredMessageSentCallback callback) {
        return new FutureHandler();
    }

    public void onMessage(javax.jms.Message message) {
        try {
            String correlationID = message.getJMSCorrelationID();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Message correlationID: " + correlationID));
            }
            if (correlationID == null) {
                LOG.warn((Object)("Ignoring message with no correlationID: " + message));
                return;
            }
            Object handler = this.requestMap.get((Object)correlationID);
            if (handler != null && handler instanceof ReplyHandler) {
                ReplyHandler replyHandler = (ReplyHandler)handler;
                boolean complete = replyHandler.handle(message);
                if (complete) {
                    this.requestMap.remove((Object)correlationID);
                }
            } else {
                DeferredRequestReplyMap.processDeferredRequests((Object)this, this.deferredRequestMap, this.deferredReplyMap, correlationID, this.getMaxRequestTimeout(), message);
            }
        }
        catch (JMSException e) {
            throw new FailedToProcessResponse(message, e);
        }
    }

    public AbstractMessageListenerContainer getListenerContainer() {
        if (this.listenerContainer == null) {
            this.listenerContainer = this.createListenerContainer();
        }
        return this.listenerContainer;
    }

    public void setListenerContainer(AbstractMessageListenerContainer listenerContainer) {
        this.listenerContainer = listenerContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getReplyTo() {
        Requestor requestor = this;
        synchronized (requestor) {
            try {
                if (this.replyTo == null) {
                    ((Object)((Object)this)).wait(this.replyToResolverTimeout);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.replyTo;
    }

    public void setReplyTo(Destination replyTo) {
        this.replyTo = replyTo;
    }

    protected void doStart() throws Exception {
        AbstractMessageListenerContainer container = this.getListenerContainer();
        container.afterPropertiesSet();
        container.start();
    }

    protected void doStop() throws Exception {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
            this.listenerContainer.destroy();
        }
    }

    protected Requestor getOutterInstance() {
        return this;
    }

    protected AbstractMessageListenerContainer createListenerContainer() {
        ExceptionListener exceptionListener;
        TaskExecutor taskExecutor;
        SimpleMessageListenerContainer102 answer = this.configuration.isUseVersion102() ? new SimpleMessageListenerContainer102() : new SimpleMessageListenerContainer();
        answer.setDestinationName("temporary");
        answer.setDestinationResolver(new DestinationResolver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
                TemporaryQueue queue = null;
                Requestor requestor = Requestor.this.getOutterInstance();
                synchronized (requestor) {
                    try {
                        queue = session.createTemporaryQueue();
                        Requestor.this.setReplyTo((Destination)queue);
                    }
                    finally {
                        ((Object)((Object)Requestor.this.getOutterInstance())).notifyAll();
                    }
                }
                return queue;
            }
        });
        answer.setAutoStartup(true);
        answer.setMessageListener((Object)this);
        answer.setPubSubDomain(false);
        answer.setSubscriptionDurable(false);
        answer.setConcurrentConsumers(1);
        answer.setConnectionFactory(this.configuration.getConnectionFactory());
        String clientId = this.configuration.getClientId();
        if (clientId != null) {
            clientId = clientId + ".Requestor";
            answer.setClientId(clientId);
        }
        if ((taskExecutor = this.configuration.getTaskExecutor()) != null) {
            answer.setTaskExecutor(taskExecutor);
        }
        if ((exceptionListener = this.configuration.getExceptionListener()) != null) {
            answer.setExceptionListener(exceptionListener);
        }
        return answer;
    }

    public static synchronized UuidGenerator getUuidGenerator() {
        if (uuidGenerator == null) {
            uuidGenerator = UuidGenerator.get();
        }
        return uuidGenerator;
    }

    protected JmsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setReplyToSelectorHeader(Message in, javax.jms.Message jmsIn) throws JMSException {
    }
}

