/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.loader.locator;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.ow2.jonas.lib.loader.locator.DirLocator;
import org.ow2.jonas.lib.loader.locator.JarFileLocator;

public abstract class Locator {
    public abstract boolean hasFile(String var1);

    public abstract boolean hasDirectory(String var1);

    public abstract List listContent(String var1);

    public static Locator getLocator(URL url) throws IOException {
        String path = url.getPath();
        if (path.matches(".*\\..ar")) {
            return new JarFileLocator(url);
        }
        if (path.endsWith("/")) {
            return new DirLocator(url);
        }
        String err = "Unsupported URL '" + url + "' support " + "only jar archive and directory";
        throw new IOException(err);
    }
}

