/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.spi;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.ow2.carol.jndi.spi.AbsContext;
import org.ow2.carol.jndi.wrapping.JNDIResourceWrapper;
import org.ow2.carol.rmi.exception.NamingExceptionHelper;
import org.ow2.carol.rmi.util.PortNumber;
import org.ow2.carol.util.configuration.ConfigurationRepository;

public class IRMIContext
extends AbsContext
implements Context {
    public IRMIContext(Context context) {
        super(context);
    }

    protected int getObjectPort() {
        Properties prop = ConfigurationRepository.getProperties();
        if (prop != null) {
            String propertyName = "carol.irmi.server.port";
            return PortNumber.strToint(prop.getProperty(propertyName, "0"), propertyName);
        }
        return 0;
    }

    protected Object unwrapObject(Object o, Name name) throws NamingException {
        Object result = super.defaultUnwrapObject(o, name);
        if (result instanceof Reference) {
            try {
                return NamingManager.getObjectInstance(result, null, null, this.getEnvironment());
            }
            catch (Exception e) {
                throw NamingExceptionHelper.create("Cannot resolve reference", e);
            }
        }
        return result;
    }

    protected Object wrapObject(Object o, Name name, boolean replace) throws NamingException {
        try {
            PortableRemoteObjectDelegate pro = ConfigurationRepository.getCurrentConfiguration().getProtocol().getPortableRemoteObject();
            if (!(o instanceof Remote)) {
                if (o instanceof Referenceable) {
                    o = ((Referenceable)o).getReference();
                }
                o = new JNDIResourceWrapper((Serializable)o);
                pro.exportObject((Remote)o);
                Remote old = (Remote)this.addToExported(name, o);
                if (old != null) {
                    if (replace) {
                        pro.unexportObject(old);
                    } else {
                        pro.unexportObject((Remote)o);
                        this.addToExported(name, old);
                        throw new NamingException("Object '" + o + "' with name '" + name + "' is already bind");
                    }
                }
            }
            if (o instanceof Remote) {
                o = pro.toStub((Remote)o);
                return o;
            }
            return o;
        }
        catch (RemoteException e) {
            throw (NamingException)new NamingException().initCause(e);
        }
    }
}

