/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.interceptors.impl.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.ow2.jonas.jndi.interceptors.impl.datasource.ConnectionClassUtils;
import org.ow2.jonas.jndi.interceptors.impl.datasource.DatasourceWrapper;

public class ConnectionProxy
implements InvocationHandler {
    private static final Method CLOSE_METHOD = ConnectionClassUtils.getCloseMethod();
    private Long id = null;
    private DatasourceWrapper datasourceWrapper = null;
    private Connection wrappedConnection = null;
    private StackTraceElement[] stackTraceElements = null;

    public ConnectionProxy(Long id, DatasourceWrapper datasourceWrapper, Connection wrappedConnection, StackTraceElement[] stackTraceElements) {
        this.id = id;
        this.datasourceWrapper = datasourceWrapper;
        this.wrappedConnection = wrappedConnection;
        this.stackTraceElements = stackTraceElements;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (CLOSE_METHOD.equals(method)) {
            this.datasourceWrapper.remove(this.id);
        }
        return method.invoke((Object)this.wrappedConnection, args);
    }

    protected Long getId() {
        return this.id;
    }

    protected StackTraceElement[] getStackTraceElements() {
        return this.stackTraceElements;
    }

    protected Connection getWrappedConnection() {
        return this.wrappedConnection;
    }
}

