/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.monitor.impl;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentPlanFragment;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.fetcher.api.exceptions.FetcherException;
import org.ow2.util.plan.monitor.api.IResourceMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMonitorImpl
implements IResourceMonitor {
    private Log logger = LogFactory.getLog(ResourceMonitorImpl.class);
    private List<IResourceFetcher> monitoredResources = new ArrayList<IResourceFetcher>();

    @Override
    public void addMonitoredResource(IResourceFetcher resourceFetcher) {
        this.monitoredResources.add(resourceFetcher);
    }

    @Override
    public void removeMonitoredResource(DeploymentPlanFragment deployment) {
        for (IResourceFetcher fetcher : this.monitoredResources) {
            if (!fetcher.getDeployment().equals(deployment)) continue;
            this.monitoredResources.remove(fetcher);
            return;
        }
    }

    @Override
    public List<IResourceFetcher> getChangedResources() {
        ArrayList<IResourceFetcher> result = new ArrayList<IResourceFetcher>();
        for (IResourceFetcher fetcher : this.monitoredResources) {
            try {
                if (!fetcher.hasChanged()) continue;
                result.add(fetcher);
            }
            catch (FetcherException e) {
                this.logger.warn((Object)"Exception while checking resource {0} ; exception: {1}", new Object[]{fetcher.getDeployment(), e});
            }
        }
        return result;
    }

    @Override
    public Integer getMonitoredResourcesCount() {
        return this.monitoredResources.size();
    }

    @Override
    public List<String> getMonitoredResourcesDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        for (IResourceFetcher fetcher : this.monitoredResources) {
            result.add(fetcher.toString());
        }
        return result;
    }

    @Override
    public void removeMonitoredResource(IResourceFetcher resourceFetcher) {
        this.monitoredResources.remove(resourceFetcher);
    }
}

