/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.dbm.internal.mbean;

import java.sql.SQLException;
import java.util.Map;
import org.ow2.jonas.dbm.internal.cm.ConnectionManager;
import org.ow2.jonas.dbm.internal.cm.Pool;
import org.ow2.jonas.lib.management.javaee.J2EEManagedObject;
import org.ow2.jonas.lib.management.reconfig.PropertiesConfigurationData;

public class JDBCDataSource
extends J2EEManagedObject {
    private String jdbcDriver = null;
    private ConnectionManager cm = null;
    private Pool pool = null;
    private String datasourceName = null;
    private long sequenceNumber = 0L;

    public JDBCDataSource(String objectName, ConnectionManager cm) {
        super(objectName);
        this.cm = cm;
        this.pool = cm.getPool();
        this.datasourceName = cm.getDatasourceName();
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriverObjectName) {
        this.jdbcDriver = jdbcDriverObjectName;
    }

    public String getName() {
        return this.datasourceName;
    }

    public String getJndiName() {
        return this.cm.getDSName();
    }

    public String getDescription() {
        return this.cm.getDataSourceDescription();
    }

    public String getUrl() {
        return this.cm.getUrl();
    }

    public String getUserName() {
        return this.cm.getUserName();
    }

    public String getUserPassword() {
        return this.cm.getPassword();
    }

    public String getMapperName() {
        return this.cm.getMapperName();
    }

    public Integer getJdbcConnCheckLevel() {
        return new Integer(this.pool.getCheckLevel());
    }

    public void setJdbcConnCheckLevel(Integer level) {
        this.pool.setCheckLevel(level);
        String propName = "jdbc.connchecklevel";
        PropertiesConfigurationData prop = new PropertiesConfigurationData(propName, level.toString());
        this.sendReconfigNotification(this.getSequenceNumber(), this.datasourceName, prop);
    }

    public Integer getJdbcConnMaxAge() {
        return new Integer(this.pool.getMaxAge());
    }

    public void setJdbcConnMaxAge(Integer mn) {
        this.pool.setMaxAge(mn);
        String propName = "jdbc.connmaxage";
        PropertiesConfigurationData prop = new PropertiesConfigurationData(propName, mn.toString());
        this.sendReconfigNotification(this.getSequenceNumber(), this.datasourceName, prop);
    }

    public Integer getJdbcMaxConnPool() {
        return new Integer(this.pool.getPoolMax());
    }

    public void setJdbcMaxConnPool(Integer max) {
        this.pool.setPoolMax(max);
        String propName = "jdbc.maxconpool";
        PropertiesConfigurationData prop = new PropertiesConfigurationData(propName, max.toString());
        this.sendReconfigNotification(this.getSequenceNumber(), this.datasourceName, prop);
    }

    public Integer getJdbcMaxOpenTime() {
        return new Integer(this.pool.getMaxOpenTime());
    }

    public void setJdbcMaxOpenTime(Integer mn) {
        this.pool.setMaxOpenTime(mn);
        String propName = "jdbc.maxopentime";
        PropertiesConfigurationData prop = new PropertiesConfigurationData(propName, mn.toString());
        this.sendReconfigNotification(this.getSequenceNumber(), this.datasourceName, prop);
    }

    public Integer getJdbcMaxWaiters() {
        return new Integer(this.pool.getMaxWaiters());
    }

    public void setJdbcMaxWaiters(Integer max) {
        this.pool.setMaxWaiters(max);
        String propName = "jdbc.maxwaiters";
        PropertiesConfigurationData prop = new PropertiesConfigurationData(propName, max.toString());
        this.sendReconfigNotification(this.getSequenceNumber(), this.datasourceName, prop);
    }

    public Integer getJdbcMaxWaitTime() {
        return new Integer(this.pool.getMaxWaitTime());
    }

    public void setJdbcMaxWaitTime(Integer max) {
        this.pool.setMaxWaitTime(max);
        String propName = "jdbc.maxwaittime";
        PropertiesConfigurationData prop = new PropertiesConfigurationData(propName, max.toString());
        this.sendReconfigNotification(this.getSequenceNumber(), this.datasourceName, prop);
    }

    public Integer getJdbcPstmtMax() {
        return new Integer(this.cm.getPstmtMax());
    }

    public void setJdbcPstmtMax(Integer max) {
        this.cm.setPstmtMax(max);
        String propName = "jdbc.pstmtmax";
        PropertiesConfigurationData prop = new PropertiesConfigurationData(propName, max.toString());
        this.sendReconfigNotification(this.getSequenceNumber(), this.datasourceName, prop);
    }

    public Integer getJdbcMinConnPool() {
        return new Integer(this.pool.getPoolMin());
    }

    public void setJdbcMinConnPool(Integer min) {
        this.pool.setPoolMin(min);
        String propName = "jdbc.minconpool";
        PropertiesConfigurationData prop = new PropertiesConfigurationData(propName, min.toString());
        this.sendReconfigNotification(this.getSequenceNumber(), this.datasourceName, prop);
    }

    public Integer getJdbcSamplingPeriod() {
        return new Integer(this.pool.getSamplingPeriod());
    }

    public void setJdbcSamplingPeriod(Integer i) {
        this.pool.setSamplingPeriod(i);
        String propName = "jdbc.adjustperiod";
        PropertiesConfigurationData prop = new PropertiesConfigurationData(propName, i.toString());
        this.sendReconfigNotification(this.getSequenceNumber(), this.datasourceName, prop);
    }

    public Integer getJdbcAdjustPeriod() {
        return new Integer(this.pool.getAdjustPeriod());
    }

    public void setJdbcAdjustPeriod(Integer i) {
        this.pool.setAdjustPeriod(i);
        String propName = "jdbc.adjustperiod";
        PropertiesConfigurationData prop = new PropertiesConfigurationData(propName, i.toString());
        this.sendReconfigNotification(this.getSequenceNumber(), this.datasourceName, prop);
    }

    public String getJdbcTestStatement() {
        return this.pool.getTestStatement();
    }

    public String setJdbcTestStatement(String test) {
        String result;
        try {
            result = this.pool.checkConnection(test);
            if (result.equals(test)) {
                this.pool.setTestStatement(test);
                result = test;
            }
        }
        catch (SQLException e) {
            result = e.toString();
        }
        String propName = "jdbc.connteststmt";
        PropertiesConfigurationData prop = new PropertiesConfigurationData(propName, test);
        this.sendReconfigNotification(this.getSequenceNumber(), this.datasourceName, prop);
        return result;
    }

    public Integer getConnectionFailures() {
        return new Integer(this.pool.getConnectionFailures());
    }

    public Integer getConnectionLeaks() {
        return new Integer(this.pool.getConnectionLeaks());
    }

    public Integer getCurrentBusy() {
        return new Integer(this.pool.getCurrentBusy());
    }

    public Integer getBusyMax() {
        return new Integer(this.pool.getBusyMaxRecent());
    }

    public Integer getBusyMin() {
        return new Integer(this.pool.getBusyMinRecent());
    }

    public Integer getCurrentInTx() {
        return new Integer(this.pool.getCurrentInTx());
    }

    public Integer getCurrentOpened() {
        return new Integer(this.pool.getCurrentOpened());
    }

    public Integer getCurrentWaiters() {
        return new Integer(this.pool.getCurrentWaiters());
    }

    public Integer getOpenedCount() {
        return new Integer(this.pool.getOpenedCount());
    }

    public Integer getRejectedFull() {
        return new Integer(this.pool.getRejectedFull());
    }

    public Integer getRejectedOpen() {
        return new Integer(this.pool.getRejectedOpen());
    }

    public Integer getRejectedOther() {
        return new Integer(this.pool.getRejectedOther());
    }

    public Integer getRejectedTimeout() {
        return new Integer(this.pool.getRejectedTimeout());
    }

    public Integer getServedOpen() {
        return new Integer(this.pool.getServedOpen());
    }

    public Integer getWaiterCount() {
        return new Integer(this.pool.getWaiterCount());
    }

    public Integer getWaitersHigh() {
        return new Integer(this.pool.getWaitersHigh());
    }

    public Integer getWaitersHighRecent() {
        return new Integer(this.pool.getWaitersHighRecent());
    }

    public Long getWaitingHigh() {
        return new Long(this.pool.getWaitingHigh());
    }

    public Long getWaitingHighRecent() {
        return new Long(this.pool.getWaitingHighRecent());
    }

    public Long getWaitingTime() {
        return new Long(this.pool.getWaitingTime());
    }

    public int[] getOpenedConnections(int seconds) {
        return this.cm.getOpenedConnections(seconds);
    }

    public int[] getOpenedConnections() {
        return this.cm.getOpenedConnections();
    }

    public Map getConnectionDetails(int connectionId) {
        return this.cm.getConnectionDetails(connectionId);
    }

    public void forceCloseConnection(int connectionId) {
        this.cm.forceCloseConnection(connectionId);
    }

    public void setObservable(boolean observable) {
        this.cm.setObservable(observable);
    }

    public boolean isObservable() {
        return this.cm.isObservable();
    }

    protected long getSequenceNumber() {
        return ++this.sequenceNumber;
    }

    public void saveConfig() {
        this.sendSaveNotification(this.getSequenceNumber(), this.datasourceName);
    }
}

