/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.spring;

import java.util.List;
import java.util.Map;
import org.apache.camel.component.cxf.jaxrs.BeanIdAware;
import org.apache.camel.component.cxf.spring.AbstractCxfBeanDefinitionParser;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class CxfRsServerFactoryBeanDefinitionParser
extends AbstractCxfBeanDefinitionParser {
    public CxfRsServerFactoryBeanDefinitionParser() {
        this.setBeanClass(SpringJAXRSServerFactoryBean.class);
    }

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        super.doParse(element, ctx, bean);
        bean.addPropertyValue("beanId", (Object)this.resolveId(element, bean.getBeanDefinition(), ctx));
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element el, String name) {
        if ("properties".equals(name) || "extensionMappings".equals(name) || "languageMappings".equals(name)) {
            Map map = ctx.getDelegate().parseMapElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)map);
        } else if ("executor".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.executor");
        } else if ("invoker".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.invoker");
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else if ("features".equals(name) || "schemaLocations".equals(name) || "providers".equals(name) || "serviceBeans".equals(name) || "modelBeans".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else if ("model".equals(name)) {
            List resources = ResourceUtils.getResourcesFromElement((Element)el);
            bean.addPropertyValue("modelBeans", (Object)resources);
        } else {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        }
    }

    public static class SpringJAXRSServerFactoryBean
    extends JAXRSServerFactoryBean
    implements ApplicationContextAware,
    BeanIdAware {
        private String beanId;

        public SpringJAXRSServerFactoryBean() {
        }

        public SpringJAXRSServerFactoryBean(JAXRSServiceFactoryBean sf) {
            super(sf);
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            if (this.getBus() == null) {
                SpringBusFactory factory = new SpringBusFactory();
                Bus bus = factory.createBus();
                BusWiringBeanFactoryPostProcessor.updateBusReferencesInContext((Bus)bus, (ApplicationContext)ctx);
                this.setBus(bus);
            }
        }

        public String getBeanId() {
            return this.beanId;
        }

        public void setBeanId(String id) {
            this.beanId = id;
        }

        public void setServiceClass(Class clazz) {
            this.setResourceClasses(new Class[]{clazz});
        }
    }
}

