/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.audit.report;

import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationBegin;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationEnd;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationError;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.util.marshalling.Serialization;
import org.ow2.util.auditreport.impl.InvocationAuditReport;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class InvocationAuditReportFactory {
    private static final String ON_MESSAGE_METHOD = "onMessage_javax.jms.Message";
    private static final int START_LEVEL = -1;
    private static final int PREVIOUS_ID_START = 0;
    private static Log logger = LogFactory.getLog(InvocationAuditReportFactory.class);
    private HashMap<Long, InvocationAuditReport> waitingReports = new HashMap();
    private long previousID = 0L;
    private int level = -1;

    public void prepareAuditReport(long start, String method, Thread current, EZBEventBeanInvocationBegin event, String providerId, Principal[] callerRoles, Principal caller) {
        ++this.level;
        String[] roles = null;
        if (callerRoles != null) {
            roles = new String[callerRoles.length];
            int i = 0;
            for (Principal callerPrincipalRole : callerRoles) {
                roles[i++] = callerPrincipalRole.getName();
            }
        }
        int freeMemoryBefore = (int)Runtime.getRuntime().freeMemory();
        int totalMemoryBefore = (int)Runtime.getRuntime().totalMemory();
        Object[] arguments = event.getArguments();
        String[] params = null;
        if (arguments != null && arguments.length > 0) {
            int i = 0;
            params = new String[arguments.length];
            for (Object parameter : arguments) {
                params[i++] = parameter.toString();
            }
        }
        InvocationAuditReport reporttmp = new InvocationAuditReport(this.level, start, event.getTime(), method, event.getEventProviderId(), params, current, freeMemoryBefore, totalMemoryBefore, roles, caller.getName(), InvocationAuditReportFactory.lengthArgs(event.getArguments()));
        reporttmp.setMethodStackTrace((Object[])InvocationAuditReportFactory.cleanupStackTrace(event.getStackTraceElements()));
        if (this.level > 0) {
            reporttmp.setParentID(this.previousID);
        }
        this.waitingReports.put(event.getInvocationNumber(), reporttmp);
    }

    protected static StackTraceElement[] cleanupStackTrace(StackTraceElement[] stackTrace) {
        ArrayList<StackTraceElement> cleanList = new ArrayList<StackTraceElement>();
        boolean inEasyBeansCode = false;
        boolean afterEasyBeansCode = false;
        for (StackTraceElement stackElement : stackTrace) {
            String className = stackElement.getClassName();
            if (className == null || !inEasyBeansCode && className.startsWith("java.lang.Thread")) continue;
            if (!afterEasyBeansCode && className.startsWith("org.ow2.easybeans.")) {
                inEasyBeansCode = true;
                continue;
            }
            afterEasyBeansCode = true;
            cleanList.add(stackElement);
        }
        return cleanList.toArray(new StackTraceElement[cleanList.size()]);
    }

    private static int lengthArgs(Object[] arguments) {
        if (arguments == null) {
            return 0;
        }
        try {
            return Serialization.storeObject((Serializable)arguments).length;
        }
        catch (Exception e) {
            logger.debug((Object)"Unable to get argument size", new Object[]{e});
            return -1;
        }
    }

    public InvocationAuditReport getAuditReport(long stop, EZBEventBeanInvocationEnd event, String providerId) {
        long totalGarbageCollections = 0L;
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            long time;
            long count = gc.getCollectionCount();
            if (count >= 0L) {
                totalGarbageCollections += count;
            }
            if ((time = gc.getCollectionTime()) < 0L) continue;
            garbageCollectionTime += time;
        }
        int freeMemoryAfter = (int)Runtime.getRuntime().freeMemory();
        int totalMemoryAfter = (int)Runtime.getRuntime().totalMemory();
        InvocationAuditReport finished = this.waitingReports.get(event.getInvocationNumber());
        if (finished != null) {
            finished.setFreeMemoryAfter(freeMemoryAfter);
            finished.setTotalMemoryAfter(totalMemoryAfter);
            if (finished.getBusinessMethod().equals(ON_MESSAGE_METHOD)) {
                finished.setMethodReturn(event.getResult());
            } else {
                try {
                    finished.setMethodReturn(((EJBResponse)event.getResult()).getValue());
                }
                catch (Exception e) {
                    finished.setMethodReturn(null);
                }
            }
            finished.setRequestStop(stop);
            finished.setSweepMarkTime(totalGarbageCollections);
            finished.setScavengeTime(garbageCollectionTime);
            this.waitingReports.remove(event.getInvocationNumber());
            this.previousID = finished.getReportID();
            --this.level;
            return finished;
        }
        this.level = -1;
        return null;
    }

    public InvocationAuditReport getAuditReport(long stop, EZBEventBeanInvocationError event, String providerId) {
        int freeMemoryAfter = (int)Runtime.getRuntime().freeMemory();
        int totalMemoryAfter = (int)Runtime.getRuntime().totalMemory();
        InvocationAuditReport finished = this.waitingReports.get(event.getInvocationNumber());
        if (finished != null) {
            finished.setFreeMemoryAfter(freeMemoryAfter);
            finished.setTotalMemoryAfter(totalMemoryAfter);
            finished.setRequestStop(stop);
            this.waitingReports.remove(event.getInvocationNumber());
            this.previousID = finished.getReportID();
            --this.level;
            return finished;
        }
        this.level = -1;
        return null;
    }
}

