/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jdbcpool;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.ow2.easybeans.component.jdbcpool.JManagedConnection;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JStatement
implements PreparedStatement {
    private boolean changed = false;
    private boolean opened = false;
    private boolean closing = false;
    private PreparedStatement ps;
    private JManagedConnection mc;
    private int hashCode;
    private String sql;
    private Log logger = LogFactory.getLog(JStatement.class);

    public JStatement(PreparedStatement ps, JManagedConnection mc, String sql) {
        this.ps = ps;
        this.mc = mc;
        this.sql = sql;
        this.hashCode = sql.hashCode();
        this.opened = true;
    }

    public String getSql() {
        return this.sql;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object stmt) {
        if (stmt == null) {
            return false;
        }
        if (this.hashCode != stmt.hashCode()) {
            return false;
        }
        if (!(stmt instanceof JStatement)) {
            this.logger.warn((Object)"Bad class {0}", new Object[]{stmt});
            return false;
        }
        JStatement psw = (JStatement)stmt;
        if (this.sql == null && psw.getSql() != null) {
            return false;
        }
        if (this.sql != null && !this.sql.equals(psw.getSql())) {
            return false;
        }
        try {
            if (psw.getResultSetType() != this.getResultSetType()) {
                return false;
            }
            if (psw.getResultSetConcurrency() != this.getResultSetConcurrency()) {
                return false;
            }
        }
        catch (SQLException e) {
            this.logger.warn((Object)"Cannot compare statements", new Object[]{e});
            return false;
        }
        this.logger.debug((Object)"Found", new Object[0]);
        return true;
    }

    public boolean forceClose() {
        if (this.opened) {
            this.logger.debug((Object)"Statements should be closed explicitly.", new Object[0]);
            this.opened = false;
            return true;
        }
        return false;
    }

    public void reuse() throws SQLException {
        this.ps.clearParameters();
        this.ps.clearWarnings();
        this.opened = true;
        if (this.changed) {
            this.logger.debug((Object)"Properties statement have been changed, reset default properties", new Object[0]);
            this.ps.clearBatch();
            this.ps.setFetchDirection(1000);
            this.ps.setMaxFieldSize(0);
            this.ps.setMaxRows(0);
            this.ps.setQueryTimeout(0);
            this.changed = false;
        }
    }

    public boolean isClosed() {
        return !this.opened && !this.closing;
    }

    public void forget() {
        try {
            this.ps.close();
        }
        catch (SQLException e) {
            this.logger.error((Object)"Cannot close the PreparedStatement", new Object[]{e});
        }
    }

    public int executeUpdate() throws SQLException {
        return this.ps.executeUpdate();
    }

    public void addBatch() throws SQLException {
        this.changed = true;
        this.ps.addBatch();
    }

    public void clearParameters() throws SQLException {
        this.ps.clearParameters();
    }

    public boolean execute() throws SQLException {
        return this.ps.execute();
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ps.setByte(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ps.setDouble(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ps.setFloat(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ps.setInt(parameterIndex, x);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ps.setNull(parameterIndex, sqlType);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ps.setLong(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ps.setShort(parameterIndex, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ps.setBoolean(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ps.setBytes(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setUnicodeStream(parameterIndex, x, length);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ps.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.ps.setNull(paramIndex, sqlType, typeName);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.ps.setString(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ps.setBigDecimal(parameterIndex, x);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.ps.setURL(parameterIndex, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.ps.setArray(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.ps.setBlob(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.ps.setClob(i, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.ps.setDate(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps.getParameterMetaData();
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.ps.setRef(i, x);
    }

    public ResultSet executeQuery() throws SQLException {
        return this.ps.executeQuery();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps.getMetaData();
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.ps.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ps.setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.ps.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x, cal);
    }

    public int getFetchDirection() throws SQLException {
        return this.ps.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.ps.getFetchSize();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.ps.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.ps.getMaxRows();
    }

    public int getQueryTimeout() throws SQLException {
        return this.ps.getQueryTimeout();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.ps.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.ps.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.ps.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.ps.getUpdateCount();
    }

    public void cancel() throws SQLException {
        this.ps.cancel();
    }

    public void clearBatch() throws SQLException {
        this.ps.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.ps.clearWarnings();
    }

    public void close() throws SQLException {
        if (!this.opened) {
            this.logger.debug((Object)"Statement already closed", new Object[0]);
            return;
        }
        this.opened = false;
        this.closing = true;
        this.mc.notifyPsClose(this);
        this.closing = false;
    }

    public boolean getMoreResults() throws SQLException {
        return this.ps.getMoreResults();
    }

    public int[] executeBatch() throws SQLException {
        return this.ps.executeBatch();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.changed = true;
        this.ps.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.changed = true;
        this.ps.setFetchSize(rows);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.changed = true;
        this.ps.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.changed = true;
        this.ps.setMaxRows(max);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.changed = true;
        this.ps.setQueryTimeout(seconds);
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.ps.getMoreResults(current);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ps.setEscapeProcessing(enable);
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.ps.executeUpdate(sql);
    }

    public void addBatch(String sql) throws SQLException {
        this.changed = true;
        this.ps.addBatch(sql);
    }

    public void setCursorName(String name) throws SQLException {
        this.ps.setCursorName(name);
    }

    public boolean execute(String sql) throws SQLException {
        this.changed = true;
        return this.ps.execute(sql);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.changed = true;
        return this.ps.executeUpdate(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.changed = true;
        return this.ps.execute(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.changed = true;
        return this.ps.executeUpdate(sql, columnIndexes);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.changed = true;
        return this.ps.execute(sql, columnIndexes);
    }

    public Connection getConnection() throws SQLException {
        return this.ps.getConnection();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.ps.getGeneratedKeys();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.ps.getResultSet();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.ps.getWarnings();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.ps.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.ps.execute(sql, columnNames);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.ps.executeQuery(sql);
    }
}

