/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.jmx;

import fr.dyade.aaa.util.management.MXServer;
import fr.dyade.aaa.util.management.MXWrapper;
import java.lang.reflect.Method;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

public class JMXServer
implements MXServer {
    public MBeanServer mxserver = null;

    public JMXServer(MBeanServer mxserver) {
        this.mxserver = mxserver;
        MXWrapper.setMXServer(this);
    }

    public JMXServer() {
        try {
            Class<?> clazz = Class.forName("java.lang.management.ManagementFactory");
            Method method = clazz.getMethod("getPlatformMBeanServer", null);
            this.mxserver = (MBeanServer)method.invoke(null, null);
        }
        catch (Exception exc) {
            this.mxserver = MBeanServerFactory.createMBeanServer("AgentServer");
        }
        MXWrapper.setMXServer(this);
    }

    public String registerMBean(Object bean, String fullName) throws Exception {
        if (this.mxserver == null) {
            return null;
        }
        try {
            this.mxserver.registerMBean(bean, new ObjectName(fullName));
        }
        catch (InstanceAlreadyExistsException exc) {
            throw exc;
        }
        catch (MBeanRegistrationException exc) {
            throw exc;
        }
        catch (NotCompliantMBeanException exc) {
            throw exc;
        }
        catch (RuntimeOperationsException exc) {
            throw exc;
        }
        return fullName;
    }

    public void unregisterMBean(String fullName) throws Exception {
        if (this.mxserver == null) {
            return;
        }
        try {
            this.mxserver.unregisterMBean(new ObjectName(fullName));
        }
        catch (InstanceNotFoundException exc) {
            throw exc;
        }
        catch (MBeanRegistrationException exc) {
            throw exc;
        }
        catch (RuntimeOperationsException exc) {
            throw exc;
        }
    }

    public Object getAttribute(ObjectName objectName, String attribute) throws Exception {
        if (this.mxserver == null) {
            return null;
        }
        return this.mxserver.getAttribute(objectName, attribute);
    }

    public MBeanAttributeInfo[] getAttributes(ObjectName objectName) throws Exception {
        if (this.mxserver == null) {
            return null;
        }
        return this.mxserver.getMBeanInfo(objectName).getAttributes();
    }

    public Set queryNames(ObjectName objectName) {
        if (this.mxserver == null) {
            return null;
        }
        return this.mxserver.queryNames(objectName, null);
    }
}

