/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageQueue;
import fr.dyade.aaa.common.EmptyQueueException;
import java.lang.ref.SoftReference;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

final class MessageVector
implements MessageQueue {
    private Logger logmon = null;
    private String logmsg = null;
    private long cpt1;
    private long cpt2;
    private Object[] data;
    private int first;
    private int count;
    private int validated;
    private boolean persistent;

    MessageVector(String name, boolean persistent) {
        this.logmon = Debug.getLogger(this.getClass().getName() + '.' + name);
        this.logmsg = name + ".MessageVector: ";
        this.persistent = persistent;
        this.data = new Object[50];
        this.first = 0;
        this.count = 0;
        this.validated = 0;
    }

    public synchronized void insert(Message item) {
        int i;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "insert(" + item + ")"));
        }
        for (i = 0; i < this.validated; ++i) {
            Message msg = this.getMessageAt(i);
            if (item.getStamp() < msg.getStamp()) break;
        }
        this.insertMessageAt(item, i);
        ++this.validated;
    }

    public synchronized void push(Message item) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "push(" + item + ")"));
        }
        this.addMessage(item);
    }

    public synchronized Message pop() throws EmptyQueueException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "pop()"));
        }
        if (this.validated == 0) {
            throw new EmptyQueueException();
        }
        Message item = this.getMessageAt(0);
        this.removeMessageAt(0);
        --this.validated;
        return item;
    }

    public synchronized void validate() {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "validate()"));
        }
        this.validated = this.size();
        this.notify();
    }

    public synchronized Message get() throws InterruptedException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "get()"));
            ++this.cpt1;
            this.cpt2 += (long)this.validated;
            if ((this.cpt1 & 0xFFFFL) == 0L) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + this.cpt2 / this.cpt1 + '/' + this.validated));
            }
        }
        while (this.validated == 0) {
            this.wait();
        }
        Message item = this.getMessageAt(0);
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "get() -> " + item));
        }
        return item;
    }

    public synchronized Message get(long timeout) throws InterruptedException {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "get(" + timeout + ")"));
            ++this.cpt1;
            this.cpt2 += (long)this.validated;
            if ((this.cpt1 & 0xFFFFL) == 0L) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + this.cpt2 / this.cpt1 + '/' + this.validated));
            }
        }
        Message item = null;
        if (this.validated == 0 && timeout > 0L) {
            this.wait(timeout);
        }
        if (this.validated > 0) {
            item = this.getMessageAt(0);
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "get() -> " + item));
        }
        return item;
    }

    public synchronized Message getMessageTo(short to) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "getFrom(" + to + ")"));
            ++this.cpt1;
            this.cpt2 += (long)this.validated;
            if ((this.cpt1 & 0xFFFFL) == 0L) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + this.cpt2 / this.cpt1 + '/' + this.validated));
            }
        }
        Message item = null;
        for (int i = 0; i < this.validated; ++i) {
            Message msg = this.getMessageAt(i);
            if (msg.getDest() != to) continue;
            item = msg;
            break;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "get() -> " + item));
        }
        return item;
    }

    synchronized void removeMessage(Message msg) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "removeMessage #" + msg.getStamp()));
        }
        for (int i = 0; i < this.validated; ++i) {
            if (this.getMessageAt(i) != msg) continue;
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "removeMessage #" + msg.getStamp() + " -> " + i));
            }
            this.removeMessageAt(i);
            --this.validated;
            return;
        }
        this.logmon.log(BasicLevel.ERROR, (Object)(this.logmsg + "removeMessage #" + msg.getStamp() + " not found"));
    }

    synchronized int remove(int stamp) {
        Message msg;
        int i;
        if (this.validated == 0) {
            return 0;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "remove #" + stamp));
        }
        for (i = 0; i < this.validated && stamp >= (msg = this.getMessageAt(i)).getStamp(); ++i) {
        }
        for (int j = 0; j < i; ++j) {
            this.removeMessageAt(0);
        }
        this.validated -= i;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "remove #" + stamp + " ->" + i));
        }
        return i;
    }

    synchronized Message removeExpired(long currentTimeMillis) {
        if (this.validated == 0) {
            return null;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "removeExpired - " + currentTimeMillis));
        }
        for (int i = 0; i < this.validated; ++i) {
            Message msg = this.getMessageAt(i);
            if (msg.not == null || msg.not.expiration <= 0L || currentTimeMillis < msg.not.expiration) continue;
            this.removeMessageAt(i);
            --this.validated;
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "remove #" + msg.getStamp()));
            }
            return msg;
        }
        return null;
    }

    void insertMessageAt(Message item, int index) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "insertMessageAt(" + item + ", " + index + ")"));
        }
        if (this.count == this.data.length) {
            Object[] newData = new Object[this.data.length * 2];
            if (this.first + this.count < this.data.length) {
                System.arraycopy(this.data, this.first, newData, 0, this.count);
            } else {
                int j = this.data.length - this.first;
                System.arraycopy(this.data, this.first, newData, 0, j);
                System.arraycopy(this.data, 0, newData, j, this.count - j);
            }
            this.first = 0;
            this.data = newData;
        }
        if (index != this.count) {
            System.arraycopy(this.data, index, this.data, index + 1, this.count - index);
        }
        this.data[(this.first + index) % this.data.length] = this.persistent ? new MessageSoftRef(item) : item;
        ++this.count;
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "insertMessageAt() -> " + this));
        }
    }

    void addMessage(Message item) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "addMessage(" + item + ")"));
        }
        this.insertMessageAt(item, this.count);
    }

    Message getMessageAt(int index) {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "getMessageAt(" + index + ")"));
        }
        int idx = (this.first + index) % this.data.length;
        if (this.persistent) {
            Message msg = ((MessageSoftRef)this.data[idx]).getMessage();
            if (msg == null) {
                msg = ((MessageSoftRef)this.data[idx]).loadMessage();
                this.data[idx] = new MessageSoftRef(msg);
            }
            return msg;
        }
        return (Message)this.data[idx];
    }

    void removeMessageAt(int index) {
        if (index == 0) {
            this.data[this.first] = null;
            this.first = (this.first + 1) % this.data.length;
        } else if (index == this.count - 1) {
            this.data[(this.first + index) % this.data.length] = null;
        } else if (this.first + index < this.data.length) {
            System.arraycopy(this.data, this.first, this.data, this.first + 1, index);
            this.data[this.first] = null;
            this.first = (this.first + 1) % this.data.length;
        } else {
            System.arraycopy(this.data, (this.first + index) % this.data.length + 1, this.data, (this.first + index) % this.data.length, this.count - index - 1);
            this.data[(this.first + this.count - 1) % this.data.length] = null;
        }
        --this.count;
        if (this.count == 0) {
            this.first = 0;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.logmsg + "removeMessageAt(" + index + ") -> " + this));
        }
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",first=").append(this.first);
        strbuf.append(",count=").append(this.count);
        strbuf.append(",validated=").append(this.validated).append(",(");
        for (int i = 0; i < this.data.length; ++i) {
            strbuf.append(this.data[i]).append(',');
        }
        strbuf.append("))");
        return strbuf.toString();
    }

    final class TransactionError
    extends Error {
        private static final long serialVersionUID = 1L;

        TransactionError(Throwable cause) {
            super(cause.getMessage());
        }
    }

    final class MessageSoftRef
    extends SoftReference {
        String name;
        Message ref;

        MessageSoftRef(Message msg) {
            super(msg);
            this.name = null;
            this.ref = null;
            if (msg.isPersistent()) {
                this.name = msg.toStringId();
            } else {
                this.ref = msg;
            }
        }

        public Message getMessage() {
            return null != this.ref ? this.ref : (Message)this.get();
        }

        public Message loadMessage() throws TransactionError {
            Message msg;
            if (this.ref != null) {
                return this.ref;
            }
            try {
                msg = Message.load(this.name);
                if (MessageVector.this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    MessageVector.this.logmon.log(BasicLevel.DEBUG, (Object)(MessageVector.this.logmsg + "reload from disk " + msg));
                }
            }
            catch (Exception exc) {
                MessageVector.this.logmon.log(BasicLevel.ERROR, (Object)(MessageVector.this.logmsg + "Can't load message " + this.name), (Throwable)exc);
                throw new TransactionError((Throwable)exc);
            }
            return msg;
        }

        public String toString() {
            StringBuffer strbuf = new StringBuffer();
            strbuf.append('(').append(super.toString());
            strbuf.append(",name=").append(this.name);
            strbuf.append(",ref=").append(this.ref);
            strbuf.append("))");
            return strbuf.toString();
        }
    }
}

