/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.UnknownServerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class SCAdminHelper {
    protected Hashtable ASP = null;
    protected Logger logmon = Debug.getLogger("fr.dyade.aaa.agent.SCAdmin");

    public SCAdminHelper() {
        this.ASP = new Hashtable();
    }

    public String startAgentServer(short sid) throws Exception {
        return this.startAgentServer(sid, null, null, null, null);
    }

    public String startAgentServer(short sid, String[] jvmargs) throws Exception {
        return this.startAgentServer(sid, null, jvmargs, null, null);
    }

    public String startAgentServer(short sid, File dir, String[] jvmargs) throws Exception {
        return this.startAgentServer(sid, dir, jvmargs, null, null);
    }

    public String startAgentServer(short sid, File dir, String[] jvmargs, String[] args) throws Exception {
        return this.startAgentServer(sid, dir, jvmargs, null, args);
    }

    public String startAgentServer(short sid, File dir, String[] jvmargs, String className, String[] args) throws Exception {
        this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: start AgentServer#" + sid));
        Process p = (Process)this.ASP.get(new Short(sid));
        if (p != null) {
            try {
                this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: AgentServer#" + sid + " -> " + p.exitValue()));
            }
            catch (IllegalThreadStateException exc) {
                this.logmon.log(BasicLevel.WARN, (Object)("SCAdmin: AgentServer#" + sid + " already running."));
                throw new IllegalStateException("AgentServer#" + sid + " already running.");
            }
        }
        p = this.execAgentServer(sid, dir, jvmargs, className, args);
        this.ASP.put(new Short(sid), p);
        String ret = this.waitServerStarting(p);
        this.closeServerStream(p);
        return ret;
    }

    public Process execAgentServer(short sid, File dir, String[] jvmargs, String className, String[] args) throws Exception {
        int i;
        this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: run AgentServer#" + sid));
        String javapath = new File(new File(System.getProperty("java.home"), "bin"), "java").getPath();
        String classpath = System.getProperty("java.class.path");
        Vector<String> argv = new Vector<String>();
        argv.addElement(javapath);
        argv.addElement("-classpath");
        argv.addElement(classpath);
        if (jvmargs != null) {
            for (i = 0; i < jvmargs.length; ++i) {
                argv.addElement(jvmargs[i]);
            }
        }
        argv.addElement("-Dcom.sun.management.jmxremote");
        argv.addElement("-DMXServer=com.scalagent.jmx.JMXServer");
        if (className == null) {
            className = "fr.dyade.aaa.agent.AgentServer";
        }
        argv.addElement(className);
        argv.addElement(Short.toString(sid));
        argv.addElement("s" + sid);
        if (args != null) {
            for (i = 0; i < args.length; ++i) {
                argv.addElement(args[i]);
            }
        }
        Object[] command = new String[argv.size()];
        argv.copyInto(command);
        this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: launches AgentServer#" + sid));
        Process p = null;
        p = dir == null ? Runtime.getRuntime().exec((String[])command) : Runtime.getRuntime().exec((String[])command, null, dir);
        return p;
    }

    public String waitServerStarting(Process p) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = br.readLine();
        if (line != null && line.endsWith("ERROR")) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(line);
            while ((line = br.readLine()) != null && !line.equals("END")) {
                strBuf.append('\n');
                strBuf.append(line);
            }
            line = strBuf.toString();
        }
        return line;
    }

    public void closeServerStream(Process p) throws Exception {
        try {
            p.getInputStream().close();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            p.getOutputStream().close();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            p.getErrorStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void killAgentServer(short sid) throws Exception {
        Process p = (Process)this.ASP.get(new Short(sid));
        this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: kill AgentServer#" + sid + " [" + p + ']'));
        if (p != null) {
            p.destroy();
        }
    }

    public int joinAgentServer(short sid) throws Exception {
        Process p = (Process)this.ASP.get(new Short(sid));
        this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: join AgentServer#" + sid + " [" + p + ']'));
        if (p != null) {
            return p.waitFor();
        }
        throw new UnknownServerException();
    }

    public int exitValue(short sid) throws IllegalThreadStateException, UnknownServerException {
        Process p = (Process)this.ASP.get(new Short(sid));
        if (p != null) {
            int res = p.exitValue();
            return res;
        }
        throw new UnknownServerException();
    }

    public void destroyAgentServer(short sid) throws Exception {
        Short key = new Short(sid);
        Process p = (Process)this.ASP.get(key);
        if (p != null) {
            this.ASP.remove(key);
            p.destroy();
        }
    }

    public void stopAgentServer(short sid, int port) throws Exception {
        this.stopAgentServer(sid, "localhost", port);
    }

    public void stopAgentServer(short sid, String host, int port) throws Exception {
        Socket socket = null;
        this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: stop AgentServer#" + sid));
        try {
            socket = new Socket(host, port);
            socket.getOutputStream().write("halt".getBytes());
            socket.getOutputStream().write(10);
            socket.getOutputStream().flush();
            try {
                socket.getInputStream().read();
            }
            catch (SocketException exc) {
                // empty catch block
            }
        }
        catch (Throwable exc) {
            try {
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: Can't stop server#" + sid), exc);
                }
                throw new Exception("Can't stop server#" + sid + ": " + exc.getMessage());
            }
            catch (Throwable throwable) {
                SCAdminHelper.close(socket);
                socket = null;
                throw throwable;
            }
        }
        SCAdminHelper.close(socket);
        socket = null;
    }

    public void crashAgentServer(short sid, int port) throws Exception {
        this.crashAgentServer(sid, "localhost", port);
    }

    public void crashAgentServer(short sid, String host, int port) throws Exception {
        Socket socket = null;
        this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: crash AgentServer#" + sid));
        try {
            socket = new Socket(host, port);
            socket.getOutputStream().write("crash".getBytes());
            socket.getOutputStream().write(10);
            socket.getOutputStream().flush();
            try {
                socket.getInputStream().read();
            }
            catch (SocketException exc) {
                // empty catch block
            }
        }
        catch (Throwable exc) {
            try {
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)("SCAdmin: Can't crash server#" + sid), exc);
                }
                throw new Exception("Can't crash server#" + sid + ": " + exc.getMessage());
            }
            catch (Throwable throwable) {
                SCAdminHelper.close(socket);
                socket = null;
                throw throwable;
            }
        }
        SCAdminHelper.close(socket);
        socket = null;
    }

    static void close(Socket socket) {
        try {
            socket.getInputStream().close();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            socket.getOutputStream().close();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

