/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.mdb;

import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.bean.EasyBeansMDB;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.container.EZBEJBContext;
import org.ow2.easybeans.container.AbsFactory;
import org.ow2.easybeans.container.info.MessageDrivenInfo;
import org.ow2.easybeans.container.mdb.EasyBeansMDBContext;
import org.ow2.easybeans.container.session.PoolWrapper;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBRemoteRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.enhanced.EnhancedPool;
import org.ow2.util.pool.impl.enhanced.api.basic.CreatePoolItemException;
import org.ow2.util.pool.impl.enhanced.manager.IPoolManager;
import org.ow2.util.pool.impl.enhanced.manager.optional.IPoolItemRemoveManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MDBFactory
extends AbsFactory<EasyBeansMDB>
implements IPoolItemRemoveManager<EasyBeansMDB> {
    private static Log logger = LogFactory.getLog(MDBFactory.class);
    private MessageDrivenInfo messageDrivenInfo = null;

    public MDBFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
        EnhancedPool mdbPool = this.getManagementPool().getEnhancedPoolFactory().createEnhancedPool((IPoolManager)this);
        this.setPool(new PoolWrapper(mdbPool));
    }

    @Override
    public EJBResponse rpcInvoke(EJBRemoteRequest request) {
        return null;
    }

    public EJBResponse localCall(EJBLocalRequest localCallRequest) {
        return null;
    }

    @Override
    public void stop() {
        super.stop();
        try {
            this.getPool().stop();
        }
        catch (PoolException e) {
            logger.error((Object)"Problem when stopping the factory", new Object[]{e});
        }
    }

    public IBeanInfo getBeanInfo() {
        return this.messageDrivenInfo;
    }

    public MessageDrivenInfo getMessageDrivenInfo() {
        return this.messageDrivenInfo;
    }

    public void setMessageDrivenInfo(MessageDrivenInfo messageDrivenInfo) {
        this.messageDrivenInfo = messageDrivenInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EasyBeansMDB createPoolItem() throws CreatePoolItemException {
        EasyBeansMDB instance = null;
        try {
            instance = (EasyBeansMDB)this.getBeanClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new CreatePoolItemException(WAITING_TIME_BEFORE_CREATION, "Cannot create a new instance", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CreatePoolItemException(WAITING_TIME_BEFORE_CREATION, "Cannot create a new instance", (Throwable)e);
        }
        instance.setEasyBeansFactory((Factory)this);
        instance.setEasyBeansInvocationContextFactory(this.getInvocationContextFactory());
        EasyBeansMDBContext mdbContext = new EasyBeansMDBContext(this);
        instance.setEasyBeansContext((EZBEJBContext)mdbContext);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            try {
                this.injectResources(instance);
            }
            catch (PoolException e) {
                throw new CreatePoolItemException(WAITING_TIME_BEFORE_CREATION, "Cannot inject resource in the instance", (Throwable)e);
            }
            instance.postConstructEasyBeansLifeCycle();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return instance;
    }

    public void poolItemRemoved(EasyBeansMDB mdb) {
        super.remove(mdb);
    }
}

