/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.mdb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.ow2.easybeans.api.bean.EasyBeansMDB;
import org.ow2.easybeans.container.mdb.MDBMessageEndPoint;
import org.ow2.easybeans.container.mdb.MDBMessageEndPointFactory;
import org.ow2.easybeans.event.bean.EventBeanInvocationEnd;
import org.ow2.easybeans.event.bean.EventBeanInvocationError;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class MDBMessageListenerEndPoint
extends MDBMessageEndPoint
implements MessageListener {
    private static Log logger = LogFactory.getLog(MDBMessageListenerEndPoint.class);
    private boolean useReflection = false;
    private Method onMessageMethod = null;
    private IEventDispatcher eventDispatcher = ((MDBMessageEndPointFactory)this.getEasyBeansFactory()).getEventDispatcher();
    private String methodEventProviderId = "";

    public MDBMessageListenerEndPoint(MDBMessageEndPointFactory mdbMessageEndPointFactory, EasyBeansMDB easyBeansMDB) {
        super(mdbMessageEndPointFactory, easyBeansMDB);
        String j2EEManagedObjectId = ((MDBMessageEndPointFactory)this.getEasyBeansFactory()).getJ2EEManagedObjectId();
        this.methodEventProviderId = j2EEManagedObjectId + "/onMessage_javax.jms.Message";
        if (!(easyBeansMDB instanceof MessageListener)) {
            logger.debug((Object)"Use reflection for message delivery as instance {0} is not implementing the interface", new Object[]{easyBeansMDB});
            this.useReflection = true;
            try {
                this.onMessageMethod = easyBeansMDB.getClass().getMethod("onMessage", Message.class);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("Cannot get the onMessage method on instance '" + easyBeansMDB + "'.", e);
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)"No onMessage method found on bean named {0}", new Object[]{easyBeansMDB});
                throw new IllegalArgumentException("Cannot get the onMessage method on instance '" + easyBeansMDB + "'.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block8: {
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getEasyBeansFactory().getContainer().getClassLoader());
            Object event = this.getMDBMessageEndPointFactory().getInvocationEventBegin(this.methodEventProviderId, new Object[]{message});
            long number = event.getInvocationNumber();
            this.eventDispatcher.dispatch((IEvent)event);
            try {
                if (!this.useReflection) {
                    ((MessageListener)this.getEasyBeansMDB()).onMessage(message);
                    event = new EventBeanInvocationEnd(this.methodEventProviderId, number, null);
                    break block8;
                }
                try {
                    this.onMessageMethod.invoke((Object)this.getEasyBeansMDB(), message);
                    event = new EventBeanInvocationEnd(this.methodEventProviderId, number, null);
                }
                catch (IllegalArgumentException e) {
                    event = new EventBeanInvocationError(this.methodEventProviderId, number, e);
                    throw new IllegalStateException("Cannot deliver the message", e);
                }
                catch (IllegalAccessException e) {
                    event = new EventBeanInvocationError(this.methodEventProviderId, number, e);
                    throw new IllegalStateException("Cannot deliver the message", e);
                }
                catch (InvocationTargetException e) {
                    event = new EventBeanInvocationError(this.methodEventProviderId, number, e);
                    logger.error((Object)"Cannot deliver the message", new Object[]{e.getTargetException()});
                    throw new IllegalStateException("Cannot deliver the message", e.getTargetException());
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
                this.eventDispatcher.dispatch((IEvent)event);
            }
        }
    }
}

