/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerCallback;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendAsyncProcessor
extends SendProcessor
implements Runnable,
Navigate<Processor> {
    private static final int DEFAULT_THREADPOOL_SIZE = 10;
    protected final Processor target;
    protected final BlockingQueue<Exchange> completedTasks = new LinkedBlockingQueue<Exchange>();
    protected ExecutorService executorService;
    protected ExecutorService producerExecutorService;
    protected int poolSize = 10;
    protected ExceptionHandler exceptionHandler;

    public SendAsyncProcessor(Endpoint destination, Processor target) {
        super(destination);
        this.target = target;
    }

    public SendAsyncProcessor(Endpoint destination, ExchangePattern pattern, Processor target) {
        super(destination, pattern);
        this.target = target;
    }

    @Override
    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, true);
        if (pattern != null) {
            copy.setPattern(pattern);
        } else {
            copy.setPattern(ExchangePattern.InOut);
        }
        copy.setProperty("CamelToEndpoint", this.destination.getEndpointUri());
        return copy;
    }

    @Override
    public Exchange doProcess(Exchange exchange) throws Exception {
        Exchange answer = this.getProducerCache(exchange).doInProducer(this.destination, exchange, this.pattern, new ProducerCallback<Exchange>(){

            @Override
            public Exchange doInProducer(Producer producer, Exchange exchange, ExchangePattern pattern) throws Exception {
                exchange = SendAsyncProcessor.this.configureExchange(exchange, pattern);
                AsyncCallback callback = new AsyncCallback(){

                    public void onTaskCompleted(Exchange exchange) {
                        SendAsyncProcessor.this.completedTasks.add(exchange);
                    }
                };
                if (producer instanceof AsyncProcessor) {
                    SendAsyncProcessor.this.doAsyncProcess((AsyncProcessor)((Object)producer), exchange, callback);
                } else {
                    SendAsyncProcessor.this.doSimulateAsyncProcess(producer, exchange, callback);
                }
                return exchange;
            }
        });
        return answer;
    }

    protected void doAsyncProcess(AsyncProcessor producer, Exchange exchange, AsyncCallback callback) throws Exception {
        producer.process(exchange, callback);
    }

    protected void doSimulateAsyncProcess(final Processor producer, final Exchange exchange, final AsyncCallback callback) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Producer " + producer + " is not an instanceof AsyncProcessor" + ". Will fallback to simulate async behavior by transferring task to a producer thread pool for further processing."));
        }
        this.getProducerExecutorService().submit(new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                try {
                    AsyncProcessor asyncProducer = exchange.getContext().getTypeConverter().convertTo(AsyncProcessor.class, producer);
                    asyncProducer.process(exchange, callback);
                }
                catch (Exception e) {
                    if (SendProcessor.LOG.isDebugEnabled()) {
                        SendProcessor.LOG.debug((Object)("Caught exception while processing: " + exchange), (Throwable)e);
                    }
                    exchange.setException(e);
                }
                return exchange;
            }
        });
    }

    @Override
    public String toString() {
        return "sendAsyncTo(" + this.destination + (this.pattern != null ? " " + (Object)((Object)this.pattern) : "") + " -> " + this.target + ")";
    }

    public ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.createExecutorService("SendAsyncProcessor-Consumer");
        }
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ExecutorService getProducerExecutorService() {
        if (this.producerExecutorService == null) {
            this.producerExecutorService = ExecutorServiceHelper.newCachedThreadPool("SendAsyncProcessor-Producer", true);
        }
        return this.producerExecutorService;
    }

    public void setProducerExecutorService(ExecutorService producerExecutorService) {
        this.producerExecutorService = producerExecutorService;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public boolean hasNext() {
        return this.target != null;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.target);
        return answer;
    }

    @Override
    public void run() {
        while (this.isRunAllowed()) {
            Exchange exchange;
            try {
                exchange = this.completedTasks.poll(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Sleep interrupted, are we stopping? " + (this.isStopping() || this.isStopped())));
                continue;
            }
            if (exchange == null) continue;
            try {
                if (exchange.hasOut()) {
                    exchange.setIn(exchange.getOut());
                    exchange.setOut(null);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Async reply received now routing the Exchange: " + exchange));
                }
                this.target.process(exchange);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException(e);
            }
        }
    }

    protected ExecutorService createExecutorService(String name) {
        return ExecutorServiceHelper.newScheduledThreadPool(this.poolSize, name, true);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        for (int i = 0; i < this.poolSize; ++i) {
            this.getExecutorService().execute(this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.producerExecutorService != null) {
            this.producerExecutorService.shutdownNow();
            this.producerExecutorService = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        this.completedTasks.clear();
    }
}

