/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.csiv2.SasComponent;
import org.ow2.carol.util.csiv2.SasHelper;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.EntityDesc;
import org.ow2.jonas.deployment.ejb.SessionDesc;
import org.ow2.jonas.deployment.ejb.SessionStatefulDesc;
import org.ow2.jonas.deployment.ejb.SessionStatelessDesc;
import org.ow2.jonas.lib.ejb21.EJBInvocation;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.ejb21.JHomeHandle;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.svc.JHomeHandleIIOP;
import org.ow2.jonas.lib.svc.JMetaData;
import org.ow2.util.ee.event.types.BeanRegisterEvent;
import org.ow2.util.ee.event.types.BeanUnregisterEvent;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;

public abstract class JHome
extends PortableRemoteObject
implements EJBHome {
    protected JMetaData ejbMetaData = null;
    protected BeanDesc dd;
    protected JFactory bf;
    protected boolean unregistered = true;
    private static final String EVENT_FILTER = "/beans/lifecycle/events";

    public JHome(BeanDesc dd, JFactory bf) throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"JHome constructor");
        }
        this.dd = dd;
        this.bf = bf;
    }

    public EJBMetaData getEJBMetaData() throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"JHome getEJBMetaData");
        }
        if (this.ejbMetaData == null) {
            if (this.dd instanceof SessionDesc) {
                boolean isSession = true;
                boolean isStatelessSession = this.dd instanceof SessionStatelessDesc;
                Class primaryKeyClass = null;
                this.ejbMetaData = new JMetaData((EJBHome)this, this.dd.getHomeClass(), this.dd.getRemoteClass(), isSession, isStatelessSession, primaryKeyClass);
            } else if (this.dd instanceof EntityDesc) {
                boolean isSession = false;
                boolean isStatelessSession = false;
                Class primaryKeyClass = ((EntityDesc)this.dd).getPrimaryKeyClass();
                this.ejbMetaData = new JMetaData((EJBHome)this, this.dd.getHomeClass(), this.dd.getRemoteClass(), isSession, isStatelessSession, primaryKeyClass);
            }
        }
        return this.ejbMetaData;
    }

    public HomeHandle getHomeHandle() throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        String protocol = ConfigurationRepository.getCurrentConfiguration().getProtocol().getName();
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("Current protocol = " + protocol));
        }
        if (protocol.equals("iiop")) {
            return new JHomeHandleIIOP((EJBHome)this, this.bf.myClassLoader());
        }
        return new JHomeHandle(this.dd.getJndiName());
    }

    public abstract void remove(Handle var1) throws RemoteException, RemoveException;

    public abstract void remove(Object var1) throws RemoteException, RemoveException;

    protected void register() throws NamingException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        final String name = this.dd.getJndiName();
        this.dispacthRegisterEvent();
        final JHome jhome = this;
        IExecution<Void> rebinder = new IExecution<Void>(){

            public Void execute() throws Exception {
                SasHelper.rebind((String)name, (Remote)((Object)jhome), (SasComponent)JHome.this.dd.getSasComponent());
                return null;
            }
        };
        ExecutionResult result = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)rebinder);
        if (result.hasException()) {
            TraceEjb.interp.log(BasicLevel.ERROR, (Object)"Cannot register bean");
            throw new RuntimeException("Cannot register bean:", result.getException());
        }
        this.unregistered = false;
    }

    private void dispacthRegisterEvent() {
        IEventDispatcher dispatcher = this.bf.cont.getLifeCycleDispatcher();
        if (dispatcher != null && this.dd.getCluster() != null) {
            BeanRegisterEvent beanRegisterEvent = new BeanRegisterEvent(EVENT_FILTER + this.dd.getJndiName());
            beanRegisterEvent.setJndiName(this.dd.getJndiName());
            beanRegisterEvent.setClassLoader(this.bf.cont.getClassLoader());
            beanRegisterEvent.setClusterConfig(this.dd.getCluster());
            beanRegisterEvent.setHomeClass(this.dd.getHomeClass());
            beanRegisterEvent.setStateful(this.dd instanceof SessionStatefulDesc || this.dd instanceof EntityDesc);
            beanRegisterEvent.setClusterReplicated(this.dd.isClusterReplicated());
            beanRegisterEvent.setRemoteClass(this.dd.getRemoteClass());
            beanRegisterEvent.setEventProviderFilter(EVENT_FILTER);
            dispatcher.dispatch((IEvent)beanRegisterEvent);
        }
    }

    protected void unregister() throws NamingException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        String name = this.dd.getJndiName();
        this.dispacthUnregisterEvent();
        this.bf.getInitialContext().unbind(name);
        try {
            PortableRemoteObject.unexportObject((Remote)((Object)this));
        }
        catch (NoSuchObjectException e) {
            TraceEjb.interp.log(BasicLevel.ERROR, (Object)"unexportObject(JHome) failed", (Throwable)e);
        }
        this.unregistered = true;
    }

    private void dispacthUnregisterEvent() {
        IEventDispatcher dispatcher = this.bf.cont.getLifeCycleDispatcher();
        if (dispatcher != null && this.dd.getCluster() != null) {
            BeanUnregisterEvent beanUnRegisterEvent = new BeanUnregisterEvent("jonas/service/ejb2-container/bean/unregister/" + this.dd.getJndiName());
            beanUnRegisterEvent.setJndiName(this.dd.getJndiName());
            beanUnRegisterEvent.setEventProviderFilter(EVENT_FILTER);
            dispatcher.dispatch((IEvent)beanUnRegisterEvent);
        }
    }

    public String getJndiName() {
        return this.dd.getJndiName();
    }

    public RequestCtx preInvoke(int txa) throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.bf.preInvokeRemote(txa);
    }

    public void checkSecurity(EJBInvocation ejbInv) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bf.checkSecurity(ejbInv);
    }

    public void postInvoke(RequestCtx rctx) throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bf.postInvokeRemote(rctx);
    }

    public BeanDesc getDd() {
        return this.dd;
    }

    public JFactory getBf() {
        return this.bf;
    }
}

