/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.facility.naming.longid;

import org.objectweb.jorm.api.PAccessor;
import org.objectweb.jorm.api.PBinding;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PExceptionNoDSI;
import org.objectweb.jorm.api.PMapCluster;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.facility.naming.basidir.BasidBinder;
import org.objectweb.jorm.facility.naming.generator.LongGen;
import org.objectweb.jorm.facility.naming.generator.LongGenIncrMgr;
import org.objectweb.jorm.facility.naming.generator.LongGenMgrRegistry;
import org.objectweb.jorm.facility.naming.generator.PLongGen;
import org.objectweb.jorm.facility.naming.longid.CompositePLongGen;
import org.objectweb.jorm.facility.naming.longid.LongIdPBinder;
import org.objectweb.jorm.facility.naming.longid.LongIdPNC;
import org.objectweb.jorm.facility.naming.polymorphid.ClassIdAccessor;
import org.objectweb.jorm.facility.naming.polymorphid.IdClassAccessor;
import org.objectweb.jorm.naming.api.PBinder;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PNamingContext;

public class LongIdManager {
    public static final int DEFAULT_CID_SIZE = 20;
    public static final int LONG_SIZE = 64;
    public static final String CLASS_ID_NAME = "org.objectweb.jorm.facility.naming.polymorphid.ClassId";
    public static final String ID_CLASS_NAME = "org.objectweb.jorm.facility.naming.polymorphid.IdClass";
    private LongGenIncrMgr idGenMgr;
    private LongGen classIdGen;
    private PMapper mapper;
    private int cidSize = 20;

    public LongIdManager() {
        this.setCidSize(20);
    }

    public LongIdManager(PMapper mapper) throws PException {
        this(mapper, 20);
    }

    public LongIdManager(PMapper mapper, int cidSize) throws PException {
        this.setCidSize(cidSize);
        this.setPMapper(mapper);
    }

    public int getCidSize() {
        return this.cidSize;
    }

    public void setCidSize(int cidSize) {
        this.cidSize = cidSize;
    }

    public PMapper getMapper() {
        return this.mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPMapper(PMapper mapper) throws PException {
        if (mapper == null) {
            throw new PExceptionNaming("No mapper specified");
        }
        this.mapper = mapper;
        Object object = LongGenMgrRegistry.class;
        synchronized (object) {
            this.idGenMgr = (LongGenIncrMgr)LongGenMgrRegistry.getLongGenMgr(mapper);
            if (this.idGenMgr == null) {
                try {
                    this.idGenMgr = (LongGenIncrMgr)Class.forName(this.getLongGenMgr()).newInstance();
                }
                catch (Exception e) {
                    throw new PException(e, "Cannot create LongGenMgr (probably a ClassLoader problem): " + this.getLongGenMgr());
                }
                this.idGenMgr.init(mapper, (byte)3);
                LongGenMgrRegistry.registerLonGenMgr(this.idGenMgr, mapper);
            }
        }
        this.classIdGen = this.idGenMgr.getLongGen(CLASS_ID_NAME, null);
        object = mapper;
        synchronized (object) {
            if (mapper.lookup(CLASS_ID_NAME) == null) {
                PClassMapping pcm;
                String cn = mapper.cn2mn(CLASS_ID_NAME) + "Mapping";
                BasidBinder binder = new BasidBinder(1024);
                try {
                    pcm = (PClassMapping)Class.forName(cn).newInstance();
                }
                catch (Exception e) {
                    throw new PException(e);
                }
                pcm.setPBinder(binder);
                binder.setPClassMapping(pcm);
                mapper.map(pcm);
                PMapCluster cl = mapper.getPMapCluster(pcm.getClassName());
                cl.createMappingStructures(false);
            }
        }
    }

    private String getLongGenMgr() {
        String mn = this.mapper.getMapperName();
        int idx = mn.indexOf(46);
        if (idx != -1) {
            mn = mn.substring(0, idx);
        }
        return "org.objectweb.jorm.facility.naming.generator." + mn + ".LongGenIncrMapping";
    }

    public PBinder newGenClassPBinder() throws PException {
        return new BasidBinder(16, -1L);
    }

    public PNamingContext newClassPNamingContext() throws PException {
        return new LongIdPNC(this.cidSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PBinder newClassPBinder(String className, Object conn) throws PException {
        LongIdPBinder longIdPBinder;
        block4: {
            if (this.mapper == null) {
                throw new PException("The LongIdManager has not been configured, a PMapper is required");
            }
            Object connection = conn;
            if (conn == null) {
                connection = this.mapper.getConnection();
            }
            try {
                CompositePLongGen lg = new CompositePLongGen((PLongGen)this.idGenMgr.getLongGen(className, connection), this.getCID(className, connection), this.cidSize);
                LongIdPBinder lib = new LongIdPBinder();
                lib.setACFLid(lg);
                longIdPBinder = lib;
                Object var8_7 = null;
                if (conn != null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var8_8 = null;
                    if (conn != null) break block5;
                    this.mapper.closeConnection(connection);
                }
                throw throwable;
            }
            this.mapper.closeConnection(connection);
        }
        return longIdPBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getCID(String className, Object conn) throws PException {
        CIDAccessor acc;
        PBinding binding;
        block7: {
            PClassMapping pcm = this.mapper.lookup(CLASS_ID_NAME);
            binding = pcm.createPBinding();
            binding.bind(pcm.getPBinder().decodeString(className));
            Object connection = conn;
            if (conn == null) {
                connection = this.mapper.getConnection();
            }
            acc = new CIDAccessor(className);
            try {
                try {
                    binding.read(connection, acc);
                }
                catch (PExceptionNoDSI e) {
                    binding.export(connection, className);
                    acc.cid = this.classIdGen.genId(connection);
                    binding.write(connection, acc);
                    Object var9_8 = null;
                    if (conn == null) {
                        this.mapper.closeConnection(connection);
                    }
                    break block7;
                }
                Object var9_7 = null;
                if (conn != null) break block7;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (conn == null) {
                    this.mapper.closeConnection(connection);
                }
                throw throwable;
            }
            this.mapper.closeConnection(connection);
        }
        binding.unbind();
        return acc.cid;
    }

    private class CIDAccessor
    implements PAccessor,
    ClassIdAccessor,
    IdClassAccessor {
        public long cid;
        public String className;

        public CIDAccessor(String className) {
            this.className = className;
        }

        public CIDAccessor(long cid) {
            this.cid = cid;
        }

        public Object getMemoryInstance() {
            return this;
        }

        public void paSetClassId(long val) throws PException {
            this.cid = val;
        }

        public long paGetClassId() throws PException {
            return this.cid;
        }

        public void paSetClassName(String val) throws PException {
            this.className = val;
        }

        public String paGetClassName() throws PException {
            return this.className;
        }
    }
}

