/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.openjpa.slice.jdbc.DistributedConnection;
import org.apache.openjpa.slice.jdbc.DistributedResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DistributedTemplate<T extends Statement>
implements Statement,
Iterable<T> {
    protected List<T> stmts = new ArrayList<T>();
    protected final DistributedConnection con;
    protected T master;

    public DistributedTemplate(DistributedConnection c) {
        this.con = c;
    }

    @Override
    public Iterator<T> iterator() {
        return this.stmts.iterator();
    }

    public void add(T s) {
        if (this.stmts.isEmpty()) {
            this.master = s;
        }
        try {
            if (!this.con.contains(s.getConnection())) {
                throw new IllegalArgumentException(s + " has different connection");
            }
            this.stmts.add(s);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addBatch(String sql2) throws SQLException {
        for (Statement s : this) {
            s.addBatch(sql2);
        }
    }

    @Override
    public void cancel() throws SQLException {
        for (Statement s : this) {
            s.cancel();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        for (Statement s : this) {
            s.clearBatch();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        for (Statement s : this) {
            s.clearWarnings();
        }
    }

    @Override
    public void close() throws SQLException {
        for (Statement s : this) {
            s.close();
        }
    }

    @Override
    public boolean execute(String arg0) throws SQLException {
        boolean ret = true;
        for (Statement s : this) {
            ret = s.execute(arg0) & ret;
        }
        return ret;
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        boolean ret = true;
        for (Statement s : this) {
            ret = s.execute(arg0, arg1) & ret;
        }
        return ret;
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        boolean ret = true;
        for (Statement s : this) {
            ret = s.execute(arg0, arg1) & ret;
        }
        return ret;
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        boolean ret = true;
        for (Statement s : this) {
            ret = s.execute(arg0, arg1) & ret;
        }
        return ret;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] ret = new int[]{};
        for (Statement s : this) {
            int[] tmp = s.executeBatch();
            ret = new int[ret.length + tmp.length];
            System.arraycopy(tmp, 0, ret, ret.length - tmp.length, tmp.length);
        }
        return ret;
    }

    public ResultSet executeQuery() throws SQLException {
        DistributedResultSet rs = new DistributedResultSet();
        for (Statement s : this) {
            rs.add(s.executeQuery(null));
        }
        return rs;
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        DistributedResultSet rs = new DistributedResultSet();
        for (Statement s : this) {
            rs.add(s.executeQuery(arg0));
        }
        return rs;
    }

    @Override
    public int executeUpdate(String arg0) throws SQLException {
        int ret = 0;
        for (Statement s : this) {
            ret += s.executeUpdate(arg0);
        }
        return ret;
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        int ret = 0;
        for (Statement s : this) {
            ret += s.executeUpdate(arg0, arg1);
        }
        return ret;
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        int ret = 0;
        for (Statement s : this) {
            ret += s.executeUpdate(arg0, arg1);
        }
        return ret;
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        int ret = 0;
        for (Statement s : this) {
            ret += s.executeUpdate(arg0, arg1);
        }
        return ret;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.con;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.master.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.master.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        DistributedResultSet mrs = new DistributedResultSet();
        for (Statement s : this) {
            mrs.add(s.getGeneratedKeys());
        }
        return mrs;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.master.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.master.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        for (Statement s : this) {
            if (!s.getMoreResults()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        for (Statement s : this) {
            if (!s.getMoreResults(arg0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.master.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        DistributedResultSet rs = new DistributedResultSet();
        for (Statement s : this) {
            rs.add(s.getResultSet());
        }
        return rs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.master.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.master.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.master.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.master.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.master.getWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        for (Statement s : this) {
            s.setCursorName(name);
        }
    }

    @Override
    public void setEscapeProcessing(boolean flag) throws SQLException {
        for (Statement s : this) {
            s.setEscapeProcessing(flag);
        }
    }

    @Override
    public void setFetchDirection(int dir) throws SQLException {
        for (Statement s : this) {
            s.setFetchDirection(dir);
        }
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        for (Statement s : this) {
            s.setFetchSize(size);
        }
    }

    @Override
    public void setMaxFieldSize(int size) throws SQLException {
        for (Statement s : this) {
            s.setMaxFieldSize(size);
        }
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        for (Statement s : this) {
            s.setMaxFieldSize(n);
        }
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        for (Statement s : this) {
            s.setMaxFieldSize(n);
        }
    }
}

