/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.context;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class StringMap
extends TreeMap {
    private static final long serialVersionUID = 6948801857034259744L;

    public StringMap() {
        this(true);
    }

    public StringMap(boolean caseSensitive) {
        super(new StringComparator(caseSensitive));
    }

    public StringMap(Map map, boolean caseSensitive) {
        this(caseSensitive);
        this.putAll(map);
    }

    public Object put(Object key, Object value) {
        return super.put(key.toString(), value);
    }

    public boolean isCaseSensitive() {
        return ((StringComparator)this.comparator()).isCaseSensitive();
    }

    public void setCaseSensitive(boolean flag) {
        ((StringComparator)this.comparator()).setCaseSensitive(flag);
    }

    private static class StringComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean m_isCaseSensitive = true;

        public StringComparator(boolean flag) {
            this.m_isCaseSensitive = flag;
        }

        public int compare(Object object1, Object object2) {
            if (this.m_isCaseSensitive) {
                return object1.toString().compareTo(object2.toString());
            }
            return object1.toString().compareToIgnoreCase(object2.toString());
        }

        public boolean isCaseSensitive() {
            return this.m_isCaseSensitive;
        }

        public void setCaseSensitive(boolean flag) {
            this.m_isCaseSensitive = flag;
        }
    }
}

