/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session.singleton;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.Timer;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.EasyBeansSingletonSB;
import org.ow2.easybeans.container.session.PoolWrapper;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.event.bean.EventBeanInvocationEnd;
import org.ow2.easybeans.event.bean.EventBeanInvocationError;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.rpc.JEJBResponse;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.enhanced.EnhancedPool;
import org.ow2.util.pool.impl.enhanced.manager.IPoolManager;
import org.ow2.util.pool.impl.enhanced.manager.optional.IPoolItemRemoveManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonSessionFactory
extends SessionFactory<EasyBeansSingletonSB>
implements IPoolItemRemoveManager<EasyBeansSingletonSB> {
    private ReadWriteLock lock = null;

    public SingletonSessionFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
        EnhancedPool singletonPool = this.getManagementPool().getEnhancedPoolFactory().createEnhancedPool((IPoolManager)this);
        this.setPool(new PoolWrapper(singletonPool));
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    protected EasyBeansSingletonSB getBean(Long beanId) throws IllegalArgumentException {
        try {
            return (EasyBeansSingletonSB)this.getPool().get();
        }
        catch (PoolException e) {
            throw new IllegalArgumentException("Cannot get element in the pool", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EJBResponse localCall(EJBLocalRequest localCallRequest) {
        JEJBResponse ejbResponse = new JEJBResponse();
        EasyBeansSingletonSB bean = null;
        try {
            bean = this.getBean(null);
        }
        catch (IllegalArgumentException e) {
            ejbResponse.setRPCException(new RPCException("Cannot get element in the pool", (Throwable)e));
            return ejbResponse;
        }
        catch (NoSuchEJBException e) {
            ejbResponse.setRPCException(new RPCException("Bean has been removed", (Throwable)e));
            return ejbResponse;
        }
        Method m = this.getHashes().get(localCallRequest.getMethodHash());
        if (m == null) {
            ejbResponse.setRPCException(new RPCException("Cannot find method called on the bean '" + this.getClassName() + "'."));
            return ejbResponse;
        }
        Object value = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        String oldInvokedBusinessInterface = (String)this.getInvokedBusinessInterfaceNameThreadLocal().get();
        this.getInvokedBusinessInterfaceNameThreadLocal().set(localCallRequest.getInvokedBusinessInterfaceName());
        OperationState oldState = this.getOperationState();
        this.getOperationStateThreadLocal().set(OperationState.BUSINESS_METHOD);
        String methodEventProviderId = this.getJ2EEManagedObjectId() + "/" + J2EEManagedObjectNamingHelper.getMethodSignature(m) + "@Local";
        Object event = this.getInvocationEventBegin(methodEventProviderId, localCallRequest.getMethodArgs());
        long number = event.getInvocationNumber();
        this.getEventDispatcher().dispatch((IEvent)event);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            value = m.invoke((Object)bean, localCallRequest.getMethodArgs());
        }
        catch (IllegalArgumentException e) {
            ejbResponse.setRPCException(new RPCException((Throwable)e));
            event = new EventBeanInvocationError(methodEventProviderId, number, e);
        }
        catch (IllegalAccessException e) {
            ejbResponse.setRPCException(new RPCException((Throwable)e));
            event = new EventBeanInvocationError(methodEventProviderId, number, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            RPCException rpcException = new RPCException(cause);
            ApplicationException applicationException = (ApplicationException)this.getBeanInfo().getApplicationExceptions().get(cause.getClass().getName());
            if (applicationException != null) {
                rpcException.setApplicationException();
            }
            ejbResponse.setRPCException(rpcException);
            event = new EventBeanInvocationError(methodEventProviderId, number, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
            this.getOperationStateThreadLocal().set(oldState);
            try {
                this.getPool().release((Object)bean);
            }
            catch (PoolException e) {
                ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e));
            }
            writeLock.unlock();
            event = new EventBeanInvocationEnd(methodEventProviderId, number, value);
        }
        ejbResponse.setValue(value);
        if (!localCallRequest.isCalledFromRemoteRequest()) {
            this.getEventDispatcher().dispatch((IEvent)event);
        }
        return ejbResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws FactoryException {
        super.start();
        EasyBeansSingletonSB bean = null;
        if (this.getSessionBeanInfo().isStartup()) {
            try {
                bean = this.getBean(null);
            }
            finally {
                try {
                    this.getPool().release((Object)bean);
                }
                catch (PoolException e) {
                    throw new FactoryException("Cannot release bean", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimeout(Timer timer) {
        EasyBeansSingletonSB bean = null;
        bean = this.getBean(null);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            bean.timeoutCallByEasyBeans(timer);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            try {
                this.getPool().release((Object)bean);
            }
            catch (PoolException e) {
                throw new EJBException("cannot release bean", (Exception)((Object)e));
            }
        }
    }
}

