/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.jgroups.comm.handler;

import java.io.IOException;
import java.io.Serializable;
import org.jgroups.Address;
import org.jgroups.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.discovery.base.comm.DiscGreeting;
import org.ow2.jonas.discovery.jgroups.comm.handler.DiscCommHandlerImpl;
import org.ow2.jonas.discovery.jgroups.utils.Data;
import org.ow2.jonas.discovery.jgroups.utils.JGroupsDiscoveryUtils;
import org.ow2.jonas.lib.util.Log;

public class DiscCommGreetingHandler
extends DiscCommHandlerImpl {
    public DiscCommGreetingHandler(Address hostAddress) {
        super(hostAddress);
    }

    public void receive(Message msg) {
        if (this.logger == null) {
            this.logger = Log.getLogger((String)"org.ow2.jonas.discovery");
        }
        Object objReceived = null;
        Data data = null;
        this.logger.log(BasicLevel.DEBUG, (Object)(" Hi all on " + this.multicastAddress + ". My name is " + this.hostName + ". I've received greeting message from " + msg.getSrc()));
        Address senderAddress = msg.getSrc();
        data = (Data)msg.getObject();
        try {
            objReceived = JGroupsDiscoveryUtils.bytesToObject(data);
        }
        catch (IOException e) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" IOException occured in DiscCommGreetingHandler. Unable to cast data received on network into Object. Received packet content must not be the expected one \n" + e));
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" Following Exception occurred in DiscCommGreetingHandler. Unable to cast data received on network into Object. Received packet content must not be the expected one \n" + e));
        }
        if (objReceived != null && objReceived instanceof DiscGreeting) {
            DiscGreeting message = (DiscGreeting)objReceived;
            try {
                this.handleGreeting(message, senderAddress);
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.DEBUG, (Object)(" Exception occurend while handling Greeting: " + e));
            }
        }
    }

    private void handleGreeting(DiscGreeting message, Address add2Reply) throws Exception {
        this.logger.log(BasicLevel.DEBUG, (Object)(" My name is" + this.hostName + ". Handling greeting message received from " + message.getSourceAddress()));
        if (message.getState().equals("starting up")) {
            if (message.getDomainName().equals(JGroupsDiscoveryUtils.getInstance().getServerId()) && message.getServerName().equals(JGroupsDiscoveryUtils.getInstance().getServerId())) {
                this.logger.log(BasicLevel.DEBUG, (Object)(" My name is " + this.hostName + ". I will send DuplicateServerNameException to " + message.getSourceAddress() + " \n"));
                DiscGreeting duplicateNameNotif = JGroupsDiscoveryUtils.createDiscGreeting(false);
                JGroupsDiscoveryUtils.send(add2Reply, JGroupsDiscoveryUtils.objectToBytes((Serializable)duplicateNameNotif));
            }
        } else if (message.getState().equals("duplicate server name found")) {
            JGroupsDiscoveryUtils.duplicateExceptionName = true;
            this.logger.log(BasicLevel.INFO, (Object)(" My name is " + this.hostName + ". Cannot go on starting. A server named " + message.getServerName() + " hosted on " + message.getSourceAddress() + " As already started with my configuration on domain: " + message.getDomainName() + "\n"));
            this.logger.log(BasicLevel.INFO, (Object)" You may change my 'name' or my 'domain name' to resolve this problem.\n");
            Thread.interrupted();
        }
    }
}

