/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndpointFactory
extends AbstractBasicInterceptorProvider {
    private static final String PRIVATE_ENDPOINT = "org.apache.cxf.endpoint.private";
    private static final String PRIVATE_ENDPOINTS = "org.apache.cxf.private.endpoints";
    protected Bus bus;
    protected String address;
    protected String transportId;
    protected String bindingId;
    protected DataBinding dataBinding;
    protected BindingFactory bindingFactory;
    protected DestinationFactory destinationFactory;
    protected String publishedEndpointUrl;
    protected QName endpointName;
    protected QName serviceName;
    protected Map<String, Object> properties;
    protected List<AbstractFeature> features;
    protected BindingConfiguration bindingConfig;
    protected EndpointReferenceType endpointReference;
    protected ConduitSelector conduitSelector;

    protected abstract Endpoint createEndpoint() throws BusException, EndpointException;

    protected abstract EndpointInfo createEndpointInfo() throws BusException;

    protected abstract BindingInfo createBindingInfo();

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = BusFactory.getThreadDefaultBus();
        }
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public String getTransportId() {
        return this.transportId;
    }

    public void setTransportId(String transportId) {
        this.transportId = transportId;
    }

    public void setBindingId(String bind) {
        this.bindingId = bind;
    }

    public String getBindingId() {
        return this.bindingId;
    }

    public void setBindingConfig(BindingConfiguration obj) {
        this.bindingConfig = obj;
    }

    public BindingConfiguration getBindingConfig() {
        return this.bindingConfig;
    }

    public DestinationFactory getDestinationFactory() {
        return this.destinationFactory;
    }

    public void setDestinationFactory(DestinationFactory destinationFactory) {
        this.destinationFactory = destinationFactory;
    }

    public String getPublishedEndpointUrl() {
        return this.publishedEndpointUrl;
    }

    public void setPublishedEndpointUrl(String publishedEndpointUrl) {
        this.publishedEndpointUrl = publishedEndpointUrl;
    }

    public QName getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(QName endpointName) {
        this.endpointName = endpointName;
    }

    public void setServiceName(QName name) {
        this.serviceName = name;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setEndpointReference(EndpointReferenceType epr) {
        this.endpointReference = epr;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public List<AbstractFeature> getFeatures() {
        if (this.features == null) {
            this.features = new ArrayList<AbstractFeature>();
        }
        return this.features;
    }

    public void setFeatures(List<AbstractFeature> features) {
        this.features = features;
    }

    public BindingFactory getBindingFactory() {
        return this.bindingFactory;
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bindingFactory = bf;
    }

    public ConduitSelector getConduitSelector() {
        return this.conduitSelector;
    }

    public void setConduitSelector(ConduitSelector selector) {
        this.conduitSelector = selector;
    }

    public DataBinding getDataBinding() {
        return this.dataBinding;
    }

    public void setDataBinding(DataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }

    protected boolean checkPrivateEndpoint(Endpoint ep) {
        if (MessageUtils.isTrue(ep.get(PRIVATE_ENDPOINT))) {
            LinkedList<String> addresses = (LinkedList<String>)this.getBus().getProperty(PRIVATE_ENDPOINTS);
            if (addresses == null) {
                addresses = new LinkedList<String>();
            }
            addresses.add(this.getAddress());
            this.bus.setProperty(PRIVATE_ENDPOINTS, addresses);
            return true;
        }
        return false;
    }
}

