/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.DelegatingBroker;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.FindCallbacks;
import org.apache.openjpa.kernel.OpCallbacks;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.AutoClearType;
import org.apache.openjpa.persistence.AutoDetachType;
import org.apache.openjpa.persistence.CallbackMode;
import org.apache.openjpa.persistence.ConnectionRetainMode;
import org.apache.openjpa.persistence.DetachStateType;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.ExtentImpl;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.Generator;
import org.apache.openjpa.persistence.GeneratorImpl;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAEntityTransaction;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.RestoreStateType;
import org.apache.openjpa.persistence.RollbackException;
import org.apache.openjpa.persistence.TransactionRequiredException;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.RuntimeExceptionTranslator;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerImpl
implements OpenJPAEntityManagerSPI,
Externalizable,
FindCallbacks,
OpCallbacks,
Closeable,
OpenJPAEntityTransaction {
    private static final Localizer _loc = Localizer.forPackage(EntityManagerImpl.class);
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    private DelegatingBroker _broker;
    private EntityManagerFactoryImpl _emf;
    private Map<FetchConfiguration, FetchPlan> _plans = new IdentityHashMap<FetchConfiguration, FetchPlan>(1);
    private RuntimeExceptionTranslator ret = PersistenceExceptions.getRollbackTranslator(this);

    public EntityManagerImpl() {
    }

    public EntityManagerImpl(EntityManagerFactoryImpl factory, Broker broker) {
        this.initialize(factory, broker);
    }

    private void initialize(EntityManagerFactoryImpl factory, Broker broker) {
        this._emf = factory;
        this._broker = new DelegatingBroker(broker, this.ret);
        this._broker.setImplicitBehavior(this, this.ret);
    }

    public Broker getBroker() {
        return this._broker.getDelegate();
    }

    @Override
    public OpenJPAEntityManagerFactory getEntityManagerFactory() {
        return this._emf;
    }

    @Override
    public OpenJPAConfiguration getConfiguration() {
        return this._broker.getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchPlan getFetchPlan() {
        this.assertNotCloseInvoked();
        this._broker.lock();
        try {
            FetchConfiguration fc = this._broker.getFetchConfiguration();
            FetchPlan fp = this._plans.get(fc);
            if (fp == null) {
                fp = this._emf.toFetchPlan(this._broker, fc);
                this._plans.put(fc, fp);
            }
            FetchPlan fetchPlan = fp;
            return fetchPlan;
        }
        finally {
            this._broker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchPlan pushFetchPlan() {
        this.assertNotCloseInvoked();
        this._broker.lock();
        try {
            this._broker.pushFetchConfiguration();
            FetchPlan fetchPlan = this.getFetchPlan();
            return fetchPlan;
        }
        finally {
            this._broker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popFetchPlan() {
        this.assertNotCloseInvoked();
        this._broker.lock();
        try {
            this._broker.popFetchConfiguration();
        }
        finally {
            this._broker.unlock();
        }
    }

    @Override
    public ConnectionRetainMode getConnectionRetainMode() {
        return ConnectionRetainMode.fromKernelConstant(this._broker.getConnectionRetainMode());
    }

    @Override
    public boolean isTransactionManaged() {
        return this._broker.isManaged();
    }

    @Override
    public boolean isManaged() {
        return this._broker.isManaged();
    }

    @Override
    public ManagedRuntime getManagedRuntime() {
        return this._broker.getManagedRuntime();
    }

    @Override
    public boolean getSyncWithManagedTransactions() {
        return this._broker.getSyncWithManagedTransactions();
    }

    @Override
    public void setSyncWithManagedTransactions(boolean sync) {
        this.assertNotCloseInvoked();
        this._broker.setSyncWithManagedTransactions(sync);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._broker.getClassLoader();
    }

    @Override
    public String getConnectionUserName() {
        return this._broker.getConnectionUserName();
    }

    @Override
    public String getConnectionPassword() {
        return this._broker.getConnectionPassword();
    }

    @Override
    public boolean getMultithreaded() {
        return this._broker.getMultithreaded();
    }

    @Override
    public void setMultithreaded(boolean multithreaded) {
        this.assertNotCloseInvoked();
        this._broker.setMultithreaded(multithreaded);
    }

    @Override
    public boolean getIgnoreChanges() {
        return this._broker.getIgnoreChanges();
    }

    @Override
    public void setIgnoreChanges(boolean val) {
        this.assertNotCloseInvoked();
        this._broker.setIgnoreChanges(val);
    }

    @Override
    public boolean getNontransactionalRead() {
        return this._broker.getNontransactionalRead();
    }

    @Override
    public void setNontransactionalRead(boolean val) {
        this.assertNotCloseInvoked();
        this._broker.setNontransactionalRead(val);
    }

    @Override
    public boolean getNontransactionalWrite() {
        return this._broker.getNontransactionalWrite();
    }

    @Override
    public void setNontransactionalWrite(boolean val) {
        this.assertNotCloseInvoked();
        this._broker.setNontransactionalWrite(val);
    }

    @Override
    public boolean getOptimistic() {
        return this._broker.getOptimistic();
    }

    @Override
    public void setOptimistic(boolean val) {
        this.assertNotCloseInvoked();
        this._broker.setOptimistic(val);
    }

    @Override
    public RestoreStateType getRestoreState() {
        return RestoreStateType.fromKernelConstant(this._broker.getRestoreState());
    }

    @Override
    public void setRestoreState(RestoreStateType val) {
        this.assertNotCloseInvoked();
        this._broker.setRestoreState(val.toKernelConstant());
    }

    @Override
    public void setRestoreState(int restore) {
        this.assertNotCloseInvoked();
        this._broker.setRestoreState(restore);
    }

    @Override
    public boolean getRetainState() {
        return this._broker.getRetainState();
    }

    @Override
    public void setRetainState(boolean val) {
        this.assertNotCloseInvoked();
        this._broker.setRetainState(val);
    }

    @Override
    public AutoClearType getAutoClear() {
        return AutoClearType.fromKernelConstant(this._broker.getAutoClear());
    }

    @Override
    public void setAutoClear(AutoClearType val) {
        this.assertNotCloseInvoked();
        this._broker.setAutoClear(val.toKernelConstant());
    }

    @Override
    public void setAutoClear(int autoClear) {
        this.assertNotCloseInvoked();
        this._broker.setAutoClear(autoClear);
    }

    @Override
    public DetachStateType getDetachState() {
        return DetachStateType.fromKernelConstant(this._broker.getDetachState());
    }

    @Override
    public void setDetachState(DetachStateType type) {
        this.assertNotCloseInvoked();
        this._broker.setDetachState(type.toKernelConstant());
    }

    @Override
    public void setDetachState(int detach) {
        this.assertNotCloseInvoked();
        this._broker.setDetachState(detach);
    }

    @Override
    public EnumSet<AutoDetachType> getAutoDetach() {
        return AutoDetachType.toEnumSet(this._broker.getAutoDetach());
    }

    @Override
    public void setAutoDetach(AutoDetachType flag) {
        this.assertNotCloseInvoked();
        this._broker.setAutoDetach(AutoDetachType.fromEnumSet(EnumSet.of(flag)));
    }

    @Override
    public void setAutoDetach(EnumSet<AutoDetachType> flags) {
        this.assertNotCloseInvoked();
        this._broker.setAutoDetach(AutoDetachType.fromEnumSet(flags));
    }

    @Override
    public void setAutoDetach(int autoDetachFlags) {
        this.assertNotCloseInvoked();
        this._broker.setAutoDetach(autoDetachFlags);
    }

    @Override
    public void setAutoDetach(AutoDetachType value, boolean on) {
        this.assertNotCloseInvoked();
        this._broker.setAutoDetach(AutoDetachType.fromEnumSet(EnumSet.of(value)), on);
    }

    @Override
    public void setAutoDetach(int flag, boolean on) {
        this.assertNotCloseInvoked();
        this._broker.setAutoDetach(flag, on);
    }

    @Override
    public boolean getEvictFromStoreCache() {
        return this._broker.getEvictFromDataCache();
    }

    @Override
    public void setEvictFromStoreCache(boolean evict) {
        this.assertNotCloseInvoked();
        this._broker.setEvictFromDataCache(evict);
    }

    @Override
    public boolean getPopulateStoreCache() {
        return this._broker.getPopulateDataCache();
    }

    @Override
    public void setPopulateStoreCache(boolean cache) {
        this.assertNotCloseInvoked();
        this._broker.setPopulateDataCache(cache);
    }

    @Override
    public boolean isTrackChangesByType() {
        return this._broker.isTrackChangesByType();
    }

    @Override
    public void setTrackChangesByType(boolean trackByType) {
        this.assertNotCloseInvoked();
        this._broker.setTrackChangesByType(trackByType);
    }

    @Override
    public boolean isLargeTransaction() {
        return this.isTrackChangesByType();
    }

    @Override
    public void setLargeTransaction(boolean value) {
        this.setTrackChangesByType(value);
    }

    @Override
    public Object getUserObject(Object key) {
        return this._broker.getUserObject(key);
    }

    @Override
    public Object putUserObject(Object key, Object val) {
        this.assertNotCloseInvoked();
        return this._broker.putUserObject(key, val);
    }

    @Override
    public void addTransactionListener(Object listener) {
        this.assertNotCloseInvoked();
        this._broker.addTransactionListener(listener);
    }

    @Override
    public void removeTransactionListener(Object listener) {
        this.assertNotCloseInvoked();
        this._broker.removeTransactionListener(listener);
    }

    @Override
    public EnumSet<CallbackMode> getTransactionListenerCallbackModes() {
        return CallbackMode.toEnumSet(this._broker.getTransactionListenerCallbackMode());
    }

    @Override
    public void setTransactionListenerCallbackMode(CallbackMode mode) {
        this.assertNotCloseInvoked();
        this._broker.setTransactionListenerCallbackMode(CallbackMode.fromEnumSet(EnumSet.of(mode)));
    }

    @Override
    public void setTransactionListenerCallbackMode(EnumSet<CallbackMode> modes) {
        this.assertNotCloseInvoked();
        this._broker.setTransactionListenerCallbackMode(CallbackMode.fromEnumSet(modes));
    }

    @Override
    public int getTransactionListenerCallbackMode() {
        return this._broker.getTransactionListenerCallbackMode();
    }

    @Override
    public void setTransactionListenerCallbackMode(int callbackMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLifecycleListener(Object listener, Class ... classes) {
        this.assertNotCloseInvoked();
        this._broker.addLifecycleListener(listener, classes);
    }

    @Override
    public void removeLifecycleListener(Object listener) {
        this.assertNotCloseInvoked();
        this._broker.removeLifecycleListener(listener);
    }

    @Override
    public EnumSet<CallbackMode> getLifecycleListenerCallbackModes() {
        return CallbackMode.toEnumSet(this._broker.getLifecycleListenerCallbackMode());
    }

    @Override
    public void setLifecycleListenerCallbackMode(CallbackMode mode) {
        this.assertNotCloseInvoked();
        this._broker.setLifecycleListenerCallbackMode(CallbackMode.fromEnumSet(EnumSet.of(mode)));
    }

    @Override
    public void setLifecycleListenerCallbackMode(EnumSet<CallbackMode> modes) {
        this.assertNotCloseInvoked();
        this._broker.setLifecycleListenerCallbackMode(CallbackMode.fromEnumSet(modes));
    }

    @Override
    public int getLifecycleListenerCallbackMode() {
        return this._broker.getLifecycleListenerCallbackMode();
    }

    @Override
    public void setLifecycleListenerCallbackMode(int callbackMode) {
        this.assertNotCloseInvoked();
        this._broker.setLifecycleListenerCallbackMode(callbackMode);
    }

    public <T> T getReference(Class<T> cls, Object oid) {
        this.assertNotCloseInvoked();
        oid = this._broker.newObjectId(cls, oid);
        return (T)this._broker.find(oid, false, this);
    }

    public <T> T find(Class<T> cls, Object oid) {
        this.assertNotCloseInvoked();
        oid = this._broker.newObjectId(cls, oid);
        return (T)this._broker.find(oid, true, this);
    }

    @Override
    public <T> T[] findAll(Class<T> cls, Object ... oids) {
        if (oids.length == 0) {
            return (Object[])Array.newInstance(cls, 0);
        }
        Collection<Object> ret = this.findAll(cls, Arrays.asList(oids));
        return ret.toArray((Object[])Array.newInstance(cls, ret.size()));
    }

    @Override
    public <T> Collection<T> findAll(final Class<T> cls, Collection oids) {
        this.assertNotCloseInvoked();
        Object[] objs = this._broker.findAll(oids, true, new FindCallbacks(){

            public Object processArgument(Object oid) {
                return EntityManagerImpl.this._broker.newObjectId(cls, oid);
            }

            public Object processReturn(Object oid, OpenJPAStateManager sm) {
                return EntityManagerImpl.this.processReturn(oid, sm);
            }
        });
        return Arrays.asList(objs);
    }

    @Override
    public <T> T findCached(Class<T> cls, Object oid) {
        this.assertNotCloseInvoked();
        return (T)this._broker.findCached(this._broker.newObjectId(cls, oid), this);
    }

    @Override
    public Class getObjectIdClass(Class cls) {
        this.assertNotCloseInvoked();
        if (cls == null) {
            return null;
        }
        return JPAFacadeHelper.fromOpenJPAObjectIdClass(this._broker.getObjectIdType(cls));
    }

    @Override
    public OpenJPAEntityTransaction getTransaction() {
        if (this._broker.isManaged()) {
            throw new InvalidStateException(_loc.get("get-managed-trans"), null, null, false);
        }
        return this;
    }

    public void joinTransaction() {
        this.assertNotCloseInvoked();
        if (!this._broker.syncWithManagedTransaction()) {
            throw new TransactionRequiredException(_loc.get("no-managed-trans"), null, null, false);
        }
    }

    @Override
    public void begin() {
        this._broker.begin();
    }

    @Override
    public void commit() {
        try {
            this._broker.commit();
        }
        catch (RollbackException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RollbackException(e);
        }
    }

    @Override
    public void rollback() {
        this._broker.rollback();
    }

    @Override
    public void commitAndResume() {
        this._broker.commitAndResume();
    }

    @Override
    public void rollbackAndResume() {
        this._broker.rollbackAndResume();
    }

    @Override
    public Throwable getRollbackCause() {
        if (!this.isActive()) {
            throw new IllegalStateException(_loc.get("no-transaction").getMessage());
        }
        return this._broker.getRollbackCause();
    }

    @Override
    public boolean getRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(_loc.get("no-transaction").getMessage());
        }
        return this._broker.getRollbackOnly();
    }

    @Override
    public void setRollbackOnly() {
        this._broker.setRollbackOnly();
    }

    @Override
    public void setRollbackOnly(Throwable cause) {
        this._broker.setRollbackOnly(cause);
    }

    @Override
    public void setSavepoint(String name) {
        this.assertNotCloseInvoked();
        this._broker.setSavepoint(name);
    }

    @Override
    public void rollbackToSavepoint() {
        this.assertNotCloseInvoked();
        this._broker.rollbackToSavepoint();
    }

    @Override
    public void rollbackToSavepoint(String name) {
        this.assertNotCloseInvoked();
        this._broker.rollbackToSavepoint(name);
    }

    @Override
    public void releaseSavepoint() {
        this.assertNotCloseInvoked();
        this._broker.releaseSavepoint();
    }

    @Override
    public void releaseSavepoint(String name) {
        this.assertNotCloseInvoked();
        this._broker.releaseSavepoint(name);
    }

    public void flush() {
        this.assertNotCloseInvoked();
        this._broker.assertOpen();
        this._broker.assertActiveTransaction();
        this._broker.flush();
    }

    @Override
    public void preFlush() {
        this.assertNotCloseInvoked();
        this._broker.preFlush();
    }

    @Override
    public void validateChanges() {
        this.assertNotCloseInvoked();
        this._broker.validateChanges();
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && this._broker.isActive();
    }

    @Override
    public boolean isStoreActive() {
        return this._broker.isStoreActive();
    }

    @Override
    public void beginStore() {
        this._broker.beginStore();
    }

    public boolean contains(Object entity) {
        this.assertNotCloseInvoked();
        if (entity == null) {
            return false;
        }
        OpenJPAStateManager sm = this._broker.getStateManager(entity);
        if (sm == null && !ImplHelper.isManagedType(this.getConfiguration(), entity.getClass())) {
            throw new ArgumentException(_loc.get("not-entity", entity.getClass()), null, null, true);
        }
        return sm != null && !sm.isDeleted();
    }

    @Override
    public boolean containsAll(Object ... entities) {
        for (Object entity : entities) {
            if (this.contains(entity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection entities) {
        for (Object entity : entities) {
            if (this.contains(entity)) continue;
            return false;
        }
        return true;
    }

    public void persist(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.persist(entity, this);
    }

    @Override
    public void persistAll(Object ... entities) {
        this.persistAll(Arrays.asList(entities));
    }

    @Override
    public void persistAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.persistAll(entities, this);
    }

    public void remove(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.delete(entity, this);
    }

    @Override
    public void removeAll(Object ... entities) {
        this.removeAll(Arrays.asList(entities));
    }

    @Override
    public void removeAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.deleteAll(entities, this);
    }

    @Override
    public void release(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.release(entity, this);
    }

    @Override
    public void releaseAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.releaseAll(entities, this);
    }

    @Override
    public void releaseAll(Object ... entities) {
        this.releaseAll(Arrays.asList(entities));
    }

    public void refresh(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.assertWriteOperation();
        this._broker.refresh(entity, this);
    }

    @Override
    public void refreshAll() {
        this.assertNotCloseInvoked();
        this._broker.assertWriteOperation();
        this._broker.refreshAll(this._broker.getTransactionalObjects(), this);
    }

    @Override
    public void refreshAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.assertWriteOperation();
        this._broker.refreshAll(entities, this);
    }

    @Override
    public void refreshAll(Object ... entities) {
        this.refreshAll(Arrays.asList(entities));
    }

    @Override
    public void retrieve(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.retrieve(entity, true, this);
    }

    @Override
    public void retrieveAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.retrieveAll(entities, true, this);
    }

    @Override
    public void retrieveAll(Object ... entities) {
        this.retrieveAll(Arrays.asList(entities));
    }

    @Override
    public void evict(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.evict(entity, this);
    }

    @Override
    public void evictAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.evictAll(entities, (OpCallbacks)this);
    }

    @Override
    public void evictAll(Object ... entities) {
        this.evictAll(Arrays.asList(entities));
    }

    @Override
    public void evictAll() {
        this.assertNotCloseInvoked();
        this._broker.evictAll(this);
    }

    @Override
    public void evictAll(Class cls) {
        this.assertNotCloseInvoked();
        this._broker.evictAll(this._broker.newExtent(cls, true), (OpCallbacks)this);
    }

    @Override
    public void evictAll(Extent extent) {
        this.assertNotCloseInvoked();
        this._broker.evictAll(((ExtentImpl)extent).getDelegate(), (OpCallbacks)this);
    }

    @Override
    public <T> T detach(T entity) {
        this.assertNotCloseInvoked();
        return (T)this._broker.detach(entity, this);
    }

    @Override
    public Object[] detachAll(Object ... entities) {
        this.assertNotCloseInvoked();
        return this._broker.detachAll(Arrays.asList(entities), this);
    }

    @Override
    public Collection detachAll(Collection entities) {
        this.assertNotCloseInvoked();
        return Arrays.asList(this._broker.detachAll(entities, this));
    }

    public <T> T merge(T entity) {
        this.assertNotCloseInvoked();
        return (T)this._broker.attach(entity, true, this);
    }

    @Override
    public Object[] mergeAll(Object ... entities) {
        if (entities.length == 0) {
            return EMPTY_OBJECTS;
        }
        return this.mergeAll(Arrays.asList(entities)).toArray();
    }

    @Override
    public Collection mergeAll(Collection entities) {
        this.assertNotCloseInvoked();
        return Arrays.asList(this._broker.attachAll(entities, true, this));
    }

    @Override
    public void transactional(Object entity, boolean updateVersion) {
        this.assertNotCloseInvoked();
        this._broker.transactional(entity, updateVersion, this);
    }

    @Override
    public void transactionalAll(Collection objs, boolean updateVersion) {
        this.assertNotCloseInvoked();
        this._broker.transactionalAll(objs, updateVersion, this);
    }

    @Override
    public void transactionalAll(Object[] objs, boolean updateVersion) {
        this.assertNotCloseInvoked();
        this._broker.transactionalAll(Arrays.asList(objs), updateVersion, this);
    }

    @Override
    public void nontransactional(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.nontransactional(entity, this);
    }

    @Override
    public void nontransactionalAll(Collection objs) {
        this.assertNotCloseInvoked();
        this._broker.nontransactionalAll(objs, this);
    }

    @Override
    public void nontransactionalAll(Object[] objs) {
        this.assertNotCloseInvoked();
        this._broker.nontransactionalAll(Arrays.asList(objs), this);
    }

    @Override
    public Generator getNamedGenerator(String name) {
        this.assertNotCloseInvoked();
        try {
            SequenceMetaData meta = this._broker.getConfiguration().getMetaDataRepositoryInstance().getSequenceMetaData(name, this._broker.getClassLoader(), true);
            Seq seq = meta.getInstance(this._broker.getClassLoader());
            return new GeneratorImpl(seq, name, this._broker, null);
        }
        catch (RuntimeException re) {
            throw PersistenceExceptions.toPersistenceException(re);
        }
    }

    @Override
    public Generator getIdGenerator(Class forClass) {
        this.assertNotCloseInvoked();
        try {
            ClassMetaData meta = this._broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(forClass, this._broker.getClassLoader(), true);
            Seq seq = this._broker.getIdentitySequence(meta);
            return seq == null ? null : new GeneratorImpl(seq, null, this._broker, meta);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    @Override
    public Generator getFieldGenerator(Class forClass, String fieldName) {
        this.assertNotCloseInvoked();
        try {
            ClassMetaData meta = this._broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(forClass, this._broker.getClassLoader(), true);
            FieldMetaData fmd = meta.getField(fieldName);
            if (fmd == null) {
                throw new ArgumentException(_loc.get("no-named-field", forClass, fieldName), null, null, false);
            }
            Seq seq = this._broker.getValueSequence(fmd);
            return seq == null ? null : new GeneratorImpl(seq, null, this._broker, meta);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    @Override
    public <T> Extent<T> createExtent(Class<T> cls, boolean subclasses) {
        this.assertNotCloseInvoked();
        return new ExtentImpl(this, this._broker.newExtent(cls, subclasses));
    }

    @Override
    public OpenJPAQuery createQuery(String query) {
        return this.createQuery("javax.persistence.JPQL", query);
    }

    @Override
    public OpenJPAQuery createQuery(String language, String query) {
        this.assertNotCloseInvoked();
        return new QueryImpl(this, this.ret, this._broker.newQuery(language, query));
    }

    @Override
    public OpenJPAQuery createQuery(Query query) {
        if (query == null) {
            return this.createQuery((String)null);
        }
        this.assertNotCloseInvoked();
        org.apache.openjpa.kernel.Query q = ((QueryImpl)query).getDelegate();
        return new QueryImpl(this, this.ret, this._broker.newQuery(q.getLanguage(), q));
    }

    @Override
    public OpenJPAQuery createNamedQuery(String name) {
        this.assertNotCloseInvoked();
        this._broker.assertOpen();
        try {
            QueryMetaData meta = this._broker.getConfiguration().getMetaDataRepositoryInstance().getQueryMetaData(null, name, this._broker.getClassLoader(), true);
            org.apache.openjpa.kernel.Query del = this._broker.newQuery(meta.getLanguage(), null);
            meta.setInto(del);
            del.compile();
            QueryImpl q = new QueryImpl(this, this.ret, del);
            String[] hints = meta.getHintKeys();
            Object[] values = meta.getHintValues();
            for (int i = 0; i < hints.length; ++i) {
                q.setHint(hints[i], values[i]);
            }
            return q;
        }
        catch (RuntimeException re) {
            throw PersistenceExceptions.toPersistenceException(re);
        }
    }

    @Override
    public OpenJPAQuery createNativeQuery(String query) {
        EntityManagerImpl.validateSQL(query);
        return this.createQuery("openjpa.SQL", query);
    }

    @Override
    public OpenJPAQuery createNativeQuery(String query, Class cls) {
        return this.createNativeQuery(query).setResultClass(cls);
    }

    @Override
    public OpenJPAQuery createNativeQuery(String query, String mappingName) {
        this.assertNotCloseInvoked();
        EntityManagerImpl.validateSQL(query);
        org.apache.openjpa.kernel.Query kernelQuery = this._broker.newQuery("openjpa.SQL", query);
        kernelQuery.setResultMapping(null, mappingName);
        return new QueryImpl(this, this.ret, kernelQuery);
    }

    private static void validateSQL(String query) {
        if (StringUtils.trimToNull(query) == null) {
            throw new ArgumentException(_loc.get("no-sql"), null, null, false);
        }
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.assertNotCloseInvoked();
        this._broker.assertOpen();
        this._broker.getFetchConfiguration().setFlushBeforeQueries(EntityManagerImpl.toFlushBeforeQueries(flushMode));
    }

    public FlushModeType getFlushMode() {
        this.assertNotCloseInvoked();
        this._broker.assertOpen();
        return EntityManagerImpl.fromFlushBeforeQueries(this._broker.getFetchConfiguration().getFlushBeforeQueries());
    }

    static FlushModeType fromFlushBeforeQueries(int flush) {
        switch (flush) {
            case 0: {
                return FlushModeType.AUTO;
            }
            case 1: {
                return FlushModeType.COMMIT;
            }
        }
        return null;
    }

    static int toFlushBeforeQueries(FlushModeType flushMode) {
        if (flushMode == null) {
            return 2;
        }
        if (flushMode == FlushModeType.AUTO) {
            return 0;
        }
        if (flushMode == FlushModeType.COMMIT) {
            return 1;
        }
        throw new ArgumentException(flushMode.toString(), null, null, false);
    }

    public void clear() {
        this.assertNotCloseInvoked();
        this._broker.detachAll(this, false);
    }

    public Object getDelegate() {
        this._broker.assertOpen();
        this.assertNotCloseInvoked();
        return this;
    }

    @Override
    public LockModeType getLockMode(Object entity) {
        this.assertNotCloseInvoked();
        return EntityManagerImpl.fromLockLevel(this._broker.getLockLevel(entity));
    }

    public void lock(Object entity, LockModeType mode) {
        this.assertNotCloseInvoked();
        this._broker.lock(entity, EntityManagerImpl.toLockLevel(mode), -1, this);
    }

    @Override
    public void lock(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.lock(entity, this);
    }

    @Override
    public void lock(Object entity, LockModeType mode, int timeout) {
        this.assertNotCloseInvoked();
        this._broker.lock(entity, EntityManagerImpl.toLockLevel(mode), timeout, this);
    }

    @Override
    public void lockAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.lockAll(entities, this);
    }

    @Override
    public void lockAll(Collection entities, LockModeType mode, int timeout) {
        this.assertNotCloseInvoked();
        this._broker.lockAll(entities, EntityManagerImpl.toLockLevel(mode), timeout, this);
    }

    @Override
    public void lockAll(Object ... entities) {
        this.lockAll(Arrays.asList(entities));
    }

    @Override
    public void lockAll(Object[] entities, LockModeType mode, int timeout) {
        this.lockAll(Arrays.asList(entities), mode, timeout);
    }

    static LockModeType fromLockLevel(int level) {
        if (level < 10) {
            return null;
        }
        if (level < 20) {
            return LockModeType.READ;
        }
        return LockModeType.WRITE;
    }

    static int toLockLevel(LockModeType mode) {
        if (mode == null) {
            return 0;
        }
        if (mode == LockModeType.READ) {
            return 10;
        }
        if (mode == LockModeType.WRITE) {
            return 20;
        }
        throw new ArgumentException(mode.toString(), null, null, true);
    }

    @Override
    public boolean cancelAll() {
        return this._broker.cancelAll();
    }

    @Override
    public Object getConnection() {
        return this._broker.getConnection();
    }

    @Override
    public Collection getManagedObjects() {
        return this._broker.getManagedObjects();
    }

    @Override
    public Collection getTransactionalObjects() {
        return this._broker.getTransactionalObjects();
    }

    @Override
    public Collection getPendingTransactionalObjects() {
        return this._broker.getPendingTransactionalObjects();
    }

    @Override
    public Collection getDirtyObjects() {
        return this._broker.getDirtyObjects();
    }

    @Override
    public boolean getOrderDirtyObjects() {
        return this._broker.getOrderDirtyObjects();
    }

    @Override
    public void setOrderDirtyObjects(boolean order) {
        this.assertNotCloseInvoked();
        this._broker.setOrderDirtyObjects(order);
    }

    @Override
    public void dirtyClass(Class cls) {
        this.assertNotCloseInvoked();
        this._broker.dirtyType(cls);
    }

    @Override
    public Collection<Class> getPersistedClasses() {
        return this._broker.getPersistedTypes();
    }

    @Override
    public Collection<Class> getUpdatedClasses() {
        return this._broker.getUpdatedTypes();
    }

    @Override
    public Collection<Class> getRemovedClasses() {
        return this._broker.getDeletedTypes();
    }

    @Override
    public <T> T createInstance(Class<T> cls) {
        this.assertNotCloseInvoked();
        return (T)this._broker.newInstance(cls);
    }

    @Override
    public void close() {
        this.assertNotCloseInvoked();
        this._broker.close();
    }

    public boolean isOpen() {
        return !this._broker.isCloseInvoked();
    }

    @Override
    public void dirty(Object o, String field) {
        this.assertNotCloseInvoked();
        OpenJPAStateManager sm = this._broker.getStateManager(o);
        try {
            if (sm != null) {
                sm.dirty(field);
            }
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    @Override
    public Object getObjectId(Object o) {
        this.assertNotCloseInvoked();
        return JPAFacadeHelper.fromOpenJPAObjectId(this._broker.getObjectId(o));
    }

    @Override
    public boolean isDirty(Object o) {
        this.assertNotCloseInvoked();
        return this._broker.isDirty(o);
    }

    @Override
    public boolean isTransactional(Object o) {
        this.assertNotCloseInvoked();
        return this._broker.isTransactional(o);
    }

    @Override
    public boolean isPersistent(Object o) {
        this.assertNotCloseInvoked();
        return this._broker.isPersistent(o);
    }

    @Override
    public boolean isNewlyPersistent(Object o) {
        this.assertNotCloseInvoked();
        return this._broker.isNew(o);
    }

    @Override
    public boolean isRemoved(Object o) {
        this.assertNotCloseInvoked();
        return this._broker.isDeleted(o);
    }

    @Override
    public boolean isDetached(Object entity) {
        this.assertNotCloseInvoked();
        return this._broker.isDetached(entity);
    }

    @Override
    public Object getVersion(Object o) {
        this.assertNotCloseInvoked();
        return this._broker.getVersion(o);
    }

    void assertNotCloseInvoked() {
        if (!this._broker.isClosed() && this._broker.isCloseInvoked()) {
            throw new InvalidStateException(_loc.get("close-invoked"), null, null, true);
        }
    }

    @Override
    public Object processArgument(Object arg) {
        return arg;
    }

    @Override
    public Object processReturn(Object oid, OpenJPAStateManager sm) {
        return sm == null || sm.isDeleted() ? null : sm.getManagedInstance();
    }

    @Override
    public int processArgument(int op, Object obj, OpenJPAStateManager sm) {
        switch (op) {
            case 1: {
                if (sm == null && !this._broker.isDetached(obj)) {
                    return 2;
                }
                if (sm != null && !sm.isDetached() && !sm.isPersistent()) {
                    return 2;
                }
                if (sm == null || !sm.isDeleted()) break;
                return 0;
            }
            case 6: {
                if (sm != null && sm.isDeleted()) {
                    throw new UserException(_loc.get("removed", Exceptions.toString(obj))).setFailedObject(obj);
                }
                if (sm == null || sm.isDetached()) break;
                return 2;
            }
            case 2: {
                if (sm != null) break;
                throw new UserException(_loc.get("not-managed", Exceptions.toString(obj))).setFailedObject(obj);
            }
        }
        return 6;
    }

    public int hashCode() {
        return this._broker.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EntityManagerImpl)) {
            return false;
        }
        return this._broker.equals(((EntityManagerImpl)other)._broker);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.ret = PersistenceExceptions.getRollbackTranslator(this);
            Object factoryKey = in.readObject();
            AbstractBrokerFactory factory = AbstractBrokerFactory.getPooledFactoryForKey(factoryKey);
            byte[] brokerBytes = (byte[])in.readObject();
            BrokerBytesInputStream innerIn = new BrokerBytesInputStream(brokerBytes, factory.getConfiguration());
            Broker broker = (Broker)innerIn.readObject();
            EntityManagerFactoryImpl emf = (EntityManagerFactoryImpl)JPAFacadeHelper.toEntityManagerFactory(broker.getBrokerFactory());
            broker.putUserObject("org.apache.openjpa.persistence.EntityManager", this);
            this.initialize(emf, broker);
        }
        catch (RuntimeException re) {
            try {
                re = this.ret.translate(re);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw re;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            Object factoryKey = ((AbstractBrokerFactory)this._broker.getBrokerFactory()).getPoolKey();
            out.writeObject(factoryKey);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream innerOut = new ObjectOutputStream(baos);
            innerOut.writeObject(this._broker.getDelegate());
            innerOut.flush();
            out.writeObject(baos.toByteArray());
        }
        catch (RuntimeException re) {
            try {
                re = this.ret.translate(re);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw re;
        }
    }

    private static class BrokerBytesInputStream
    extends ObjectInputStream {
        private OpenJPAConfiguration conf;

        BrokerBytesInputStream(byte[] bytes, OpenJPAConfiguration conf) throws IOException {
            super(new ByteArrayInputStream(bytes));
            if (conf == null) {
                throw new IllegalArgumentException("Illegal null argument to ObjectInputStreamWithLoader");
            }
            this.conf = conf;
        }

        private Class primitiveType(char type) {
            switch (type) {
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
            }
            return null;
        }

        protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            String cname = classDesc.getName();
            if (cname.startsWith("[")) {
                Class component;
                int dcount = 1;
                while (cname.charAt(dcount) == '[') {
                    ++dcount;
                }
                if (cname.charAt(dcount) == 'L') {
                    component = this.lookupClass(cname.substring(dcount + 1, cname.length() - 1));
                } else {
                    if (cname.length() != dcount + 1) {
                        throw new ClassNotFoundException(cname);
                    }
                    component = this.primitiveType(cname.charAt(dcount));
                }
                int[] dim = new int[dcount];
                for (int i = 0; i < dcount; ++i) {
                    dim[i] = 0;
                }
                return Array.newInstance(component, dim).getClass();
            }
            return this.lookupClass(cname);
        }

        private Class lookupClass(String className) throws ClassNotFoundException {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                if (PCEnhancer.isPCSubclassName(className)) {
                    String superName = PCEnhancer.toManagedTypeName(className);
                    ClassMetaData[] metas = this.conf.getMetaDataRepositoryInstance().getMetaDatas();
                    for (int i = 0; i < metas.length; ++i) {
                        if (!superName.equals(metas[i].getDescribedType().getName())) continue;
                        return PCRegistry.getPCType(metas[i].getDescribedType());
                    }
                    return Class.forName(className);
                }
                throw e;
            }
        }
    }
}

