/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.util.lib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.math.BigDecimal;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.objectweb.jorm.util.lib.TestInfo;

public class AntJormTestReport
extends MatchingTask {
    private File srcdir;
    private File destdir;

    public void setsrcdir(File d) {
        this.srcdir = d;
    }

    public void setdestdir(File d) {
        this.destdir = d;
    }

    public void execute() throws BuildException {
        try {
            String[] in_files = super.getDirectoryScanner(this.srcdir).getIncludedFiles();
            File destfile = new File(this.destdir.getPath() + File.separator + "index.html");
            PrintWriter pw = new PrintWriter(new FileOutputStream(destfile));
            TestInfo[] infos = new TestInfo[in_files.length + 1];
            infos[in_files.length] = new TestInfo();
            infos[in_files.length].time = new BigDecimal(0.0);
            infos[in_files.length].time.setScale(3, 3);
            for (int i = 0; i < in_files.length; ++i) {
                infos[i] = this.extractInfos(in_files[i]);
                infos[in_files.length].nbTests += infos[i].nbTests;
                infos[in_files.length].nbErrors += infos[i].nbErrors;
                infos[in_files.length].nbFailures += infos[i].nbFailures;
                infos[in_files.length].time = infos[in_files.length].time.add(infos[i].time);
            }
            BigDecimal cent = new BigDecimal(100.0);
            BigDecimal rate = new BigDecimal((double)(infos[in_files.length].nbErrors + infos[in_files.length].nbFailures));
            rate.setScale(2);
            rate = rate.divide(new BigDecimal((double)infos[in_files.length].nbTests), 2, 3);
            rate = cent.multiply(rate);
            rate = cent.subtract(rate);
            this.printHeader(pw);
            pw.println("<tr valign=\"top\" class=\"Pass\">");
            pw.println("<td>" + infos[in_files.length].nbTests + "</td><td>" + infos[in_files.length].nbFailures + "</td><td>" + infos[in_files.length].nbErrors + "</td><td>" + rate + "%</td><td>" + infos[in_files.length].time.toString() + "</td>");
            pw.println("</tr>");
            this.printMiddle(pw);
            for (int i = 0; i < in_files.length; ++i) {
                pw.println("<tr valign=\"top\" class=\"Pass\">");
                pw.println("<td><a href=\"" + this.srcdir + File.separator + infos[i].indexhtml + "\">" + infos[i].testname + "</a></td><td>" + infos[i].nbTests + "</td><td>" + infos[i].nbErrors + "</td><td>" + infos[i].nbFailures + "</td><td>" + infos[i].time.toString() + "</td>");
                pw.println("</tr>");
            }
            this.printTrailer(pw);
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException e) {
            this.log(e.getMessage(), 0);
        }
    }

    private void printHeader(PrintWriter pw) {
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=US-ASCII\">");
        pw.println("<title>Unit Test Results: Summary</title>");
        pw.println("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"stylesheet.css\">");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>JORM Unit Test Results</h1>");
        pw.println("<table width=\"100%\">");
        pw.println("<tr>");
        pw.println("<td align=\"left\"></td><td align=\"right\">Designed for use with <a href=\"http://www.junit.org/\">JUnit</a> and <a href=\"http://jakarta.apache.org/\">Ant</a>.</td>");
        pw.println("</tr>");
        pw.println("</table>");
        pw.println("<hr size=\"1\">");
        pw.println("<h2>Summary</h2>");
        pw.println("<table width=\"95%\" cellspacing=\"2\" cellpadding=\"5\" border=\"0\" class=\"details\">");
        pw.println("<tr valign=\"top\">");
        pw.println("<th>Tests</th><th>Failures</th><th>Errors</th><th>Success rate</th><th>Time</th>");
        pw.println("</tr>");
    }

    private void printMiddle(PrintWriter pw) {
        pw.println("</table>");
        pw.println("<table width=\"95%\" border=\"0\">");
        pw.println("<tr>");
        pw.println("<td style=\"text-align: justify;\">");
        pw.println("Note: <em>failures</em> are anticipated and checked for with assertions while <em>errors</em> are unanticipated.");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("</table>");
        pw.println("<h2>Tested area</h2>");
        pw.println("<table width=\"95%\" cellspacing=\"2\" cellpadding=\"5\" border=\"0\" class=\"details\">");
        pw.println("<tr valign=\"top\">");
        pw.println("<th width=\"80%\">Name</th><th>Tests</th><th>Errors</th><th>Failures</th><th nowrap=\"nowrap\">Time(s)</th>");
        pw.println("</tr>");
    }

    private void printTrailer(PrintWriter pw) {
        pw.println("</table>");
        pw.println("</body>");
        pw.println("</html>");
    }

    private TestInfo extractInfos(String fn) {
        TestInfo res = new TestInfo();
        int s1 = fn.lastIndexOf(File.separatorChar);
        int s2 = fn.lastIndexOf(File.separatorChar, s1 - 1);
        int s3 = fn.lastIndexOf(File.separatorChar, s2 - 1);
        s3 = s3 == -1 ? 0 : ++s3;
        res.testname = s1 == -1 ? "Common test" : (s2 == -1 ? fn.substring(0, s1) : fn.substring(s3, s2) + "." + fn.substring(s2 + 1, s1));
        res.indexhtml = fn.substring(0, s1 + 1) + "index.html";
        try {
            PushbackReader fr = new PushbackReader(new FileReader(this.srcdir + File.separator + fn), 10);
            this.locateNextString(fr, "<table");
            this.locateNextString(fr, "<table");
            this.locateNextString(fr, "<tr");
            this.locateNextString(fr, "<tr");
            this.locateNextString(fr, "<td>");
            res.nbTests = Integer.parseInt(this.getString2ClosingTag(fr));
            this.locateNextString(fr, "<td>");
            res.nbFailures = Integer.parseInt(this.getString2ClosingTag(fr));
            this.locateNextString(fr, "<td>");
            res.nbErrors = Integer.parseInt(this.getString2ClosingTag(fr));
            this.locateNextString(fr, "<td>");
            this.locateNextString(fr, "<td>");
            res.time = new BigDecimal(this.getString2ClosingTag(fr));
            res.time.setScale(3);
        }
        catch (FileNotFoundException e) {
            this.log(e.getMessage(), 0);
        }
        catch (IOException e) {
            this.log(e.getMessage(), 0);
        }
        return res;
    }

    private void locateNextString(PushbackReader fr, String s) throws IOException {
        int next = fr.read();
        while (next != -1) {
            if (next == s.charAt(0)) {
                int pos;
                char[] buf = new char[s.length() - 1];
                int next2 = fr.read();
                for (pos = 1; next2 != -1 && pos < s.length(); ++pos) {
                    buf[pos - 1] = (char)next2;
                    if (next2 == s.charAt(pos)) {
                        next2 = fr.read();
                        continue;
                    }
                    fr.unread(buf, 0, pos);
                    break;
                }
                if (pos == s.length()) {
                    buf[0] = (char)next2;
                    fr.unread(buf, 0, 1);
                    return;
                }
            }
            next = fr.read();
        }
        throw new IOException("Wrong format in test result for JORM - string not found: " + s);
    }

    private String getString2ClosingTag(PushbackReader fr) throws IOException {
        int next = fr.read();
        StringBuffer sb = new StringBuffer();
        while (next != -1 && next != 60) {
            sb.append((char)next);
            next = fr.read();
        }
        return sb.toString();
    }
}

