/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.helper.listener;

import javax.ejb.TransactionManagementType;
import javax.naming.Context;
import javax.naming.NamingException;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.container.EasyBeansEJBContext;
import org.ow2.easybeans.container.mdb.EasyBeansMessageDrivenContext;
import org.ow2.easybeans.container.mdb.MDBFactory;
import org.ow2.easybeans.container.session.EasyBeansSessionContext;
import org.ow2.easybeans.container.session.singleton.SingletonSessionFactory;
import org.ow2.easybeans.container.session.stateful.StatefulSessionFactory;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.easybeans.deployment.helper.listener.AbstractExtensionListener;
import org.ow2.easybeans.event.naming.CompNamingEvent;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JavaCompExtensionListener
extends AbstractExtensionListener {
    private static Log logger = LogFactory.getLog(JavaCompExtensionListener.class);

    public void handle(IEvent event) {
        CompNamingEvent cne = (CompNamingEvent)event;
        Factory<?, ?> easyBeansFactory = cne.getFactory();
        Context compCtx = cne.getContext();
        if (easyBeansFactory.getBeanInfo().getTransactionManagementType() == TransactionManagementType.CONTAINER) {
            logger.debug((Object)"Bean is container managed so remove availability of java:comp/UserTransaction object", new Object[0]);
            try {
                compCtx.unbind("UserTransaction");
            }
            catch (NamingException e) {
                this.throwException(cne, new IllegalStateException("Cannot remove java:comp/UserTransaction object", e));
            }
        }
        EasyBeansEJBContext context = null;
        if (easyBeansFactory instanceof StatelessSessionFactory) {
            context = new EasyBeansSessionContext<StatelessSessionFactory>((StatelessSessionFactory)easyBeansFactory);
        } else if (easyBeansFactory instanceof StatefulSessionFactory) {
            context = new EasyBeansSessionContext<StatefulSessionFactory>((StatefulSessionFactory)easyBeansFactory);
        } else if (easyBeansFactory instanceof SingletonSessionFactory) {
            context = new EasyBeansSessionContext<SingletonSessionFactory>((SingletonSessionFactory)easyBeansFactory);
        } else if (easyBeansFactory instanceof MDBFactory) {
            context = new EasyBeansMessageDrivenContext((MDBFactory)easyBeansFactory);
        } else {
            this.throwException(cne, new IllegalStateException("Unable to detect factory type '" + easyBeansFactory + "'"));
        }
        try {
            compCtx.bind("EJBContext", context);
        }
        catch (NamingException e) {
            this.throwException(cne, new IllegalStateException("Cannot bind EJBContext", e));
        }
        try {
            compCtx.bind("TimerService", (Object)context.getTimerService());
        }
        catch (NamingException e) {
            this.throwException(cne, new IllegalStateException("Cannot bind TimerService", e));
        }
    }
}

