/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence;

import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.ow2.easybeans.persistence.TxEntityManagerHandler;

public class TxEntityManagerLifeCycle
implements Synchronization {
    private EntityManager entityManager = null;
    private TxEntityManagerHandler txEntityManagerHandler = null;
    private Transaction tx = null;

    public TxEntityManagerLifeCycle(EntityManager entityManager, Transaction tx, TxEntityManagerHandler txEntityManagerHandler) {
        this.entityManager = entityManager;
        this.tx = tx;
        this.txEntityManagerHandler = txEntityManagerHandler;
        int statusTx = 0;
        if (tx != null) {
            try {
                statusTx = tx.getStatus();
            }
            catch (SystemException e) {
                throw new IllegalStateException("Cannot get the status on the current transaction", e);
            }
        }
        if (tx != null && 0 == statusTx) {
            entityManager.joinTransaction();
        }
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        this.txEntityManagerHandler.release(this.tx);
        this.txEntityManagerHandler = null;
        this.entityManager.close();
    }
}

