/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.reference;

import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.reference.ServerRef;

@Immutable
public final class CMIReference
implements Serializable,
LoadBalanceable {
    private static final long serialVersionUID = -2546573353023565090L;
    private final ServerRef serverRef;
    private final String objectName;

    public CMIReference(ServerRef serverRef, String objectName) {
        this.serverRef = serverRef;
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String toString() {
        return this.serverRef.getProviderURL() + "/" + this.objectName;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CMIReference)) {
            return false;
        }
        CMIReference cmiReference = (CMIReference)obj;
        return this.objectName.equals(cmiReference.objectName) && this.serverRef.equals(cmiReference.serverRef);
    }

    public int hashCode() {
        return this.serverRef.hashCode() + this.objectName.hashCode();
    }

    public ServerRef getServerRef() {
        return this.serverRef;
    }
}

