/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.interceptors.impl.audit;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanNotificationBroadcaster;
import org.ow2.carol.jndi.intercept.ContextInterceptor;
import org.ow2.carol.jndi.intercept.InterceptionContext;
import org.ow2.jonas.jndi.interceptors.impl.AbsContextInterceptor;
import org.ow2.util.auditreport.impl.JNDIAuditReport;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class AuditSystemContextInterceptor
extends AbsContextInterceptor
implements ContextInterceptor {
    private static Log logger = LogFactory.getLog(AuditSystemContextInterceptor.class);
    private ModelMBeanNotificationBroadcaster broadcaster = null;
    private long seqNumber = 0L;

    public AuditSystemContextInterceptor() {
        this.setMethodsRegexp(".*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(InterceptionContext context) throws Exception {
        Object obj;
        block17: {
            long requestStart = System.nanoTime();
            obj = null;
            try {
                obj = context.proceed();
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                long requestStop = System.nanoTime();
                Method method = context.getMethod();
                if (this.filterOnMethodName(method)) {
                    Object[] parameters = context.getParameters();
                    String param = "";
                    String[] params = null;
                    if (parameters != null && parameters.length > 0) {
                        param = parameters[0].toString();
                        int i = 0;
                        params = new String[parameters.length];
                        for (Object parameter : parameters) {
                            params[i++] = parameter.toString();
                        }
                    }
                    long totalGarbageCollections = 0L;
                    long garbageCollectionTime = 0L;
                    for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                        long time;
                        long count = gc.getCollectionCount();
                        if (count >= 0L) {
                            totalGarbageCollections += count;
                        }
                        if ((time = gc.getCollectionTime()) < 0L) continue;
                        garbageCollectionTime += time;
                    }
                    JNDIAuditReport report = new JNDIAuditReport(System.currentTimeMillis(), context.getMethod().getName(), param, params, Thread.currentThread(), requestStart, requestStop);
                    report.setMethodStackTrace((Object[])AuditSystemContextInterceptor.cleanupStackTrace(Thread.currentThread().getStackTrace()));
                    report.setSweepMarkTime(totalGarbageCollections);
                    report.setScavengeTime(garbageCollectionTime);
                    if (this.broadcaster == null) {
                        logger.error((Object)"No broadcaster available for JNDI Audit interceptor", new Object[0]);
                    } else if (report != null) {
                        this.broadcaster.sendNotification(new Notification("JNDI", (Object)this.broadcaster, this.getNextSeqNumber(), report.toString()));
                    }
                }
                throw throwable;
            }
            long requestStop = System.nanoTime();
            Method method = context.getMethod();
            if (!this.filterOnMethodName(method)) break block17;
            Object[] parameters = context.getParameters();
            String param = "";
            String[] params = null;
            if (parameters != null && parameters.length > 0) {
                param = parameters[0].toString();
                int i = 0;
                params = new String[parameters.length];
                for (Object parameter : parameters) {
                    params[i++] = parameter.toString();
                }
            }
            long totalGarbageCollections = 0L;
            long garbageCollectionTime = 0L;
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                long time;
                long count = gc.getCollectionCount();
                if (count >= 0L) {
                    totalGarbageCollections += count;
                }
                if ((time = gc.getCollectionTime()) < 0L) continue;
                garbageCollectionTime += time;
            }
            JNDIAuditReport report = new JNDIAuditReport(System.currentTimeMillis(), context.getMethod().getName(), param, params, Thread.currentThread(), requestStart, requestStop);
            report.setMethodStackTrace((Object[])AuditSystemContextInterceptor.cleanupStackTrace(Thread.currentThread().getStackTrace()));
            report.setSweepMarkTime(totalGarbageCollections);
            report.setScavengeTime(garbageCollectionTime);
            if (this.broadcaster == null) {
                logger.error((Object)"No broadcaster available for JNDI Audit interceptor", new Object[0]);
            } else if (report != null) {
                this.broadcaster.sendNotification(new Notification("JNDI", (Object)this.broadcaster, this.getNextSeqNumber(), report.toString()));
            }
        }
        return obj;
    }

    protected static StackTraceElement[] cleanupStackTrace(StackTraceElement[] stackTrace) {
        ArrayList<StackTraceElement> cleanList = new ArrayList<StackTraceElement>();
        boolean initialContextFound = false;
        for (StackTraceElement stackElement : stackTrace) {
            String className = stackElement.getClassName();
            if (className == null) continue;
            if (className.startsWith("javax.naming.InitialContext")) {
                initialContextFound = true;
            }
            if (!initialContextFound) continue;
            cleanList.add(stackElement);
        }
        return cleanList.toArray(new StackTraceElement[cleanList.size()]);
    }

    public ObjectName getObjectName(String domain) {
        try {
            return new ObjectName(domain + ":type=Auditors,auditorType=jndi" + ",name=JOnAS");
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Error while creating JNDI Audit ObjectName", e);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Error while creating JNDI Audit ObjectName", e);
        }
    }

    public void setBroadcaster(ModelMBeanNotificationBroadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }

    protected long getNextSeqNumber() {
        return this.seqNumber++;
    }
}

