/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.IOException;
import java.io.Serializable;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.spi.TypeConverterRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Converter
public final class GenericFileConverter {
    private GenericFileConverter() {
    }

    @FallbackConverter
    public static Object convertTo(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        if (GenericFile.class.isAssignableFrom(value.getClass())) {
            GenericFile file = (GenericFile)value;
            Class<?> from = file.getBody().getClass();
            if (from.isAssignableFrom(type)) {
                return file.getBody();
            }
            TypeConverter tc = registry.lookup(type, from);
            if (tc != null) {
                Object body = file.getBody();
                return tc.convertTo(type, exchange, body);
            }
        }
        return null;
    }

    @Converter
    public static String convertToString(GenericFile<?> file, Exchange exchange) throws IOException {
        if (exchange != null) {
            file.getBinding().loadContent(exchange, file);
            return exchange.getContext().getTypeConverter().convertTo(String.class, exchange, file.getBody());
        }
        return null;
    }

    @Converter
    public static Serializable convertToSerializable(GenericFile<?> file, Exchange exchange) throws IOException {
        if (exchange != null) {
            file.getBinding().loadContent(exchange, file);
            return exchange.getContext().getTypeConverter().convertTo(Serializable.class, exchange, file.getBody());
        }
        return null;
    }
}

