/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Injector;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IOHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFactoryFinder
implements FactoryFinder {
    protected final ConcurrentHashMap<String, Class<?>> classMap = new ConcurrentHashMap();
    private final ClassResolver classResolver;
    private final String path;

    public DefaultFactoryFinder(ClassResolver classResolver, String resourcePath) {
        this.classResolver = classResolver;
        this.path = resourcePath;
    }

    @Override
    public String getResourcePath() {
        return this.path;
    }

    @Override
    public Object newInstance(String key) throws NoFactoryAvailableException {
        try {
            return this.newInstance(key, null);
        }
        catch (Exception e) {
            throw new NoFactoryAvailableException(key, e);
        }
    }

    @Override
    public <T> List<T> newInstances(String key, Injector injector, Class<T> type) throws ClassNotFoundException, IOException {
        List list = CastUtils.cast(this.findClasses(key));
        ArrayList<T> answer = new ArrayList<T>(list.size());
        answer.add(this.newInstance(key, injector, type));
        return answer;
    }

    @Override
    public Class<?> findClass(String key) throws ClassNotFoundException, IOException {
        return this.findClass(key, null);
    }

    @Override
    public Class<?> findClass(String key, String propertyPrefix) throws ClassNotFoundException, IOException {
        String prefix = propertyPrefix != null ? propertyPrefix : "";
        Class<?> clazz = this.classMap.get(prefix + key);
        if (clazz == null && (clazz = this.newInstance(this.doFindFactoryProperties(key), prefix)) != null) {
            this.classMap.put(prefix + key, clazz);
        }
        return clazz;
    }

    private Object newInstance(String key, String propertyPrefix) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        Class<?> clazz = this.findClass(key, propertyPrefix);
        return clazz.newInstance();
    }

    private <T> T newInstance(String key, Injector injector, Class<T> expectedType) throws IOException, ClassNotFoundException {
        return this.newInstance(key, injector, null, expectedType);
    }

    private <T> T newInstance(String key, Injector injector, String propertyPrefix, Class<T> expectedType) throws IOException, ClassNotFoundException {
        Class<?> type = this.findClass(key, propertyPrefix);
        Object value = injector.newInstance(type);
        if (expectedType.isInstance(value)) {
            return expectedType.cast(value);
        }
        throw new ClassCastException("Not instanceof " + expectedType.getName() + " value: " + value);
    }

    private List<Class<?>> findClasses(String key) throws ClassNotFoundException, IOException {
        return this.findClasses(key, null);
    }

    private List<Class<?>> findClasses(String key, String propertyPrefix) throws ClassNotFoundException, IOException {
        Class<?> type = this.findClass(key, propertyPrefix);
        return CastUtils.cast(Collections.singletonList(type));
    }

    private Class<?> newInstance(Properties properties, String propertyPrefix) throws ClassNotFoundException, IOException {
        String className = properties.getProperty(propertyPrefix + "class");
        if (className == null) {
            throw new IOException("Expected property is missing: " + propertyPrefix + "class");
        }
        Class<?> clazz = this.classResolver.resolveClass(className);
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties doFindFactoryProperties(String key) throws IOException {
        String uri = this.path + key;
        InputStream in = this.classResolver.loadResourceAsStream(uri);
        if (in == null) {
            throw new NoFactoryAvailableException(uri);
        }
        BufferedInputStream reader = null;
        try {
            reader = new BufferedInputStream(in);
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            IOHelper.close(reader, key, null);
            IOHelper.close(in, key, null);
        }
    }
}

