/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import org.apache.openjpa.jdbc.kernel.exps.Distinct;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.PCPath;
import org.apache.openjpa.jdbc.kernel.exps.UnaryOp;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;

class Count
extends UnaryOp {
    private boolean isCountMultiColumns = false;
    private boolean isCountDistinct = false;

    public Count(Val val) {
        super(val);
        if (val instanceof Distinct) {
            this.isCountDistinct = true;
        }
    }

    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        Column[] cols;
        Val val;
        ExpState expState = this.initializeValue(sel, ctx, 4);
        Val val2 = val = this.isCountDistinct ? ((Distinct)this.getValue()).getValue() : this.getValue();
        if (val instanceof PCPath && (cols = ((PCPath)val).getColumns(expState)).length > 1) {
            this.isCountMultiColumns = true;
        }
        return expState;
    }

    protected Class getType(Class c) {
        return Long.TYPE;
    }

    protected String getOperator() {
        return "COUNT";
    }

    public boolean isAggregate() {
        return true;
    }

    public boolean isCountDistinctMultiCols() {
        return this.isCountDistinct && this.isCountMultiColumns;
    }

    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2, int index) {
        String s;
        if (this.isCountDistinctMultiCols()) {
            this.getValue().appendTo(sel, ctx, state, sql2, 0);
            sql2.addCastForParam(this.getOperator(), this.getValue());
        } else {
            super.appendTo(sel, ctx, state, sql2, index);
        }
        if ((ctx.store.getDBDictionary().useWildCardForCount && state.joins.isEmpty() || !this.isCountDistinct && this.isCountMultiColumns) && (s = sql2.getSQL()).startsWith("COUNT(") && s.endsWith(")")) {
            sql2.replaceSqlString("COUNT(".length(), s.length() - 1, "*");
        }
    }
}

