/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.AbstractMarshaller;
import org.jboss.xb.binding.AttributesImpl;
import org.jboss.xb.binding.Content;
import org.jboss.xb.binding.ContentWriter;
import org.jboss.xb.binding.DelegatingObjectModelProvider;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.SAXException;

public class XercesXsMarshaller
extends AbstractMarshaller {
    private static final Logger log = Logger.getLogger(XercesXsMarshaller.class);
    private AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
    private GenericObjectModelProvider provider;
    private Content content = new Content();
    private final Map prefixByUri = new HashMap();
    private Object root;
    private boolean supportNil;
    private QName rootTypeQName;

    public QName getRootTypeQName() {
        return this.rootTypeQName;
    }

    public void setRootTypeQName(QName rootTypeQName) {
        this.rootTypeQName = rootTypeQName;
    }

    public boolean isSupportNil() {
        return this.supportNil;
    }

    public void setSupportNil(boolean supportNil) {
        this.supportNil = supportNil;
    }

    public void declareNamespace(String name, String uri) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        this.prefixByUri.put(uri, name);
    }

    public void addAttribute(String prefix, String localName, String type, String value) {
    }

    public void marshal(Reader xsdReader, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException, ParserConfigurationException {
        XSModel model = XercesXsMarshaller.loadSchema(xsdReader);
        this.marshallInternal(provider, root, model, writer);
    }

    public void marshal(String xsdURL, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException {
        XSModel model = XercesXsMarshaller.loadSchema(xsdURL);
        this.marshallInternal(provider, root, model, writer);
    }

    private void marshallInternal(ObjectModelProvider provider, Object root, XSModel model, Writer writer) throws IOException, SAXException {
        this.provider = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        this.root = root;
        this.content.startDocument();
        if (this.rootTypeQName != null) {
            if (this.rootQNames.isEmpty()) {
                throw new JBossXBRuntimeException("If type name (" + this.rootTypeQName + ") for the root element is specified then the name for the root element is required!");
            }
            QName rootQName = (QName)this.rootQNames.get(0);
            XSTypeDefinition type = model.getTypeDefinition(this.rootTypeQName.getLocalPart(), this.rootTypeQName.getNamespaceURI());
            if (type == null) {
                throw new JBossXBRuntimeException("Global type definition is not found: " + this.rootTypeQName);
            }
            if (XercesXsMarshaller.isArrayWrapper(type)) {
                this.stack.push(root);
                this.marshalComplexType(rootQName.getNamespaceURI(), rootQName.getLocalPart(), (XSComplexTypeDefinition)type, true);
                this.stack.pop();
            } else {
                this.marshalElement(rootQName.getNamespaceURI(), rootQName.getLocalPart(), type, true, 1, 1, true);
            }
        } else if (this.rootQNames.isEmpty()) {
            XSNamedMap components = model.getComponents((short)2);
            if (components.getLength() == 0) {
                throw new JBossXBRuntimeException("The schema doesn't contain global element declarations.");
            }
            for (int i = 0; i < components.getLength(); ++i) {
                XSElementDeclaration element = (XSElementDeclaration)components.item(i);
                this.marshalElement(element.getNamespace(), element.getName(), element.getTypeDefinition(), element.getNillable(), 1, 1, true);
            }
        } else {
            for (int i = 0; i < this.rootQNames.size(); ++i) {
                QName qName = (QName)this.rootQNames.get(i);
                XSElementDeclaration element = model.getElementDeclaration(qName.getLocalPart(), qName.getNamespaceURI());
                if (element == null) {
                    XSNamedMap components = model.getComponents((short)2);
                    String roots = "";
                    for (int j = 0; j < components.getLength(); ++j) {
                        XSObject xsObject = components.item(j);
                        if (j > 0) {
                            roots = roots + ", ";
                        }
                        roots = roots + "{" + xsObject.getNamespace() + "}" + xsObject.getName();
                    }
                    throw new IllegalStateException("Root element not found: " + qName + " among " + roots);
                }
                this.marshalElement(element.getNamespace(), element.getName(), element.getTypeDefinition(), element.getNillable(), 1, 1, true);
            }
        }
        this.content.endDocument();
        this.writeXmlVersion(writer);
        ContentWriter contentWriter = new ContentWriter(writer, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
        this.content.handleContent(contentWriter);
    }

    private boolean marshalElement(String elementNs, String elementLocal, XSTypeDefinition type, boolean nillable, int minOccurs, int maxOccurs, boolean declareNs) {
        Object value;
        if (this.stack.isEmpty()) {
            value = this.provider.getRoot(this.root, null, elementNs, elementLocal);
            if (value == null) {
                return false;
            }
        } else {
            Object peeked = this.stack.peek();
            if (peeked instanceof Collection || peeked.getClass().isArray()) {
                value = peeked;
            } else {
                value = this.provider.getChildren(peeked, null, elementNs, elementLocal);
                if (value == null) {
                    value = this.provider.getElementValue(peeked, null, elementNs, elementLocal);
                }
            }
        }
        if (value != null) {
            this.stack.push(value);
            if (maxOccurs != 1) {
                Iterator i = null;
                if (value instanceof Collection) {
                    i = ((Collection)value).iterator();
                } else if (value.getClass().isArray()) {
                    final Object arr = value;
                    i = new Iterator(){
                        private int curInd = 0;
                        private int length = Array.getLength(arr);

                        public boolean hasNext() {
                            return this.curInd < this.length;
                        }

                        public Object next() {
                            return Array.get(arr, this.curInd++);
                        }

                        public void remove() {
                            throw new UnsupportedOperationException("remove is not implemented.");
                        }
                    };
                } else if (value instanceof Iterator) {
                    i = (Iterator)value;
                }
                if (i == null) {
                    this.marshalElementType(elementNs, elementLocal, type, declareNs);
                } else {
                    while (i.hasNext()) {
                        Object item = i.next();
                        this.stack.push(item);
                        this.marshalElementType(elementNs, elementLocal, type, declareNs);
                        this.stack.pop();
                    }
                }
            } else {
                this.marshalElementType(elementNs, elementLocal, type, declareNs);
            }
            this.stack.pop();
        } else if (this.supportNil && nillable) {
            String prefix = (String)this.prefixByUri.get(elementNs);
            String qName = XercesXsMarshaller.createQName(prefix, elementLocal);
            AttributesImpl attrs = new AttributesImpl(1);
            String nilQName = this.prefixByUri.get("http://www.w3.org/2001/XMLSchema-instance") + ":nil";
            attrs.add("http://www.w3.org/2001/XMLSchema-instance", "nil", nilQName, null, "1");
            this.content.startElement(elementNs, elementLocal, qName, attrs);
            this.content.endElement(elementNs, elementLocal, qName);
        }
        return minOccurs == 0 || value != null;
    }

    private void marshalElementType(String elementNs, String elementLocal, XSTypeDefinition type, boolean declareNs) {
        switch (type.getTypeCategory()) {
            case 16: {
                this.marshalSimpleType(elementNs, elementLocal, (XSSimpleTypeDefinition)type, declareNs);
                break;
            }
            case 15: {
                this.marshalComplexType(elementNs, elementLocal, (XSComplexTypeDefinition)type, declareNs);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type category: " + type.getTypeCategory());
            }
        }
    }

    private void marshalSimpleType(String elementUri, String elementLocal, XSSimpleTypeDefinition type, boolean declareNs) {
        String marshalled;
        String prefix = (String)this.prefixByUri.get(elementUri);
        String qName = XercesXsMarshaller.createQName(prefix, elementLocal);
        AttributesImpl attrs = null;
        Object value = this.stack.peek();
        if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace())) {
            String typeName = type.getName();
            marshalled = SimpleTypeBindings.marshal(typeName, value, null);
            if ("QName".equals(typeName) || "NOTATION".equals(typeName)) {
                QName qNameValue = (QName)value;
                String prefixValue = qNameValue.getPrefix();
                if (prefixValue.equals(prefix)) {
                    prefixValue = prefixValue + 'x';
                }
                attrs = new AttributesImpl(1);
                attrs.add(null, prefixValue, prefixValue.length() == 0 ? "xmlns" : "xmlns:" + prefixValue, null, qNameValue.getNamespaceURI());
            }
        } else {
            marshalled = value.toString();
        }
        if (declareNs && this.prefixByUri.size() > 0) {
            if (attrs == null) {
                attrs = new AttributesImpl(this.prefixByUri.size());
            }
            this.declareNs(attrs);
        }
        this.content.startElement(elementUri, elementLocal, qName, attrs);
        this.content.characters(marshalled.toCharArray(), 0, marshalled.length());
        this.content.endElement(elementUri, elementLocal, qName);
    }

    private void marshalComplexType(String elementNsUri, String elementLocalName, XSComplexTypeDefinition type, boolean declareNs) {
        AttributesImpl attrs;
        XSParticle particle = type.getParticle();
        XSObjectList attributeUses = type.getAttributeUses();
        int attrsTotal = declareNs ? this.prefixByUri.size() + attributeUses.getLength() : attributeUses.getLength();
        AttributesImpl attributesImpl = attrs = attrsTotal > 0 ? new AttributesImpl(attrsTotal) : null;
        if (declareNs && this.prefixByUri.size() > 0) {
            this.declareNs(attrs);
        }
        for (int i = 0; i < attributeUses.getLength(); ++i) {
            XSAttributeUse attrUse = (XSAttributeUse)attributeUses.item(i);
            XSAttributeDeclaration attrDec = attrUse.getAttrDeclaration();
            Object attrValue = this.provider.getAttributeValue(this.stack.peek(), null, attrDec.getNamespace(), attrDec.getName());
            if (attrValue == null) continue;
            attrs.add(attrDec.getNamespace(), attrDec.getName(), attrDec.getName(), attrDec.getTypeDefinition().getName(), attrValue.toString());
        }
        String prefix = (String)this.prefixByUri.get(elementNsUri);
        String qName = XercesXsMarshaller.createQName(prefix, elementLocalName);
        this.content.startElement(elementNsUri, elementLocalName, qName, attrs);
        if (particle != null) {
            this.marshalParticle(particle, false);
        }
        this.content.endElement(elementNsUri, elementLocalName, qName);
    }

    /*
     * WARNING - void declaration
     */
    private boolean marshalParticle(XSParticle particle, boolean declareNs) {
        void var3_4;
        XSTerm term = particle.getTerm();
        switch (term.getType()) {
            case 7: {
                boolean marshalled = this.marshalModelGroup((XSModelGroup)term, declareNs);
                break;
            }
            case 9: {
                boolean marshalled = this.marshalWildcard((XSWildcard)term, declareNs);
                break;
            }
            case 2: {
                XSElementDeclaration element = (XSElementDeclaration)term;
                boolean marshalled = this.marshalElement(element.getNamespace(), element.getName(), element.getTypeDefinition(), element.getNillable(), particle.getMinOccurs(), particle.getMaxOccurs(), declareNs);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected term type: " + term.getType());
            }
        }
        return (boolean)var3_4;
    }

    private boolean marshalWildcard(XSWildcard wildcard, boolean declareNs) {
        AbstractMarshaller.ClassMapping mapping = this.getClassMapping(this.stack.peek().getClass());
        if (mapping == null) {
            throw new IllegalStateException("Failed to marshal wildcard. Class mapping not found for " + this.stack.peek());
        }
        GenericObjectModelProvider parentProvider = this.provider;
        Object parentRoot = this.root;
        AbstractMarshaller.Stack parentStack = this.stack;
        this.root = this.stack.peek();
        this.provider = mapping.provider;
        this.stack = new AbstractMarshaller.StackImpl();
        boolean marshalled = false;
        XSModel model = XercesXsMarshaller.loadSchema(mapping.schemaUrl);
        XSNamedMap components = model.getComponents((short)2);
        for (int i = 0; i < components.getLength(); ++i) {
            XSElementDeclaration element = (XSElementDeclaration)components.item(i);
            marshalled = this.marshalElement(element.getNamespace(), element.getName(), element.getTypeDefinition(), element.getNillable(), 1, 1, declareNs);
        }
        this.root = parentRoot;
        this.provider = parentProvider;
        this.stack = parentStack;
        return marshalled;
    }

    /*
     * WARNING - void declaration
     */
    private boolean marshalModelGroup(XSModelGroup modelGroup, boolean declareNs) {
        void var3_3;
        switch (modelGroup.getCompositor()) {
            case 3: {
                boolean marshalled = this.marshalModelGroupAll(modelGroup.getParticles(), declareNs);
                break;
            }
            case 2: {
                boolean marshalled = this.marshalModelGroupChoice(modelGroup.getParticles(), declareNs);
                break;
            }
            case 1: {
                boolean marshalled = this.marshalModelGroupSequence(modelGroup.getParticles(), declareNs);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected compsitor: " + modelGroup.getCompositor());
            }
        }
        return (boolean)var3_3;
    }

    private boolean marshalModelGroupAll(XSObjectList particles, boolean declareNs) {
        boolean marshalled = false;
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            marshalled |= this.marshalParticle(particle, declareNs);
        }
        return marshalled;
    }

    private boolean marshalModelGroupChoice(XSObjectList particles, boolean declareNs) {
        boolean marshalled = false;
        Content mainContent = this.content;
        for (int i = 0; i < particles.getLength() && !marshalled; ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            this.content = new Content();
            marshalled = this.marshalParticle(particle, declareNs);
        }
        if (marshalled) {
            mainContent.append(this.content);
        }
        this.content = mainContent;
        return marshalled;
    }

    private boolean marshalModelGroupSequence(XSObjectList particles, boolean declareNs) {
        boolean marshalled = true;
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            marshalled &= this.marshalParticle(particle, declareNs);
        }
        return marshalled;
    }

    private void declareNs(AttributesImpl attrs) {
        Iterator i = this.prefixByUri.entrySet().iterator();
        while (i.hasNext()) {
            String localName;
            Map.Entry entry = i.next();
            attrs.add(null, localName, (localName = (String)entry.getValue()) == null ? "xmlns" : "xmlns:" + localName, null, (String)entry.getKey());
        }
    }

    private static String createQName(String prefix, String local) {
        return prefix == null ? local : prefix + ':' + local;
    }

    public static XSModel loadSchema(String xsdURL) {
        XSImplementation impl = XercesXsMarshaller.getXSImplementation();
        XSLoader schemaLoader = impl.createXSLoader(null);
        XSModel model = schemaLoader.loadURI(xsdURL);
        if (model == null) {
            throw new IllegalArgumentException("Invalid URI for schema: " + xsdURL);
        }
        return model;
    }

    public static XSModel loadSchema(final Reader xsdReader) {
        XSImplementation impl = XercesXsMarshaller.getXSImplementation();
        XSLoader schemaLoader = impl.createXSLoader(null);
        XSModel model = schemaLoader.load(new LSInput(){

            public Reader getCharacterStream() {
                return xsdReader;
            }

            public void setCharacterStream(Reader characterStream) {
                throw new UnsupportedOperationException("setCharacterStream is not implemented.");
            }

            public InputStream getByteStream() {
                return null;
            }

            public void setByteStream(InputStream byteStream) {
                throw new UnsupportedOperationException("setByteStream is not implemented.");
            }

            public String getStringData() {
                return null;
            }

            public void setStringData(String stringData) {
                throw new UnsupportedOperationException("setStringData is not implemented.");
            }

            public String getSystemId() {
                return null;
            }

            public void setSystemId(String systemId) {
                throw new UnsupportedOperationException("setSystemId is not implemented.");
            }

            public String getPublicId() {
                return null;
            }

            public void setPublicId(String publicId) {
                throw new UnsupportedOperationException("setPublicId is not implemented.");
            }

            public String getBaseURI() {
                return null;
            }

            public void setBaseURI(String baseURI) {
                throw new UnsupportedOperationException("setBaseURI is not implemented.");
            }

            public String getEncoding() {
                return null;
            }

            public void setEncoding(String encoding) {
                throw new UnsupportedOperationException("setEncoding is not implemented.");
            }

            public boolean getCertifiedText() {
                return false;
            }

            public void setCertifiedText(boolean certifiedText) {
                throw new UnsupportedOperationException("setCertifiedText is not implemented.");
            }
        });
        if (model == null) {
            throw new IllegalArgumentException("Cannot load schema");
        }
        return model;
    }

    private static XSImplementation getXSImplementation() {
        XSImplementation impl;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            String name = "org.apache.xerces.dom.DOMXSImplementationSourceImpl";
            loader.loadClass(name);
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", name);
        }
        catch (ClassNotFoundException e) {
            String name = "org.apache.xerces.dom.DOMXSImplementationSourceImpl";
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", name);
        }
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
        }
        catch (Exception e) {
            log.error("Failed to create schema loader.", e);
            throw new IllegalStateException("Failed to create schema loader: " + e.getMessage());
        }
        return impl;
    }

    private static boolean isArrayWrapper(XSTypeDefinition type) {
        XSComplexTypeDefinition cType;
        XSParticle particle;
        boolean is = false;
        if (15 == type.getTypeCategory() && (particle = (cType = (XSComplexTypeDefinition)type).getParticle()) != null) {
            is = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
        }
        return is;
    }
}

