/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.ews.mapper.jaxrpc;

import com.sun.java.xml.ns.j2Ee.ExceptionMappingType;
import com.sun.java.xml.ns.j2Ee.JavaWsdlMappingDocument;
import com.sun.java.xml.ns.j2Ee.JavaWsdlMappingType;
import com.sun.java.xml.ns.j2Ee.JavaXmlTypeMappingType;
import com.sun.java.xml.ns.j2Ee.MethodParamPartsMappingType;
import com.sun.java.xml.ns.j2Ee.PackageMappingType;
import com.sun.java.xml.ns.j2Ee.PortMappingType;
import com.sun.java.xml.ns.j2Ee.ServiceEndpointInterfaceMappingType;
import com.sun.java.xml.ns.j2Ee.ServiceEndpointMethodMappingType;
import com.sun.java.xml.ns.j2Ee.ServiceInterfaceMappingType;
import com.sun.java.xml.ns.j2Ee.WsdlReturnValueMappingType;
import com.sun.java.xml.ns.j2Ee.XsdQNameType;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.ws.ews.mapper.J2eeUtils;
import org.apache.ws.ews.mapper.MapperFault;
import org.apache.ws.ews.mapper.jaxrpc.JaxRpcMapper;
import org.apache.xmlbeans.XmlException;

public class XMLBeansJaxRpcMapper
implements JaxRpcMapper {
    private JavaWsdlMappingType mapping;
    private boolean wrappedElement = false;

    public void loadMappingFromInputStream(InputStream is) throws MapperFault {
        try {
            JavaWsdlMappingDocument mappingdoc = JavaWsdlMappingDocument.Factory.parse(is);
            this.mapping = mappingdoc.getJavaWsdlMapping();
        }
        catch (XmlException e) {
            e.printStackTrace();
            throw MapperFault.createMapperFault((Exception)((Object)e));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw MapperFault.createMapperFault(e);
        }
        this.wrappedElement = this.checkWrappedElemente();
    }

    public void loadMappingFromDir(String path) throws MapperFault {
        try {
            FileInputStream fis = new FileInputStream(path);
            JavaWsdlMappingDocument mappingdoc = JavaWsdlMappingDocument.Factory.parse(fis);
            this.mapping = mappingdoc.getJavaWsdlMapping();
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            throw MapperFault.createMapperFault(e2);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw MapperFault.createMapperFault(e);
        }
        catch (XmlException e2) {
            e2.printStackTrace();
            throw MapperFault.createMapperFault((Exception)((Object)e2));
        }
        this.wrappedElement = this.checkWrappedElemente();
    }

    public int getPackageMappingCount() {
        PackageMappingType[] packagemapping = this.mapping.getPackageMappingArray();
        return packagemapping.length;
    }

    public String getPackageMappingClassName(int index) {
        PackageMappingType[] packagemapping = this.mapping.getPackageMappingArray();
        return packagemapping[index].getPackageType().getStringValue();
    }

    public String getPackageMappingURI(int index) {
        PackageMappingType[] packagemapping = this.mapping.getPackageMappingArray();
        return packagemapping[index].getNamespaceURI().getStringValue();
    }

    public JavaWsdlMappingType getMapping() {
        return this.mapping;
    }

    public String getJavaType(QName typeQName) {
        if (this.mapping == null) {
            return null;
        }
        JavaXmlTypeMappingType[] typeList = this.mapping.getJavaXmlTypeMappingArray();
        for (int i = 0; i < typeList.length; ++i) {
            JavaXmlTypeMappingType typeMapping = typeList[i];
            XsdQNameType rootType = typeMapping.getRootTypeQname();
            if (rootType == null) {
                String mappedAnonymousTypeName = typeMapping.getAnonymousTypeQname().getStringValue();
                String localPart = typeQName.getLocalPart();
                String revisitedTypeQName = typeQName.getNamespaceURI() + ":" + localPart;
                if (!mappedAnonymousTypeName.equals(revisitedTypeQName)) continue;
                return J2eeUtils.jni2javaName(typeMapping.getJavaType().getStringValue());
            }
            QName typeName = rootType.getQNameValue();
            if (!typeQName.equals(typeName)) continue;
            String className = typeMapping.getJavaType().getStringValue();
            return J2eeUtils.jni2javaName(className);
        }
        return null;
    }

    public String getExceptionType(QName messageQName) {
        if (this.mapping == null) {
            return null;
        }
        ExceptionMappingType[] exceptionMappingList = this.mapping.getExceptionMappingArray();
        for (int j = 0; j < exceptionMappingList.length; ++j) {
            ExceptionMappingType exceptionMapping = exceptionMappingList[j];
            QName name = exceptionMapping.getWsdlMessage().getQNameValue();
            if (!messageQName.equals(name)) continue;
            return exceptionMapping.getExceptionType().getStringValue();
        }
        return null;
    }

    public String getPortName(String portName) {
        if (this.mapping == null) {
            return null;
        }
        ServiceInterfaceMappingType[] serviceList = this.mapping.getServiceInterfaceMappingArray();
        for (int i = 0; i < serviceList.length; ++i) {
            PortMappingType[] portList = serviceList[i].getPortMappingArray();
            for (int j = 0; j < portList.length; ++j) {
                PortMappingType portMapping = portList[j];
                String mappedPortName = portMapping.getPortName().getStringValue();
                if (!portName.equals(mappedPortName)) continue;
                return portMapping.getJavaPortName().getStringValue();
            }
        }
        return null;
    }

    public String getServiceInterfaceName(QName entry) {
        if (this.mapping == null) {
            return null;
        }
        ServiceInterfaceMappingType[] serviceList = this.mapping.getServiceInterfaceMappingArray();
        for (int i = 0; i < serviceList.length; ++i) {
            QName wsdlServiceName = serviceList[i].getWsdlServiceName().getQNameValue();
            if (!entry.equals(wsdlServiceName)) continue;
            String serviceInterfaceName = serviceList[i].getServiceInterface().getStringValue();
            return serviceInterfaceName;
        }
        return null;
    }

    public String getServiceEndpointInterfaceName(QName portTypeQName, QName bindingQName) {
        if (this.mapping == null) {
            return null;
        }
        ServiceEndpointInterfaceMappingType[] serviceList = this.mapping.getServiceEndpointInterfaceMappingArray();
        for (int i = 0; i < serviceList.length; ++i) {
            QName wsdlBinging = serviceList[i].getWsdlBinding().getQNameValue();
            QName wsdlPortType = serviceList[i].getWsdlPortType().getQNameValue();
            if (!bindingQName.equals(wsdlBinging) || !portTypeQName.equals(wsdlPortType)) continue;
            String endpointServiceName = serviceList[i].getServiceEndpointInterface().getStringValue();
            return endpointServiceName;
        }
        return null;
    }

    public String getJavaMethodParamType(QName bindingQName, QName portTypeQName, String operationName, int position) {
        if (this.mapping == null) {
            return null;
        }
        ServiceEndpointInterfaceMappingType[] serviceList = this.mapping.getServiceEndpointInterfaceMappingArray();
        for (int i = 0; i < serviceList.length; ++i) {
            QName wsdlBinging = serviceList[i].getWsdlBinding().getQNameValue();
            QName wsdlPortType = serviceList[i].getWsdlPortType().getQNameValue();
            if (!bindingQName.equals(wsdlBinging) || !portTypeQName.equals(wsdlPortType)) continue;
            ServiceEndpointMethodMappingType[] methodList = serviceList[i].getServiceEndpointMethodMappingArray();
            for (int k = 0; k < methodList.length; ++k) {
                ServiceEndpointMethodMappingType methodMapping = methodList[k];
                String mappedOperationName = methodMapping.getWsdlOperation().getStringValue();
                if (!operationName.equals(mappedOperationName)) continue;
                MethodParamPartsMappingType[] paramList = methodMapping.getMethodParamPartsMappingArray();
                for (int m = 0; m < paramList.length; ++m) {
                    MethodParamPartsMappingType paramPart = paramList[m];
                    if (paramPart.getParamPosition().getBigIntegerValue().intValue() != position) continue;
                    return J2eeUtils.jni2javaName(paramPart.getParamType().getStringValue());
                }
            }
        }
        return null;
    }

    public boolean checkWrappedElemente() {
        if (this.mapping == null) {
            return false;
        }
        ServiceEndpointInterfaceMappingType[] serviceList = this.mapping.getServiceEndpointInterfaceMappingArray();
        for (int i = 0; i < serviceList.length; ++i) {
            ServiceEndpointMethodMappingType[] methodList = serviceList[i].getServiceEndpointMethodMappingArray();
            for (int k = 0; k < methodList.length; ++k) {
                ServiceEndpointMethodMappingType methodMapping = methodList[k];
                if (methodMapping.getWrappedElement() == null) continue;
                return true;
            }
        }
        return false;
    }

    public String getJavaMethodReturnType(QName bindingQName, QName portTypeQName, String operationName) {
        if (this.mapping == null) {
            return null;
        }
        ServiceEndpointInterfaceMappingType[] serviceList = this.mapping.getServiceEndpointInterfaceMappingArray();
        for (int i = 0; i < serviceList.length; ++i) {
            QName wsdlBinging = serviceList[i].getWsdlBinding().getQNameValue();
            QName wsdlPortType = serviceList[i].getWsdlPortType().getQNameValue();
            if (!bindingQName.equals(wsdlBinging) || !portTypeQName.equals(wsdlPortType)) continue;
            ServiceEndpointMethodMappingType[] methodList = serviceList[i].getServiceEndpointMethodMappingArray();
            for (int k = 0; k < methodList.length; ++k) {
                WsdlReturnValueMappingType returnValueMapping;
                ServiceEndpointMethodMappingType methodMapping = methodList[k];
                String mappedOperationName = methodMapping.getWsdlOperation().getStringValue();
                if (!operationName.equals(mappedOperationName) || (returnValueMapping = methodMapping.getWsdlReturnValueMapping()) == null) continue;
                return J2eeUtils.jni2javaName(returnValueMapping.getMethodReturnValue().getStringValue());
            }
        }
        return null;
    }

    public String getJavaMethodName(QName bindingQName, QName portTypeQName, String operationName) {
        if (this.mapping == null) {
            return null;
        }
        ServiceEndpointInterfaceMappingType[] serviceList = this.mapping.getServiceEndpointInterfaceMappingArray();
        for (int i = 0; i < serviceList.length; ++i) {
            QName wsdlBinging = serviceList[i].getWsdlBinding().getQNameValue();
            QName wsdlPortType = serviceList[i].getWsdlPortType().getQNameValue();
            if (!bindingQName.equals(wsdlBinging) || !portTypeQName.equals(wsdlPortType)) continue;
            ServiceEndpointMethodMappingType[] methodList = serviceList[i].getServiceEndpointMethodMappingArray();
            for (int k = 0; k < methodList.length; ++k) {
                ServiceEndpointMethodMappingType methodMapping = methodList[k];
                String mappedOperationName = methodMapping.getWsdlOperation().getStringValue();
                if (!operationName.equals(mappedOperationName)) continue;
                return methodMapping.getJavaMethodName().getStringValue();
            }
        }
        return null;
    }

    public boolean hasWrappedElement() {
        return this.wrappedElement;
    }
}

