/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.component;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ow2.jonas.camel.service.api.ICamelService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryInjector {
    private static final String REGISTRY_PREFIX = "registry";
    private Map<String, String> replacements = new HashMap<String, String>();
    private File conf;
    private List<String> registryFilesContent;

    public RegistryInjector(Map<String, String> replacements) throws Exception {
        this(replacements, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryInjector(Map<String, String> replacements, List<String> includeXMLs) throws Exception {
        String fileName;
        String JONAS_BASE = System.getProperty("jonas.base");
        if (JONAS_BASE == null) {
            throw new RuntimeException("JONAS_BASE not defined");
        }
        this.conf = new File(JONAS_BASE, "conf").getAbsoluteFile();
        for (File file : this.conf.listFiles()) {
            fileName = file.getName();
            if (!fileName.startsWith(REGISTRY_PREFIX) || !fileName.endsWith(".properties")) continue;
            FileInputStream is = new FileInputStream(file);
            try {
                Properties registryProperties = new Properties();
                registryProperties.load(is);
                for (Map.Entry<Object, Object> entry : registryProperties.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    this.replacements.put(key, value);
                }
            }
            finally {
                ((InputStream)is).close();
                is = null;
            }
        }
        if (replacements != null) {
            this.replacements.putAll(replacements);
        }
        this.registryFilesContent = new ArrayList<String>();
        for (File file : this.conf.listFiles()) {
            String registryString;
            fileName = file.getName();
            if (!fileName.startsWith(REGISTRY_PREFIX) || !fileName.endsWith(".xml") || includeXMLs != null && !includeXMLs.contains(fileName)) continue;
            FileReader fr = new FileReader(file);
            try {
                BufferedReader br = new BufferedReader(fr);
                try {
                    String line;
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        stringBuilder.append(line);
                        stringBuilder.append('\n');
                    }
                    registryString = stringBuilder.toString();
                }
                finally {
                    br.close();
                    br = null;
                }
            }
            finally {
                fr.close();
                fr = null;
            }
            for (Map.Entry<Object, Object> entry : this.replacements.entrySet()) {
                registryString = registryString.replace("$" + (String)entry.getKey(), (CharSequence)entry.getValue());
            }
            this.registryFilesContent.add(registryString);
        }
    }

    public List<String> getRegistryFilesContent() {
        return this.registryFilesContent;
    }

    public void injectRegistry(ICamelService camelService, String camelContextName) throws Exception {
        for (String registryString : this.registryFilesContent) {
            ByteArrayInputStream bais = new ByteArrayInputStream(registryString.getBytes());
            camelService.addRegistry((InputStream)bais, camelContextName);
        }
    }
}

