/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.language.simple.SimpleLanguageSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;

public class SimpleLanguage
extends SimpleLanguageSupport {
    private static final SimpleLanguage SIMPLE = new SimpleLanguage();

    public static Expression simple(String expression) {
        return SIMPLE.createExpression(expression);
    }

    protected Expression createSimpleExpression(String expression, boolean strict) {
        String[] parts;
        if (ObjectHelper.isEqualToAny(expression, "body", "in.body")) {
            return ExpressionBuilder.bodyExpression();
        }
        if (ObjectHelper.equal(expression, "out.body")) {
            return ExpressionBuilder.outBodyExpression();
        }
        if (ObjectHelper.equal(expression, "id")) {
            return ExpressionBuilder.messageIdExpression();
        }
        if (ObjectHelper.equal(expression, "exchangeId")) {
            return ExpressionBuilder.exchangeIdExpression();
        }
        if (ObjectHelper.equal(expression, "exception.message")) {
            return ExpressionBuilder.exchangeExceptionMessageExpression();
        }
        if (ObjectHelper.equal(expression, "threadName")) {
            return ExpressionBuilder.threadNameExpression();
        }
        String remainder = this.ifStartsWithReturnRemainder("bodyAs", expression);
        if (remainder != null) {
            String type = ObjectHelper.between(remainder, "(", ")");
            if (type == null) {
                throw new ExpressionIllegalSyntaxException("Valid syntax: ${bodyAs(type)} was: " + expression);
            }
            return ExpressionBuilder.bodyExpression(type);
        }
        remainder = this.ifStartsWithReturnRemainder("body", expression);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.body", expression);
        }
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder);
            if (invalid) {
                throw new ExpressionIllegalSyntaxException("Valid syntax: ${body.OGNL} was: " + expression);
            }
            return ExpressionBuilder.bodyOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("in.headers", expression);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.header", expression);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("headers", expression);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("header", expression);
        }
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression(remainder = remainder.substring(1));
            if (invalid) {
                throw new ExpressionIllegalSyntaxException("Valid syntax: ${header.name[key]} was: " + expression);
            }
            if (OgnlHelper.isValidOgnlExpression(remainder)) {
                return ExpressionBuilder.headersOgnlExpression(remainder);
            }
            return ExpressionBuilder.headerExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("out.header.", expression);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("out.headers.", expression);
        }
        if (remainder != null) {
            return ExpressionBuilder.outHeaderExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("property.", expression);
        if (remainder != null) {
            return ExpressionBuilder.propertyExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sys.", expression);
        if (remainder != null) {
            return ExpressionBuilder.systemPropertyExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sysenv.", expression);
        if (remainder != null) {
            return ExpressionBuilder.systemEnvironmentExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("file:", expression);
        if (remainder != null) {
            Expression fileExpression = this.createSimpleFileExpression(remainder);
            if (expression != null) {
                return fileExpression;
            }
        }
        if ((remainder = this.ifStartsWithReturnRemainder("date:", expression)) != null) {
            parts = remainder.split(":");
            if (parts.length < 2) {
                throw new ExpressionIllegalSyntaxException("Valid syntax: ${date:command:pattern} was: " + expression);
            }
            String command = ObjectHelper.before(remainder, ":");
            String pattern = ObjectHelper.after(remainder, ":");
            return ExpressionBuilder.dateExpression(command, pattern);
        }
        remainder = this.ifStartsWithReturnRemainder("bean:", expression);
        if (remainder != null) {
            return ExpressionBuilder.beanExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("properties:", expression);
        if (remainder != null) {
            parts = remainder.split(":");
            if (parts.length > 2) {
                throw new ExpressionIllegalSyntaxException("Valid syntax: ${properties:[locations]:key} was: " + expression);
            }
            String locations = null;
            String key = remainder;
            if (parts.length == 2) {
                locations = ObjectHelper.before(remainder, ":");
                key = ObjectHelper.after(remainder, ":");
            }
            return ExpressionBuilder.propertiesComponentExpression(key, locations);
        }
        if (strict) {
            throw new ExpressionIllegalSyntaxException(expression);
        }
        return ExpressionBuilder.constantExpression(expression);
    }

    public Expression createSimpleFileExpression(String remainder) {
        if (ObjectHelper.equal(remainder, "name")) {
            return ExpressionBuilder.fileNameExpression();
        }
        if (ObjectHelper.equal(remainder, "name.noext")) {
            return ExpressionBuilder.fileNameNoExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "name.ext")) {
            return ExpressionBuilder.fileExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "onlyname")) {
            return ExpressionBuilder.fileOnlyNameExpression();
        }
        if (ObjectHelper.equal(remainder, "onlyname.noext")) {
            return ExpressionBuilder.fileOnlyNameNoExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "ext")) {
            return ExpressionBuilder.fileExtensionExpression();
        }
        if (ObjectHelper.equal(remainder, "parent")) {
            return ExpressionBuilder.fileParentExpression();
        }
        if (ObjectHelper.equal(remainder, "path")) {
            return ExpressionBuilder.filePathExpression();
        }
        if (ObjectHelper.equal(remainder, "absolute")) {
            return ExpressionBuilder.fileAbsoluteExpression();
        }
        if (ObjectHelper.equal(remainder, "absolute.path")) {
            return ExpressionBuilder.fileAbsolutePathExpression();
        }
        if (ObjectHelper.equal(remainder, "length")) {
            return ExpressionBuilder.fileSizeExpression();
        }
        if (ObjectHelper.equal(remainder, "modified")) {
            return ExpressionBuilder.fileLastModifiedExpression();
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }
}

