/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailOverLoadBalancer
extends LoadBalancerSupport {
    private final List<Class<?>> exceptions;
    private boolean roundRobin;
    private int maximumFailoverAttempts = -1;
    private int counter = -1;

    public FailOverLoadBalancer() {
        this.exceptions = null;
    }

    public FailOverLoadBalancer(List<Class<?>> exceptions) {
        this.exceptions = exceptions;
        for (Class<?> type : exceptions) {
            if (ObjectHelper.isAssignableFrom(Throwable.class, type)) continue;
            throw new IllegalArgumentException("Class is not an instance of Throwable: " + type);
        }
    }

    public List<Class<?>> getExceptions() {
        return this.exceptions;
    }

    public boolean isRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(boolean roundRobin) {
        this.roundRobin = roundRobin;
    }

    public int getMaximumFailoverAttempts() {
        return this.maximumFailoverAttempts;
    }

    public void setMaximumFailoverAttempts(int maximumFailoverAttempts) {
        this.maximumFailoverAttempts = maximumFailoverAttempts;
    }

    protected boolean shouldFailOver(Exchange exchange) {
        if (exchange.getException() != null) {
            if (this.exceptions == null || this.exceptions.isEmpty()) {
                return true;
            }
            for (Class<?> exception : this.exceptions) {
                if (exchange.getException(exception) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        List<Processor> list = this.getProcessors();
        if (list.isEmpty()) {
            throw new IllegalStateException("No processors available to process " + exchange);
        }
        int index = 0;
        int attempts = 0;
        if (this.isRoundRobin()) {
            if (++this.counter >= list.size()) {
                this.counter = 0;
            }
            index = this.counter;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Failover starting with endpoint index " + index));
        }
        Processor processor = list.get(index);
        this.processExchange(processor, exchange, attempts);
        while (this.shouldFailOver(exchange)) {
            if (this.maximumFailoverAttempts > -1 && ++attempts > this.maximumFailoverAttempts) {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)("Braking out of failover after " + attempts + " failover attempts"));
                break;
            }
            ++this.counter;
            if (++index >= list.size()) {
                if (this.isRoundRobin()) {
                    this.log.debug((Object)"Failover is round robin enabled and therefore starting from the first endpoint");
                    index = 0;
                    this.counter = 0;
                } else {
                    this.log.debug((Object)"Braking out of failover as we reach the end of endpoints to use for failover");
                    break;
                }
            }
            this.prepareExchangeForFailover(exchange);
            processor = list.get(index);
            this.processExchange(processor, exchange, attempts);
        }
    }

    protected void prepareExchangeForFailover(Exchange exchange) {
        exchange.setException(null);
        exchange.setProperty("CamelErrorHandlerHandled", null);
        exchange.setProperty("CamelFailureHandled", null);
        exchange.setProperty("CamelExceptionCaught", null);
        exchange.getIn().removeHeader("CamelRedelivered");
        exchange.getIn().removeHeader("CamelRedeliveryCounter");
    }

    private void processExchange(Processor processor, Exchange exchange, int attempt) {
        if (processor == null) {
            throw new IllegalStateException("No processors could be chosen to process " + exchange);
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processing failover at attempt " + attempt + " for exchange: " + exchange));
            }
            processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
    }

    public String toString() {
        return "FailoverLoadBalancer";
    }
}

