/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.auditreport.impl;

import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.auditreport.api.ICurrentInvocationID;
import org.ow2.util.auditreport.impl.AuditIDImpl;

public class CurrentInvocationID
implements ICurrentInvocationID {
    private ThreadLocal<IAuditID> threadLocal = new ThreadLocal();
    private static ICurrentInvocationID unique = null;

    public static synchronized ICurrentInvocationID getInstance() {
        if (unique == null) {
            unique = new CurrentInvocationID();
        }
        return unique;
    }

    public IAuditID setAuditID(IAuditID auditID) {
        IAuditID previous = this.threadLocal.get();
        this.threadLocal.set(auditID);
        return previous;
    }

    public IAuditID getAuditID() {
        return this.threadLocal.get();
    }

    public void init(IAuditID id) {
        IAuditID newId = null;
        if (id != null) {
            newId = id;
        } else {
            newId = new AuditIDImpl();
            newId.generate();
        }
        this.threadLocal.set(newId);
    }

    public IAuditID newInvocation() {
        IAuditID previous = this.threadLocal.get();
        AuditIDImpl id = new AuditIDImpl();
        id.generate();
        if (previous != null) {
            previous.increment();
            id.setParentID(previous.getLocalID());
        }
        this.threadLocal.set(id);
        return previous;
    }
}

