/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.impl.DefaultConsumerTemplate;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.spring.util.CamelContextResolverHelper;
import org.apache.camel.util.ServiceHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@XmlRootElement(name="consumerTemplate")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelConsumerTemplateFactoryBean
extends IdentifiedType
implements FactoryBean,
InitializingBean,
DisposableBean,
CamelContextAware,
ApplicationContextAware {
    @XmlTransient
    private ConsumerTemplate template;
    @XmlAttribute
    private String camelContextId;
    @XmlTransient
    private CamelContext camelContext;
    @XmlTransient
    private ApplicationContext applicationContext;
    @XmlAttribute
    private Integer maximumCacheSize;

    public void afterPropertiesSet() throws Exception {
        if (this.camelContext == null && this.camelContextId != null) {
            this.camelContext = CamelContextResolverHelper.getCamelContextWithId(this.applicationContext, this.camelContextId);
        }
        if (this.camelContext == null) {
            throw new IllegalArgumentException("A CamelContext or a CamelContextId must be injected!");
        }
    }

    public Object getObject() throws Exception {
        this.template = new DefaultConsumerTemplate(this.camelContext);
        if (this.maximumCacheSize != null) {
            this.template.setMaximumCacheSize(this.maximumCacheSize.intValue());
        }
        ServiceHelper.startService((Object)this.template);
        return this.template;
    }

    public Class getObjectType() {
        return DefaultConsumerTemplate.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        ServiceHelper.stopService((Object)this.template);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setCamelContextId(String camelContextId) {
        this.camelContextId = camelContextId;
    }

    public Integer getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public void setMaximumCacheSize(Integer maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }
}

