/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.security.wss4j.DefaultSecurityContext;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.processor.Processor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUsernameTokenAuthenticatingInterceptor
extends WSS4JInInterceptor
implements Processor {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractUsernameTokenAuthenticatingInterceptor.class);
    private boolean supportDigestPasswords;

    public AbstractUsernameTokenAuthenticatingInterceptor() {
    }

    public AbstractUsernameTokenAuthenticatingInterceptor(Map<String, Object> properties) {
        super(properties);
    }

    public void setSupportDigestPasswords(boolean support) {
        this.supportDigestPasswords = support;
    }

    @Override
    protected SecurityContext createSecurityContext(Principal p) {
        Message msg = PhaseInterceptorChain.getCurrentMessage();
        if (msg == null) {
            throw new IllegalStateException("Current message is not available");
        }
        return this.doCreateSecurityContext(p, msg.get(Subject.class));
    }

    protected SecurityContext doCreateSecurityContext(Principal p, Subject subject) {
        return new DefaultSecurityContext(p, subject);
    }

    protected void setSubject(String name, String password, boolean isDigest, String nonce, String created) throws WSSecurityException {
        Message msg = PhaseInterceptorChain.getCurrentMessage();
        if (msg == null) {
            throw new IllegalStateException("Current message is not available");
        }
        Subject subject = null;
        try {
            subject = this.createSubject(name, password, isDigest, nonce, created);
        }
        catch (Exception ex) {
            throw new WSSecurityException("Failed Authentication : Subject has not been created", (Throwable)ex);
        }
        if (subject == null || subject.getPrincipals().size() == 0 || !subject.getPrincipals().iterator().next().getName().equals(name)) {
            throw new WSSecurityException("Failed Authentication : Invalid Subject");
        }
        msg.put(Subject.class, subject);
    }

    protected abstract Subject createSubject(String var1, String var2, boolean var3, String var4, String var5) throws SecurityException;

    @Override
    protected CallbackHandler getCallback(RequestData reqData, int doAction) throws WSSecurityException {
        if ((doAction & 1) != 0 && !this.supportDigestPasswords) {
            CallbackHandler pwdCallback = null;
            try {
                pwdCallback = super.getCallback(reqData, doAction);
            }
            catch (Exception ex) {
                // empty catch block
            }
            return new DelegatingCallbackHandler(pwdCallback);
        }
        return super.getCallback(reqData, doAction);
    }

    @Override
    protected WSSecurityEngine getSecurityEngine() {
        if (!this.supportDigestPasswords) {
            return super.getSecurityEngine();
        }
        HashMap<QName, Object> profiles = new HashMap<QName, Object>(3);
        profiles.put(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0", "UsernameToken"), this);
        profiles.put(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken"), this);
        profiles.put(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "UsernameToken"), this);
        return AbstractUsernameTokenAuthenticatingInterceptor.createSecurityEngine(profiles);
    }

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig config) throws WSSecurityException {
        new CustomUsernameTokenProcessor().handleToken(elem, crypto, decCrypto, cb, wsDocInfo, returnResults, config);
    }

    private class CustomUsernameTokenProcessor
    implements Processor {
        private String utId;
        private UsernameToken ut;

        private CustomUsernameTokenProcessor() {
        }

        public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found UsernameToken list element");
            }
            WSUsernameTokenPrincipal principal = this.handleUsernameToken(elem, cb);
            returnResults.add(0, new WSSecurityEngineResult(1, (Principal)principal, null, null, null));
            this.utId = this.ut.getID();
        }

        private WSUsernameTokenPrincipal handleUsernameToken(Element token, CallbackHandler cb) throws WSSecurityException {
            this.ut = new UsernameToken(token, false);
            String user = this.ut.getName();
            String password = this.ut.getPassword();
            String nonce = this.ut.getNonce();
            String createdTime = this.ut.getCreated();
            String pwType = this.ut.getPasswordType();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("UsernameToken user " + user);
                LOG.fine("UsernameToken password " + password);
            }
            AbstractUsernameTokenAuthenticatingInterceptor.this.setSubject(user, password, this.ut.isHashed(), nonce, createdTime);
            WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(user, this.ut.isHashed());
            principal.setNonce(nonce);
            principal.setPassword(password);
            principal.setCreatedTime(createdTime);
            principal.setPasswordType(pwType);
            return principal;
        }

        public String getId() {
            return this.utId;
        }
    }

    private class DelegatingCallbackHandler
    implements CallbackHandler {
        private CallbackHandler pwdHandler;

        public DelegatingCallbackHandler(CallbackHandler pwdHandler) {
            this.pwdHandler = pwdHandler;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback c : callbacks) {
                if (!(c instanceof WSPasswordCallback)) continue;
                WSPasswordCallback pc = (WSPasswordCallback)c;
                if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(pc.getPasswordType()) && pc.getUsage() == 5) {
                    AbstractUsernameTokenAuthenticatingInterceptor.this.setSubject(pc.getIdentifier(), pc.getPassword(), false, null, null);
                    continue;
                }
                if (this.pwdHandler == null) continue;
                this.pwdHandler.handle(callbacks);
            }
        }
    }
}

