/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.interceptor.InvocationContext;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.proxy.InterceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptionChain {
    private final Logger log = LoggerFactory.getLogger(InterceptionChain.class);
    private Object target;
    private Object[] parameters;
    private Method targetMethod;
    private int currentPosition;
    private List<InterceptionHandler> interceptorHandlers;
    private final InterceptionType interceptionType;

    public InterceptionChain(List<InterceptionHandler> interceptorHandlers, InterceptionType interceptionType, Object target, Method targetMethod, Object[] parameters) {
        this.interceptorHandlers = interceptorHandlers;
        this.interceptionType = interceptionType;
        this.parameters = parameters;
        this.target = target;
        this.targetMethod = targetMethod;
        this.currentPosition = 0;
    }

    public Object invokeNext(InvocationContext invocationContext) throws Throwable {
        if (this.hasNext()) {
            InterceptionHandler nextInterceptorHandler = this.interceptorHandlers.get(this.currentPosition++);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Invoking next interceptor in chain:" + nextInterceptorHandler.getClass().getName());
            }
            return nextInterceptorHandler.invoke(this.target, this.interceptionType, invocationContext);
        }
        if (this.targetMethod != null) {
            try {
                return this.targetMethod.invoke(this.target, invocationContext.getParameters());
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        return null;
    }

    public boolean hasNext() {
        return this.currentPosition < this.interceptorHandlers.size();
    }
}

