/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.cm;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.wrapper.printwriter.LoggerImpl;
import org.ow2.jonas.resource.internal.IJDBCConnection;
import org.ow2.jonas.resource.internal.SQLManager;
import org.ow2.jonas.resource.internal.cm.ConnectionManagerPoolParams;
import org.ow2.jonas.resource.internal.cm.ConnectionResourceHint;
import org.ow2.jonas.resource.internal.cm.ManagedConnectionInfo;
import org.ow2.jonas.resource.internal.cm.jta.JResourceManagerEvent;
import org.ow2.jonas.resource.internal.cm.jta.JSynchronization;
import org.ow2.jonas.resource.internal.cm.jta.LocalXAResource;
import org.ow2.jonas.resource.internal.cm.sql.PreparedStatementWrapper;
import org.ow2.jonas.resource.internal.cm.sql.SQLConnectionInvocationHandler;
import org.ow2.jonas.resource.internal.pool.Pool;
import org.ow2.jonas.resource.internal.pool.PoolMatchFactory;
import org.ow2.jonas.resource.internal.pool.lib.HArrayPool;
import org.ow2.jonas.tm.Enlistable;
import org.ow2.jonas.tm.TransactionManager;
import org.ow2.jonas.tm.TxResourceManager;

public class ConnectionManagerImpl
implements ConnectionEventListener,
ConnectionManager,
PoolMatchFactory,
SQLManager,
TxResourceManager {
    public static Logger trace = null;
    public static Logger poolTrace = null;
    protected boolean dummyPool = false;
    protected TransactionManager tm;
    protected Hashtable mc2mci = null;
    protected String jndiname = null;
    private int mcMaxPoolSize = -1;
    private int mcMinPoolSize = 0;
    private ManagedConnectionFactory mcf;
    private ValidatingManagedConnectionFactory vmcf = null;
    private Pool poolMCs = null;
    private Map usedMCs = null;
    static final int MAX_PSTMT_SIZE = 20;
    private int maxPstmtPoolSize = 20;
    private int jdbcConnLevel = 0;
    private String jdbcConnTestStmt = "";
    private boolean jdbcConnSetUp;
    private List mcs = new Vector();
    private List synchros = new Vector();
    private ConnectionResourceHint connectionResourceHint = null;
    private String transSupport = null;
    public static final String RESOURCE_BUNDLE_NAME = "resourceBundleName";
    public static final String LOGGER = "org.objectweb.util.monolog.logger";
    public static final String POOL_LOGGER = "org.objectweb.util.monolog.logger_pool";
    public static final String JNDINAME = "jndiname";
    public static final String LOGGER_FACTORY = "org.objectweb.util.monolog.loggerFactory";
    public static final String TRANSACTION_MANAGER = "transactionManager";
    public static final String RESOURCE_ADAPTER = "resourceAdapter";
    public static final String PRINT_WRITER = "printWriter";
    public static final String NO_TRANS_SUPPORT = "NoTransaction";
    public static final String LOCAL_TRANS_SUPPORT = "LocalTransaction";
    public static final String XA_TRANS_SUPPORT = "XATransaction";
    public static final int PSWRAP_1 = 1;
    public static final int PSWRAP_2 = 2;
    public static final int PSWRAP_3 = 3;
    public static final int PSWRAP_4 = 4;
    public static final int PSWRAP_5 = 5;
    public static final int JDBC_NO_TEST = 0;
    public static final int JDBC_CHECK_CONNECTION = 1;
    public static final int JDBC_SEND_STATEMENT = 2;
    public static final int JDBC_KEEP_ALIVE = 3;
    private ManagedConnection jotmMc = null;
    private XAResource jotmXar = null;
    private String xaName = null;
    private boolean isEnabledDebug = false;
    private boolean observable = false;

    public ConnectionManagerImpl(String transSupport) {
        this.transSupport = transSupport.length() == 0 ? NO_TRANS_SUPPORT : transSupport;
    }

    public void setLogger(Logger l) {
        trace = l;
        this.isEnabledDebug = trace.isLoggable(BasicLevel.DEBUG);
    }

    public void setLoggerFactory(LoggerFactory lf) {
        trace = lf.getLogger("org.objectweb.resource.server");
        this.isEnabledDebug = trace.isLoggable(BasicLevel.DEBUG);
    }

    public void setPrintWriter(PrintWriter pw) {
        trace = new LoggerImpl(pw);
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    public void setResourceAdapter(ManagedConnectionFactory tmcf) throws Exception {
        this.setResourceAdapter(tmcf, new ConnectionManagerPoolParams());
    }

    public void setResourceAdapter(ManagedConnectionFactory tmcf, ConnectionManagerPoolParams cmpp) throws Exception {
        if (cmpp.getPoolMax() != 0) {
            this.mcMaxPoolSize = cmpp.getPoolMax();
        }
        if (cmpp.getPoolMin() > 0) {
            this.mcMinPoolSize = cmpp.getPoolMin();
        }
        this.jdbcConnLevel = cmpp.getJdbcConnLevel();
        this.jdbcConnTestStmt = cmpp.getJdbcConnTestStmt();
        this.jdbcConnSetUp = cmpp.isJdbcConnSetUp();
        this.mcf = tmcf;
        if (this.mcf instanceof ValidatingManagedConnectionFactory) {
            this.vmcf = (ValidatingManagedConnectionFactory)this.mcf;
        }
        this.poolMCs = new HArrayPool(poolTrace, this.jndiname);
        this.poolMCs.setMatchFactory(this);
        if (!this.dummyPool) {
            if (cmpp.getPoolMaxAge() > 0L) {
                int min = (int)(cmpp.getPoolMaxAge() / 60L);
                this.poolMCs.setMaxAge(min);
            } else {
                this.poolMCs.setMaxAge(cmpp.getPoolMaxAgeMinutes());
            }
            if (cmpp.getPoolMaxOpentime() > 0) {
                this.poolMCs.setMaxOpentime(cmpp.getPoolMaxOpentime());
            }
            this.poolMCs.setMaxWaiters(cmpp.getPoolMaxWaiters());
            if (cmpp.getPoolMaxWaittime() > 0) {
                this.poolMCs.setMaxWaitTime(cmpp.getPoolMaxWaittime());
            }
            this.poolMCs.setMaxSize(this.mcMaxPoolSize);
            this.poolMCs.setInitSize(cmpp.getPoolInit());
            this.poolMCs.setMinSize(this.mcMinPoolSize);
            this.poolMCs.setJdbcConnLevel(this.jdbcConnLevel);
            this.poolMCs.setJdbcTestStatement(this.jdbcConnTestStmt);
            this.poolMCs.startMonitor();
            this.poolMCs.setSamplingPeriod(cmpp.getPoolSamplingPeriod());
        }
        this.maxPstmtPoolSize = cmpp.getPstmtMax();
        this.usedMCs = new Hashtable();
        this.connectionResourceHint = new ConnectionResourceHint(null, null);
        if (this.isEnabledDebug) {
            trace.log(BasicLevel.DEBUG, (Object)"");
        }
    }

    public void init(Context ctx, boolean generic) throws Exception {
        this.mc2mci = new Hashtable();
        String resourceBundleName = null;
        try {
            resourceBundleName = (String)ctx.lookup(RESOURCE_BUNDLE_NAME);
        }
        catch (NamingException e) {
            // empty catch block
        }
        try {
            trace = (Logger)ctx.lookup(LOGGER);
            poolTrace = (Logger)ctx.lookup(POOL_LOGGER);
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (trace == null) {
            try {
                this.setLoggerFactory((LoggerFactory)ctx.lookup(LOGGER_FACTORY));
            }
            catch (NamingException e2) {
                // empty catch block
            }
        }
        if (trace == null) {
            PrintWriter pw = null;
            try {
                pw = (PrintWriter)ctx.lookup(PRINT_WRITER);
            }
            catch (NamingException e3) {
                // empty catch block
            }
            this.setPrintWriter(pw);
        }
        if (trace != null) {
            this.isEnabledDebug = trace.isLoggable(BasicLevel.DEBUG);
        }
        if (!this.transSupport.equalsIgnoreCase(NO_TRANS_SUPPORT)) {
            this.tm = (TransactionManager)ctx.lookup(TRANSACTION_MANAGER);
        }
        this.dummyPool = generic;
        try {
            this.setResourceAdapter((ManagedConnectionFactory)ctx.lookup(RESOURCE_ADAPTER));
        }
        catch (NamingException ne) {
            // empty catch block
        }
        try {
            this.jndiname = (String)ctx.lookup(JNDINAME);
        }
        catch (NamingException ne) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanResourceAdapter() throws ResourceException {
        Pool pool = this.poolMCs;
        synchronized (pool) {
            ManagedConnectionInfo mci;
            PreparedStatementWrapper pw = null;
            while (this.mcs != null && this.mcs.size() > 0) {
                mci = (ManagedConnectionInfo)this.mcs.remove(0);
                mci.usedCs.clear();
                List list = mci.pStmts;
                synchronized (list) {
                    while (mci.pStmts != null && mci.pStmts.size() > 0) {
                        pw = (PreparedStatementWrapper)mci.pStmts.remove(0);
                        try {
                            pw.destroy();
                        }
                        catch (Exception ex) {}
                    }
                }
                try {
                    this.mc2mci.remove(mci.mc);
                }
                catch (Exception ex) {}
            }
            if (this.usedMCs != null) {
                for (Object tx : this.usedMCs.keySet()) {
                    ManagedConnectionInfo mci2 = (ManagedConnectionInfo)this.usedMCs.get(tx);
                    if (mci2 == null) continue;
                    if (mci2.rmeCalled) {
                        mci2.rme.setValid(false);
                        this.tm.notifyConnectionClose((Enlistable)mci2.rme);
                        mci2.rmeCalled = false;
                    }
                    mci2.usedCs.clear();
                    List list = mci2.pStmts;
                    synchronized (list) {
                        while (mci2.pStmts != null && mci2.pStmts.size() > 0) {
                            pw = (PreparedStatementWrapper)mci2.pStmts.remove(0);
                            try {
                                pw.destroy();
                            }
                            catch (Exception ex) {}
                        }
                    }
                    try {
                        this.mc2mci.remove(mci2.mc);
                    }
                    catch (Exception ex) {}
                }
            }
            while (this.synchros != null && this.synchros.size() > 0) {
                Object tx;
                mci = (ManagedConnectionInfo)this.synchros.remove(0);
                mci.usedCs.clear();
                tx = mci.pStmts;
                synchronized (tx) {
                    while (mci.pStmts != null && mci.pStmts.size() > 0) {
                        pw = (PreparedStatementWrapper)mci.pStmts.remove(0);
                        try {
                            pw.destroy();
                        }
                        catch (Exception ex) {}
                    }
                }
                try {
                    this.mc2mci.remove(mci.mc);
                }
                catch (Exception ex) {}
            }
        }
        this.poolMCs.closeAllConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object allocateConnection(ManagedConnectionFactory pMcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        ManagedConnectionInfo mci = null;
        Transaction currentTx = null;
        Object connection = null;
        int retries = 0;
        Object subject = null;
        trace.log(BasicLevel.DEBUG, (Object)"");
        while (connection == null && retries < 20) {
            Pool pool = this.poolMCs;
            synchronized (pool) {
                if (this.mcf != pMcf && !pMcf.equals(this.mcf)) {
                    throw new ResourceException("This ConnectionManager doesn't manage this RA:" + this.mcf);
                }
                currentTx = null;
                try {
                    if (this.tm != null) {
                        currentTx = this.tm.getTransaction();
                    }
                }
                catch (Exception e) {
                    trace.log(BasicLevel.ERROR, (Object)"Impossible to get the current transaction", (Throwable)e, (Object)"ConnectionManagerImpl", (Object)"allocateConnection");
                }
                ManagedConnectionInfo managedConnectionInfo = mci = currentTx == null ? null : (ManagedConnectionInfo)this.usedMCs.get(currentTx);
                if (mci != null) {
                    if (mci.mc != null) {
                        if (this.isEnabledDebug) {
                            trace.log(BasicLevel.DEBUG, (Object)("MC (" + mci.mc + ") associated to the current Tx (" + currentTx + ") found"));
                        }
                        HashSet<ManagedConnection> s = new HashSet<ManagedConnection>();
                        s.add(mci.mc);
                        if (mci.mc != this.mcf.matchManagedConnections(s, null, cxRequestInfo)) {
                            throw new ResourceException("ConnectionManagerImpl.allocateConnection: illegal state : no mc is matched by mcf");
                        }
                        if (this.isEnabledDebug) {
                            trace.log(BasicLevel.DEBUG, (Object)("XA Resource " + mci.getXAResource() + " is already enlisted in Tx:" + mci.getGlobalTx()));
                        }
                    } else {
                        trace.log(BasicLevel.INFO, (Object)"remnant of an old failed connection");
                        mci.setGlobalTx(null);
                        mci = null;
                        this.usedMCs.remove(currentTx);
                    }
                }
                if (mci == null) {
                    this.connectionResourceHint.cxRequestInfo = cxRequestInfo;
                    if (subject != null || cxRequestInfo != null) {
                        // empty if block
                    }
                    try {
                        ManagedConnection mc = (ManagedConnection)this.poolMCs.getResource(this.connectionResourceHint);
                        if (mc == null) {
                            throw new ResourceException("ConnectionManagerImpl.allocateConnection: cannot allocate a ManagedConnection");
                        }
                        mci = (ManagedConnectionInfo)this.mc2mci.get(mc);
                        if (mci == null) {
                            mci = new ManagedConnectionInfo(mc);
                            this.mc2mci.put(mc, mci);
                        }
                        if (this.isEnabledDebug) {
                            trace.log(BasicLevel.DEBUG, (Object)("get a MC from the ra pool, mc=" + mci.mc));
                        }
                        if (this.transSupport.equalsIgnoreCase(LOCAL_TRANS_SUPPORT)) {
                            if (mci.lw == null) {
                                mci.lw = new LocalXAResource(mci.mc.getLocalTransaction(), trace);
                            }
                        } else if (mci.lw != null) {
                            mci.lw = null;
                        }
                        if (!mci.connectionEventListener) {
                            mci.mc.addConnectionEventListener((ConnectionEventListener)this);
                            mci.connectionEventListener = true;
                        }
                        mci.synchro = null;
                        if (currentTx != null) {
                            if (this.isEnabledDebug) {
                                trace.log(BasicLevel.DEBUG, (Object)("Enlist the XA Resource " + mci.getXAResource() + " in Tx:" + currentTx));
                            }
                            currentTx.enlistResource(mci.getXAResource());
                            this.usedMCs.put(currentTx, mci);
                            mci.setGlobalTx(currentTx);
                        } else {
                            mci.setGlobalTx(null);
                            this.mcs.add(mci);
                            if (!this.transSupport.equalsIgnoreCase(NO_TRANS_SUPPORT)) {
                                mci.rme = new JResourceManagerEvent(mci, trace);
                                if (this.isEnabledDebug) {
                                    trace.log(BasicLevel.DEBUG, (Object)"Register the managed connection (no tx)");
                                }
                                if (!mci.rmeCalled) {
                                    mci.rme.setValid(true);
                                    this.tm.notifyConnectionOpen((Enlistable)mci.rme);
                                    mci.rmeCalled = true;
                                }
                            }
                        }
                    }
                    catch (ResourceException re) {
                        trace.log(BasicLevel.ERROR, (Object)re.getMessage(), (Throwable)re);
                        throw re;
                    }
                    catch (Exception e) {
                        String err = "Error related allocation of ManagedConnection";
                        trace.log(BasicLevel.ERROR, (Object)err, (Throwable)e);
                        throw new ResourceException(err, (Throwable)e);
                    }
                }
                connection = mci.mc.getConnection(null, cxRequestInfo);
                mci.usedCs.add(connection);
            }
            if (!(connection instanceof Connection)) continue;
            try {
                if (connection instanceof IJDBCConnection) {
                    IJDBCConnection jdbcConnection = (IJDBCConnection)connection;
                    jdbcConnection.setJonasInfo(mci, this);
                    jdbcConnection.setUser();
                } else {
                    connection = SQLConnectionInvocationHandler.createSQLWrapper(connection, mci, this, trace);
                }
                if (this.jdbcConnLevel <= 0) continue;
                try {
                    if (this.isEnabledDebug) {
                        trace.log(BasicLevel.DEBUG, (Object)"Check the JDBC connection");
                    }
                    boolean isClosed = true;
                    isClosed = connection instanceof IJDBCConnection ? ((IJDBCConnection)connection).isPhysicallyClosed() : ((Connection)connection).isClosed();
                    if (isClosed) {
                        this.connectionErrorOccurred(new ConnectionEvent(mci.mc, 5));
                        try {
                            mci.usedCs.remove(connection);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        connection = null;
                        ++retries;
                        continue;
                    }
                    if (this.jdbcConnLevel <= 1 || this.jdbcConnTestStmt == null || this.jdbcConnTestStmt.length() <= 0) continue;
                    if (this.isEnabledDebug) {
                        trace.log(BasicLevel.DEBUG, (Object)("retrying connection: " + this.jdbcConnTestStmt));
                    }
                    Statement stmt = ((Connection)connection).createStatement();
                    stmt.execute(this.jdbcConnTestStmt);
                    stmt.close();
                }
                catch (Exception e) {
                    trace.log(BasicLevel.ERROR, (Object)("Error on connection: removing invalid managed connection " + mci.mc + ": "), (Throwable)e);
                    this.connectionErrorOccurred(new ConnectionEvent(mci.mc, 5));
                    try {
                        mci.usedCs.remove(connection);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    connection = null;
                    ++retries;
                }
            }
            catch (Exception ex) {
                trace.log(BasicLevel.ERROR, (Object)ex.getMessage(), (Throwable)ex);
                throw new ResourceException((Throwable)ex);
            }
        }
        if (this.isEnabledDebug) {
            trace.log(BasicLevel.DEBUG, (Object)("get a logical connection on MC:" + connection));
        }
        if (connection == null) {
            if (retries > 0) {
                throw new ResourceAllocationException("Unable to obtain a connection object.  Check the validity of the jdbc-test-statement");
            }
            throw new ResourceAllocationException("Unable to obtain a connection object");
        }
        return connection;
    }

    public boolean matchResource(Object res, Object hints) {
        return true;
    }

    public Object matchResource(Set res, Object hints) throws Exception {
        ConnectionResourceHint spec = hints != null ? (ConnectionResourceHint)hints : new ConnectionResourceHint(null, null);
        ManagedConnection con = null;
        try {
            con = this.mcf.matchManagedConnections(res, null, spec.cxRequestInfo);
        }
        catch (NotSupportedException nse) {
            // empty catch block
        }
        return con;
    }

    public Object createResource(Object hints) throws Exception {
        ConnectionResourceHint spec = hints != null ? (ConnectionResourceHint)hints : new ConnectionResourceHint(null, null);
        ManagedConnection mc = this.mcf.createManagedConnection(spec.subject, spec.cxRequestInfo);
        if (this.isEnabledDebug) {
            trace.log(BasicLevel.DEBUG, (Object)("Created MC: " + mc));
        }
        return mc;
    }

    public ValidatingManagedConnectionFactory getValidatingMCFactory() {
        return this.vmcf;
    }

    public PreparedStatement getPStatement(ManagedConnectionInfo mcinfo, Object conn, String user, String sql) throws SQLException {
        return this.getPStatement(mcinfo, conn, user, sql, 1003, 1007, -1, -1, null, null, 1);
    }

    public PreparedStatement getPStatement(ManagedConnectionInfo mcinfo, Object conn, String user, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getPStatement(mcinfo, conn, user, sql, resultSetType, resultSetConcurrency, -1, -1, null, null, 1);
    }

    public PreparedStatement getPStatement(ManagedConnectionInfo mcinfo, Object conn, String user, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getPStatement(mcinfo, conn, user, sql, resultSetType, resultSetConcurrency, resultSetHoldability, -1, null, null, 2);
    }

    public PreparedStatement getPStatement(ManagedConnectionInfo mcinfo, Object conn, String user, String sql, int autoGeneratedKeys) throws SQLException {
        return this.getPStatement(mcinfo, conn, user, sql, -1, -1, -1, autoGeneratedKeys, null, null, 3);
    }

    public PreparedStatement getPStatement(ManagedConnectionInfo mcinfo, Object conn, String user, String sql, int[] columnIndexes) throws SQLException {
        return this.getPStatement(mcinfo, conn, user, sql, -1, -1, -1, -1, columnIndexes, null, 4);
    }

    public PreparedStatement getPStatement(ManagedConnectionInfo mcinfo, Object conn, String user, String sql, String[] columnNames) throws SQLException {
        return this.getPStatement(mcinfo, conn, user, sql, -1, -1, -1, -1, null, columnNames, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getPStatement(ManagedConnectionInfo mcinfo, Object conn, String user, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, int pswrapType) throws SQLException {
        if (this.isEnabledDebug) {
            trace.log(BasicLevel.DEBUG, (Object)("Sql: " + sql + " User: " + user));
        }
        PreparedStatementWrapper psw = null;
        switch (pswrapType) {
            case 1: {
                psw = new PreparedStatementWrapper(user, sql, resultSetType, resultSetConcurrency, trace, this.isEnabledDebug);
                break;
            }
            case 2: {
                psw = new PreparedStatementWrapper(user, sql, resultSetType, resultSetConcurrency, resultSetHoldability, trace, this.isEnabledDebug);
                break;
            }
            case 3: {
                psw = new PreparedStatementWrapper(user, sql, autoGeneratedKeys, trace, this.isEnabledDebug);
                break;
            }
            case 4: {
                psw = new PreparedStatementWrapper(user, sql, columnIndexes, trace, this.isEnabledDebug);
                break;
            }
            case 5: {
                psw = new PreparedStatementWrapper(user, sql, columnNames, trace, this.isEnabledDebug);
                break;
            }
        }
        List list = mcinfo.pStmts;
        synchronized (list) {
            int indexPstmt;
            if (this.isEnabledDebug) {
                trace.log(BasicLevel.DEBUG, (Object)("MC pStmts: " + mcinfo.pStmts));
            }
            if ((indexPstmt = mcinfo.pStmts.lastIndexOf(psw)) != -1) {
                PreparedStatementWrapper ps = (PreparedStatementWrapper)mcinfo.pStmts.remove(indexPstmt);
                ps.clearPstmtValues();
                mcinfo.pStmts.add(ps);
                return ps;
            }
            if (this.isEnabledDebug) {
                trace.log(BasicLevel.DEBUG, (Object)"No statement in cache, need to build a new one");
            }
            PreparedStatement ps = null;
            switch (pswrapType) {
                case 1: {
                    ps = ((Connection)conn).prepareStatement(sql, resultSetType, resultSetConcurrency);
                    break;
                }
                case 2: {
                    ps = ((Connection)conn).prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                    break;
                }
                case 3: {
                    ps = ((Connection)conn).prepareStatement(sql, autoGeneratedKeys);
                    break;
                }
                case 4: {
                    ps = ((Connection)conn).prepareStatement(sql, columnIndexes);
                    break;
                }
                case 5: {
                    ps = ((Connection)conn).prepareStatement(sql, columnNames);
                    break;
                }
            }
            if (this.maxPstmtPoolSize < 0) {
                if (this.isEnabledDebug) {
                    trace.log(BasicLevel.DEBUG, (Object)"Pooling is disabled");
                }
                return ps;
            }
            if (this.maxPstmtPoolSize == 0 || mcinfo.pStmts.size() < this.maxPstmtPoolSize) {
                psw.setPreparedStatement(ps);
                mcinfo.pStmts.add(psw);
                if (this.isEnabledDebug) {
                    trace.log(BasicLevel.DEBUG, (Object)("Adding PStmt: " + psw));
                }
                return psw;
            }
            int offset = mcinfo.findFreeStmt();
            if (offset >= 0) {
                PreparedStatementWrapper pw = (PreparedStatementWrapper)mcinfo.pStmts.remove(offset);
                pw.destroy();
                psw.setPreparedStatement(ps);
                mcinfo.pStmts.add(psw);
                if (this.isEnabledDebug) {
                    trace.log(BasicLevel.DEBUG, (Object)("Replacing " + pw + " with " + psw));
                }
                return psw;
            }
            if (this.isEnabledDebug) {
                trace.log(BasicLevel.DEBUG, (Object)"No room in pool");
            }
            return ps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResource(Object rMc) throws Exception {
        if (this.isEnabledDebug) {
            trace.log(BasicLevel.DEBUG, (Object)("MC: " + rMc));
        }
        if (rMc instanceof ManagedConnection) {
            Pool pool = this.poolMCs;
            synchronized (pool) {
                ManagedConnection mc = (ManagedConnection)rMc;
                ManagedConnectionInfo mcinfo = (ManagedConnectionInfo)this.mc2mci.remove(mc);
                if (mcinfo != null) {
                    this.destroyPStmts(mcinfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyPStmts(ManagedConnectionInfo mcinfo) throws Exception {
        if (this.isEnabledDebug) {
            trace.log(BasicLevel.DEBUG, (Object)("ManagedConnectionInfo: " + mcinfo));
        }
        List list = mcinfo.pStmts;
        synchronized (list) {
            if (mcinfo.pStmts.size() <= 0) {
                return;
            }
            int stmtSize = mcinfo.pStmts.size();
            for (int i = 0; i < stmtSize; ++i) {
                PreparedStatementWrapper psw = (PreparedStatementWrapper)mcinfo.pStmts.remove(0);
                psw.closePstmt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(ConnectionEvent event) {
        Pool pool = this.poolMCs;
        synchronized (pool) {
            ManagedConnectionInfo mci;
            ManagedConnection mc = (ManagedConnection)event.getSource();
            if (mc == null) {
                trace.log(BasicLevel.ERROR, (Object)"no mc found in Event!");
            }
            if ((mci = (ManagedConnectionInfo)this.mc2mci.get(mc)) == null) {
                trace.log(BasicLevel.ERROR, (Object)"no mci found!");
                return;
            }
            if (this.isEnabledDebug) {
                trace.log(BasicLevel.DEBUG, (Object)("enter\n" + this.getState("\t")));
            }
            mci.usedCs.remove(event.getConnectionHandle());
            if (mci.usedCs.isEmpty()) {
                if (this.isEnabledDebug) {
                    trace.log(BasicLevel.DEBUG, (Object)"Last Connection has just been removed");
                }
                try {
                    Transaction currentTx = null;
                    if (this.tm != null) {
                        currentTx = this.tm.getTransaction();
                    }
                    if (mci.localTransaction && currentTx == null) {
                        trace.log(BasicLevel.ERROR, (Object)"The managed connection is being closed while a localtransaction is not finished");
                    }
                    if (currentTx != null) {
                        Transaction oldtx = (Transaction)mci.getGlobalTx();
                        if (oldtx != null && oldtx != currentTx) {
                            trace.log(BasicLevel.DEBUG, (Object)"This connection was used by another tx");
                            trace.log(BasicLevel.DEBUG, (Object)("old tx = " + oldtx));
                            trace.log(BasicLevel.DEBUG, (Object)("cur tx = " + currentTx));
                            this.usedMCs.remove(oldtx);
                        }
                        mci.setGlobalTx(currentTx);
                        if (mci.synchro == null) {
                            try {
                                if (currentTx.getStatus() != 3) {
                                    currentTx.registerSynchronization((Synchronization)new JSynchronization(this, mci));
                                    if (this.isEnabledDebug) {
                                        trace.log(BasicLevel.DEBUG, (Object)("registerSynchro mc=" + mci.mc));
                                    }
                                }
                            }
                            catch (RollbackException e) {
                                trace.log(BasicLevel.INFO, (Object)("registerSynchronization on transaction marked as Rollback only, mc=" + mci.mc));
                            }
                        }
                    } else if (mci.localTransaction) {
                        if (this.isEnabledDebug) {
                            trace.log(BasicLevel.DEBUG, (Object)"MC isn't released because local transaction is not finished");
                        }
                    } else {
                        if (this.isEnabledDebug) {
                            trace.log(BasicLevel.DEBUG, (Object)"no currentTx");
                        }
                        this.mcs.remove(mci);
                        if (mci.getGlobalTx() != null) {
                            this.usedMCs.remove(mci.getGlobalTx());
                            mci.setGlobalTx(null);
                        }
                        mci.mc.cleanup();
                        this.poolMCs.releaseResource(mci.mc, false);
                    }
                    if (mci.rmeCalled) {
                        mci.rme.setValid(false);
                        this.tm.notifyConnectionClose((Enlistable)mci.rme);
                        mci.rmeCalled = false;
                    }
                }
                catch (Exception e) {
                    trace.log(BasicLevel.ERROR, (Object)"an error during delisting of ManagedConection: ", (Throwable)e);
                }
                if (this.isEnabledDebug) {
                    trace.log(BasicLevel.DEBUG, (Object)("exit\n" + this.getState("\t")));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionErrorOccurred(ConnectionEvent event) {
        Pool pool = this.poolMCs;
        synchronized (pool) {
            ManagedConnectionInfo mci;
            ManagedConnection mc = (ManagedConnection)event.getSource();
            if (mc == null) {
                trace.log(BasicLevel.ERROR, (Object)"no mc found in Event!");
            }
            if ((mci = (ManagedConnectionInfo)this.mc2mci.get(mc)) == null) {
                trace.log(BasicLevel.ERROR, (Object)"no mci found!");
                return;
            }
            if (poolTrace.isLoggable(BasicLevel.DEBUG)) {
                poolTrace.log(BasicLevel.DEBUG, (Object)("enter\n" + this.getState("\t")));
            }
            mci.usedCs.clear();
            try {
                if (mci.rmeCalled) {
                    mci.rme.setValid(false);
                    this.tm.notifyConnectionError((Enlistable)mci.rme);
                    mci.rmeCalled = false;
                }
                mc.removeConnectionEventListener((ConnectionEventListener)this);
                if (mci.getGlobalTx() != null) {
                    this.usedMCs.remove(mci.getGlobalTx());
                    mci.setGlobalTx(null);
                } else {
                    this.mcs.remove(mci);
                }
                if (this.isEnabledDebug) {
                    trace.log(BasicLevel.DEBUG, (Object)("Destroying managed connection (" + mc + ")"));
                }
                this.destroyPStmts(mci);
                this.poolMCs.releaseResource(mc, true);
                if (poolTrace.isLoggable(BasicLevel.DEBUG)) {
                    poolTrace.log(BasicLevel.DEBUG, (Object)("enter\n" + this.getState("\t")));
                }
            }
            catch (Exception e) {
                trace.log(BasicLevel.ERROR, (Object)("Error when destroying connection: " + e));
            }
            finally {
                this.mc2mci.remove(mc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localTransactionCommitted(ConnectionEvent event) {
        Pool pool = this.poolMCs;
        synchronized (pool) {
            ManagedConnectionInfo mci;
            ManagedConnection mc = (ManagedConnection)event.getSource();
            if (mc == null) {
                trace.log(BasicLevel.ERROR, (Object)"no mc found in Event!");
            }
            if ((mci = (ManagedConnectionInfo)this.mc2mci.get(mc)) == null) {
                trace.log(BasicLevel.ERROR, (Object)"no mci found!");
                return;
            }
            mci.localTransaction = false;
            if (mci.usedCs.isEmpty()) {
                if (this.isEnabledDebug) {
                    trace.log(BasicLevel.DEBUG, (Object)"Close the managed connection");
                }
                if (mci.rmeCalled) {
                    mci.rme.setValid(false);
                    this.tm.notifyConnectionClose((Enlistable)mci.rme);
                    mci.rmeCalled = false;
                }
                if (mci.synchro == null) {
                    this.mcs.remove(mci);
                    if (mci.getGlobalTx() != null) {
                        this.usedMCs.remove(mci.getGlobalTx());
                        mci.setGlobalTx(null);
                    }
                    try {
                        mci.mc.cleanup();
                        this.poolMCs.releaseResource(mci.mc, false);
                    }
                    catch (Exception e) {
                        trace.log(BasicLevel.ERROR, (Object)"an error related ManagedConection release", (Throwable)e, (Object)"ConnectionManagerImpl", (Object)"localTransactionCommitted");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localTransactionRolledback(ConnectionEvent event) {
        Pool pool = this.poolMCs;
        synchronized (pool) {
            ManagedConnectionInfo mci;
            ManagedConnection mc = (ManagedConnection)event.getSource();
            if (mc == null) {
                trace.log(BasicLevel.ERROR, (Object)"no mc found in Event!");
            }
            if ((mci = (ManagedConnectionInfo)this.mc2mci.get(mc)) == null) {
                trace.log(BasicLevel.ERROR, (Object)"no mci found!");
                return;
            }
            mci.localTransaction = false;
            if (mci.usedCs.isEmpty()) {
                if (this.isEnabledDebug) {
                    trace.log(BasicLevel.DEBUG, (Object)"Close the managed connection");
                }
                if (mci.rmeCalled) {
                    mci.rme.setValid(false);
                    this.tm.notifyConnectionClose((Enlistable)mci.rme);
                    mci.rmeCalled = false;
                }
                if (mci.synchro == null) {
                    this.mcs.remove(mci);
                    if (mci.getGlobalTx() != null) {
                        this.usedMCs.remove(mci.getGlobalTx());
                        mci.setGlobalTx(null);
                    }
                    try {
                        mci.mc.cleanup();
                        this.poolMCs.releaseResource(mci.mc, false);
                    }
                    catch (Exception e) {
                        trace.log(BasicLevel.ERROR, (Object)"an error related during ManagedConection release:", (Throwable)e, (Object)"ConnectionManagerImpl", (Object)"localTransactionRolledback");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localTransactionStarted(ConnectionEvent event) {
        Pool pool = this.poolMCs;
        synchronized (pool) {
            ManagedConnectionInfo mci;
            ManagedConnection mc = (ManagedConnection)event.getSource();
            if (mc == null) {
                trace.log(BasicLevel.ERROR, (Object)"no mc found in Event!");
            }
            if ((mci = (ManagedConnectionInfo)this.mc2mci.get(mc)) == null) {
                trace.log(BasicLevel.ERROR, (Object)"no mci found!");
                return;
            }
            mci.localTransaction = true;
        }
    }

    public String toString() {
        String m = super.toString();
        int c1 = 0;
        int current = m.indexOf(".");
        while (current != -1) {
            c1 = current;
            current = m.indexOf(".", current + 1);
        }
        return m.substring(c1 + 1, m.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getState(String prefix) {
        String res = null;
        Pool pool = this.poolMCs;
        synchronized (pool) {
            res = prefix + "mcf=" + this.mcf + "\n";
            res = res + prefix + "ConnectionResourceHint=" + this.connectionResourceHint.toString() + "\n";
            res = res + prefix + "size of MC pool:" + this.poolMCs.getSize() + "\n";
            res = res + prefix + "size of usedMCs:" + this.usedMCs.size() + "\n";
            res = res + prefix + "mcs attached to a tx:\n";
            for (Object tx : this.usedMCs.keySet()) {
                ManagedConnectionInfo mci = (ManagedConnectionInfo)this.usedMCs.get(tx);
                res = res + prefix + "MCI : tx=" + tx + "\n";
                res = res + mci.getState(prefix + "\t");
            }
            res = res + prefix + "mcs not attached to a tx:\n";
            for (ManagedConnectionInfo mci : this.mcs) {
                res = res + mci.getState(prefix + "\t");
            }
            res = res + prefix + "mcs waiting for tx commit or rollback:\n";
            for (ManagedConnectionInfo mci : this.synchros) {
                res = res + mci.getState(prefix + "\t");
            }
        }
        return res;
    }

    public void setXAName(String xanm) {
        this.xaName = xanm;
    }

    public String getXAName() {
        return this.xaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerXAResource(Properties tmProp) {
        if (this.tm == null) {
            trace.log(BasicLevel.DEBUG, (Object)"No tm");
            return;
        }
        if (!this.transSupport.equalsIgnoreCase(XA_TRANS_SUPPORT)) {
            trace.log(BasicLevel.DEBUG, (Object)"No XA Support");
            return;
        }
        if (!this.tm.isRecoveryEnabled()) {
            trace.log(BasicLevel.DEBUG, (Object)"No transaction recovery enabled");
            return;
        }
        Pool pool = this.poolMCs;
        synchronized (pool) {
            ManagedConnectionInfo mci = null;
            XAResource xar = null;
            try {
                ManagedConnection mc = (ManagedConnection)this.poolMCs.getResource(this.connectionResourceHint);
                if (mc == null) {
                    if (this.isEnabledDebug) {
                        trace.log(BasicLevel.DEBUG, (Object)"Cannot allocate a ManagedConnection for registerXAResource");
                    }
                    return;
                }
                mci = (ManagedConnectionInfo)this.mc2mci.get(mc);
                if (mci == null) {
                    mci = new ManagedConnectionInfo(mc);
                    this.mc2mci.put(mc, mci);
                }
                xar = mc.getXAResource();
                if (this.isEnabledDebug) {
                    trace.log(BasicLevel.DEBUG, (Object)("got a MC from the ra pool, mc=" + mci.mc + " xar=" + xar));
                }
                if (!mci.connectionEventListener) {
                    mci.mc.addConnectionEventListener((ConnectionEventListener)this);
                    mci.connectionEventListener = true;
                }
                mci.synchro = null;
            }
            catch (ResourceException re) {
                return;
            }
            catch (Exception e) {
                trace.log(BasicLevel.ERROR, (Object)e.getMessage(), (Throwable)e);
                return;
            }
            this.jotmMc = mci.mc;
            this.jotmXar = xar;
            try {
                if (this.isEnabledDebug) {
                    trace.log(BasicLevel.DEBUG, (Object)("Registering name = " + this.xaName + " xar = " + this.jotmXar));
                }
                this.tm.registerResourceManager(this.xaName, this.jotmXar, "", tmProp, (TxResourceManager)this);
            }
            catch (Exception ex) {
                trace.log(BasicLevel.ERROR, (Object)ex.getMessage(), (Throwable)ex);
                this.freeXAResource(this.jotmXar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeXAResource(XAResource rmXares) {
        Pool pool = this.poolMCs;
        synchronized (pool) {
            if (this.isEnabledDebug) {
                trace.log(BasicLevel.DEBUG, (Object)("Removing name = " + this.xaName + " xar = " + this.jotmXar));
            }
            if (this.jotmXar == null) {
                return;
            }
            if (!rmXares.equals(this.jotmXar)) {
                trace.log(BasicLevel.ERROR, (Object)("XAResource of " + rmXares + " and " + this.jotmXar + " not equal!"));
                return;
            }
            ManagedConnectionInfo mci = (ManagedConnectionInfo)this.mc2mci.get(this.jotmMc);
            if (mci == null) {
                trace.log(BasicLevel.ERROR, (Object)("no mci found for " + this.jotmMc));
                return;
            }
            try {
                mci.mc.cleanup();
                this.poolMCs.releaseResource(mci.mc, false);
            }
            catch (Exception ex) {
                trace.log(BasicLevel.ERROR, (Object)ex.getMessage(), (Throwable)ex);
            }
            this.jotmMc = null;
            this.jotmXar = null;
        }
    }

    public Pool getPool() {
        return this.poolMCs;
    }

    public boolean isJdbcConnSetUp() {
        return this.jdbcConnSetUp;
    }

    public int getCheckLevel() {
        return this.jdbcConnLevel;
    }

    public void setCheckLevel(int level) {
        this.jdbcConnLevel = level;
    }

    public String getTestStatement() {
        return this.jdbcConnTestStmt;
    }

    public void setTestStatement(String stmt) {
        this.jdbcConnTestStmt = stmt;
    }

    public boolean isObservable() {
        return this.observable;
    }

    public void setObservable(boolean observable) {
        this.observable = observable;
        if (this.poolMCs != null) {
            this.poolMCs.setObservable(observable);
        }
    }

    public int getCurrentInTx() {
        return this.usedMCs.size();
    }

    public int getMaxPstmtPoolSize() {
        return this.maxPstmtPoolSize;
    }

    public void setMaxPstmtPoolSize(int maxPstmtPoolSize) {
        this.maxPstmtPoolSize = maxPstmtPoolSize;
    }

    public int[] getOpenedConnections(int usedTimeSec) {
        long millis = (long)usedTimeSec * 1000L;
        return this.poolMCs.getOpenedConnections(millis);
    }

    public int[] getOpenedConnections() {
        return this.poolMCs.getOpenedConnections(5000L);
    }

    public void forceCloseConnection(int connectionId) {
        this.poolMCs.forceCloseConnection(connectionId);
    }

    public Map getConnectionDetails(int connectionId) {
        ManagedConnection mc = this.poolMCs.getConnectionById(connectionId);
        Transaction mytx = null;
        if (this.usedMCs != null) {
            Set entrySet = this.usedMCs.entrySet();
            Iterator it = entrySet.iterator();
            while (it.hasNext()) {
                Transaction tx = (Transaction)it.next().getKey();
                ManagedConnectionInfo mci = (ManagedConnectionInfo)this.usedMCs.get(tx);
                if (mci == null || !mci.mc.equals(mc)) continue;
                mytx = tx;
                break;
            }
        }
        return this.poolMCs.getConnectionDetails(mc, mytx);
    }

    public List getSynchros() {
        return this.synchros;
    }

    public Map getUsedManagedConnections() {
        return this.usedMCs;
    }

    public List getManagedConnectionsWithoutTransaction() {
        return this.mcs;
    }
}

