/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class MetadataHelper {
    static Object invokeMethod(String methodName, Object target) {
        Method method = null;
        try {
            method = Helper.getDeclaredMethod(target.getClass(), methodName);
        }
        catch (NoSuchMethodException e) {
            EntityManagerSetupException.methodInvocationFailed(method, target, e);
        }
        if (method != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, target));
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw EntityManagerSetupException.cannotAccessMethodOnObject(method, target);
                        }
                        throw EntityManagerSetupException.methodInvocationFailed(method, target, throwableException);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod(method, target);
            }
            catch (IllegalAccessException ex1) {
                throw EntityManagerSetupException.cannotAccessMethodOnObject(method, target);
            }
            catch (InvocationTargetException ex2) {
                throw EntityManagerSetupException.methodInvocationFailed(method, target, ex2);
            }
        }
        return null;
    }
}

