/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.profiler;

import java.util.Hashtable;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class QueryMonitor {
    public static Hashtable cacheHits = new Hashtable();
    public static Hashtable cacheMisses = new Hashtable();
    public static long dumpTime = System.currentTimeMillis();
    public static Boolean shouldMonitor;

    public static boolean shouldMonitor() {
        if (shouldMonitor == null) {
            shouldMonitor = Boolean.FALSE;
            String property = System.getProperty("org.eclipse.persistence.querymonitor");
            if (property != null && property.toUpperCase().equals("TRUE")) {
                shouldMonitor = Boolean.TRUE;
            }
        }
        return shouldMonitor;
    }

    public static void checkDumpTime() {
        if (System.currentTimeMillis() - dumpTime > 100000L) {
            dumpTime = System.currentTimeMillis();
            System.out.println("Cache Hits:" + cacheHits);
            System.out.println("Cache Misses:" + cacheMisses);
        }
    }

    public static void incrementReadObjectHits(ReadObjectQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName() + "-findByPrimaryKey";
        Number hits = (Number)cacheHits.get(name);
        if (hits == null) {
            hits = new Integer(0);
        }
        hits = new Integer(hits.intValue() + 1);
        cacheHits.put(name, hits);
    }

    public static void incrementReadObjectMisses(ReadObjectQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName() + "-findByPrimaryKey";
        Number misses = (Number)cacheMisses.get(name);
        if (misses == null) {
            misses = new Integer(0);
        }
        misses = new Integer(misses.intValue() + 1);
        cacheMisses.put(name, misses);
    }

    public static void incrementReadAllHits(ReadAllQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName();
        name = query.getName() == null ? name + "-findAll" : name + "-" + query.getName();
        Number hits = (Number)cacheHits.get(name);
        if (hits == null) {
            hits = new Integer(0);
        }
        hits = new Integer(hits.intValue() + 1);
        cacheHits.put(name, hits);
    }

    public static void incrementReadAllMisses(ReadAllQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName();
        name = query.getName() == null ? name + "-findAll" : name + "-" + query.getName();
        Number misses = (Number)cacheMisses.get(name);
        if (misses == null) {
            misses = new Integer(0);
        }
        misses = new Integer(misses.intValue() + 1);
        cacheMisses.put(name, misses);
    }

    public static void incrementInsert(WriteObjectQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName() + "-insert";
        Number misses = (Number)cacheMisses.get(name);
        if (misses == null) {
            misses = new Integer(0);
        }
        misses = new Integer(misses.intValue() + 1);
        cacheMisses.put(name, misses);
    }

    public static void incrementUpdate(WriteObjectQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName() + "-update";
        Number misses = (Number)cacheMisses.get(name);
        if (misses == null) {
            misses = new Integer(0);
        }
        misses = new Integer(misses.intValue() + 1);
        cacheMisses.put(name, misses);
    }

    public static void incrementDelete(DeleteObjectQuery query) {
        QueryMonitor.checkDumpTime();
        String name = query.getReferenceClass().getName() + "-delete";
        Number misses = (Number)cacheMisses.get(name);
        if (misses == null) {
            misses = new Integer(0);
        }
        misses = new Integer(misses.intValue() + 1);
        cacheMisses.put(name, misses);
    }
}

