/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.utils.ArchiveStorer;

public class DirStorer
extends ArchiveStorer {
    private File base;

    public DirStorer(J2EEArchive archive, File dir) throws GenBaseException {
        super(archive);
        this.setOut(dir.getAbsolutePath());
        if (!dir.exists() && !dir.mkdirs()) {
            String err = DirStorer.getI18n().getMessage("DirStorer.constr.create", (Object)dir);
            throw new GenBaseException(err);
        }
        this.base = dir;
    }

    protected String convertName(String name) {
        return name.replace('/', File.separatorChar);
    }

    protected void addFile(String name) throws IOException {
        OutputStream fos = this.getOutputStream(name);
        InputStream is = this.getArchive().getInputStream(name);
        DirStorer.fill(is, fos);
        is.close();
        fos.close();
    }

    protected OutputStream getOutputStream(String name) throws IOException {
        File out = new File(this.base, this.convertName(name));
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            String err = DirStorer.getI18n().getMessage("DirStorer.getOutputStream.create", (Object)out);
            throw new IOException(err);
        }
        FileOutputStream os = new FileOutputStream(out);
        return os;
    }
}

