/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.rmi.server.RemoteStub;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JEntityLocalHome;
import org.ow2.jonas.lib.ejb21.JLocalHome;
import org.ow2.jonas.lib.ejb21.JStatefulSwitch;
import org.ow2.jonas.lib.ejb21.JWrapper;
import org.ow2.jonas.lib.ejb21.TraceEjb;

public class JStatefulInputStream
extends ObjectInputStream {
    private JStatefulSwitch jss;

    public JStatefulInputStream(InputStream in, JStatefulSwitch jss) throws IOException {
        super(in);
        TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"constructor");
        this.enableResolveObject(true);
        this.jss = jss;
    }

    protected Object resolveObject(Object obj) throws IOException {
        Object ret;
        if (obj instanceof HomeHandle) {
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"HomeHandle");
            ret = ((HomeHandle)obj).getEJBHome();
        } else if (obj instanceof Handle) {
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"Handle");
            ret = ((Handle)obj).getEJBObject();
        } else if (obj instanceof JWrapper) {
            int type = ((JWrapper)obj).getType();
            switch (type) {
                case 5: {
                    TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"JEntityLocal");
                    String jndiname = (String)((JWrapper)obj).getObject();
                    Object pk = ((JWrapper)obj).getPK();
                    JEntityLocalHome lhome = (JEntityLocalHome)JLocalHome.getLocalHome(jndiname);
                    ret = lhome.findLocalByPK(pk);
                    break;
                }
                case 4: {
                    TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"JLocalHome");
                    String jname = (String)((JWrapper)obj).getObject();
                    ret = JLocalHome.getLocalHome(jname);
                    break;
                }
                case 1: {
                    TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"UserTransaction");
                    ret = this.jss.getStatefulContext().getUserTransaction();
                    break;
                }
                case 2: {
                    TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"SessionContext");
                    ret = this.jss.getStatefulContext();
                    break;
                }
                case 6: {
                    TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"ComponentContext");
                    String cname = (String)((JWrapper)obj).getObject();
                    try {
                        InitialContext ictx = new InitialContext();
                        ret = ictx.lookup(cname);
                        break;
                    }
                    catch (NamingException e) {
                        TraceEjb.ssfpool.log(BasicLevel.ERROR, (Object)("Cannot retrieve NamingContext" + e));
                        throw new IOException("Cannot retrieve NamingContext");
                    }
                }
                case 3: {
                    Handle theHandle;
                    TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"Handle");
                    JWrapper theJWrapper = (JWrapper)obj;
                    byte[] ser = (byte[])theJWrapper.getObject();
                    ByteArrayInputStream bais = new ByteArrayInputStream(ser);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    try {
                        theHandle = (Handle)ois.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        throw new IOException(e.getMessage());
                    }
                    ret = theHandle;
                    break;
                }
                default: {
                    TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"Other wrapped object");
                    ret = ((JWrapper)obj).getObject();
                    break;
                }
            }
        } else if (obj instanceof RemoteStub) {
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"RemoteStub");
            ret = obj;
        } else {
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"Other");
            ret = obj;
        }
        return ret;
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)v);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl.loadClass(v.getName());
    }
}

