/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genic;

import java.util.Collection;
import java.util.Set;
import org.ow2.jonas.deployment.ejb.EjbRelationshipRoleDesc;
import org.ow2.jonas.deployment.ejb.EntityCmp2Desc;
import org.ow2.jonas.generators.genic.GenICException;
import org.ow2.jonas.lib.util.BeanNaming;

public class VcCMRField {
    private String name;
    private String uFLName;
    private String typeName;
    private EjbRelationshipRoleDesc rsr;
    private EjbRelationshipRoleDesc rsr2;
    private byte relationType = (byte)-1;
    private String genClassName = null;
    private EntityCmp2Desc element = null;

    public VcCMRField(EjbRelationshipRoleDesc rsr) throws GenICException {
        this.rsr = rsr;
        this.name = rsr.getCmrFieldName();
        this.uFLName = this.upperFL(this.name);
        this.element = rsr.getTargetBean();
        this.typeName = rsr.getCmrFieldType().getName();
        if (rsr.isTargetMultiple()) {
            if (Collection.class.equals((Object)rsr.getCmrFieldType())) {
                this.genClassName = "org.ow2.jonas.lib.ejb21.jorm.Set";
            } else if (Set.class.equals((Object)rsr.getCmrFieldType())) {
                this.genClassName = "org.ow2.jonas.lib.ejb21.jorm.Set";
            } else {
                throw new GenICException("Unauthorized multivalued relation type:" + rsr.getCmrFieldType());
            }
        }
        this.rsr2 = rsr.getOppositeRelationshipRole();
        this.relationType = rsr.getRelationType();
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getUFLName() {
        return this.uFLName;
    }

    public String jormGetter() {
        return "paGet" + this.getUFLName();
    }

    public String jormSetter() {
        return "paSet" + this.getUFLName();
    }

    public EjbRelationshipRoleDesc getRsr() {
        return this.rsr;
    }

    public String getOppositeUFLCMRName() {
        return this.upperFL(this.rsr2.getCmrFieldName());
    }

    public String getHelperClassName() {
        return "JOnAS" + this.rsr.getSourceBeanName() + "CoherenceHelper";
    }

    public String getHelperFQClassName() {
        String pn = BeanNaming.getPackageName((String)this.rsr2.getTargetBean().getFullDerivedBeanName());
        if (pn != null && pn.length() > 0) {
            return pn + "." + this.getHelperClassName();
        }
        return this.getHelperClassName();
    }

    public String getOppositeHelperClassName() {
        return "JOnAS" + this.rsr2.getSourceBeanName() + "CoherenceHelper";
    }

    public String getOppositeHelperFQClassName() {
        String pn = BeanNaming.getPackageName((String)this.rsr.getTargetBean().getFullDerivedBeanName());
        if (pn != null && pn.length() > 0) {
            return pn + "." + this.getOppositeHelperClassName();
        }
        return this.getOppositeHelperClassName();
    }

    public String getGenClassName() {
        return this.genClassName;
    }

    public EntityCmp2Desc getElement() {
        return this.element;
    }

    public String upperFL(String word) {
        return Character.toUpperCase(word.charAt(0)) + word.substring(1);
    }

    public boolean isOOu() {
        return this.relationType == 0;
    }

    public boolean isOOb() {
        return this.relationType == 1;
    }

    public boolean isOMu() {
        return this.relationType == 2;
    }

    public boolean isMOu() {
        return this.relationType == 4;
    }

    public boolean isMOb() {
        return this.relationType == 5;
    }

    public boolean isOMb() {
        return this.relationType == 3;
    }

    public boolean isMMu() {
        return this.relationType == 6;
    }

    public boolean isMMb() {
        return this.relationType == 7;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\n    Name                 = " + this.getName());
        ret.append("\n    TypeName             = " + this.getTypeName());
        ret.append("\n    UFLName              = " + this.getUFLName());
        ret.append("\n    OppositeUFLCMRName   = " + this.getOppositeUFLCMRName());
        ret.append("\n    HelperClassName      = " + this.getHelperClassName());
        ret.append("\n    HelperFQClassName    = " + this.getHelperFQClassName());
        ret.append("\n    OppositeHelperClassName   = " + this.getOppositeHelperClassName());
        ret.append("\n    OppositeHelperFQClassName = " + this.getOppositeHelperFQClassName());
        ret.append("\n    GenClassName         = " + this.getGenClassName());
        ret.append("\n    isOOu                = " + this.isOOu());
        ret.append("\n    isOOb                = " + this.isOOb());
        ret.append("\n    isOMu                = " + this.isOMu());
        ret.append("\n    isOMb                = " + this.isOMb());
        ret.append("\n    isMOb                = " + this.isMOb());
        ret.append("\n    isMNu                = " + this.isMMu());
        ret.append("\n    isMNb                = " + this.isMMb());
        return ret.toString();
    }
}

